import Scene from "../views/Scene";
import MyImage from "./MyImage";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { GTime } from "../../libs/tc/util/GTime";
import { TimeFormat } from "../../libs/tc/enum/TimeFormat";
import Panel from "../views/Panel";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
import { Buried } from "../../libs/tw/util/Buried";
import ComponentBase from "../components/ComponentBase";
import GuidePanel from "../guidePanel/GuidePanel";
import { GCache } from "../../libs/tc/util/GCache";
import Loading from "../loading/Loading";
import { GetPrizeInfoData } from "../../libs/tw/data/plug/getPrizeInfo/GetPrizeInfoData";
import { ABNetManager } from "../../libs/tc/manager/ABNetManager";
import FriendItem from "./FriendItem";

export default class MainScene extends Scene {

	public topGroup:eui.Group;
	public team_0:eui.Group;
	public team_1:eui.Group;
	public team_2:eui.Group;
	public team_3:eui.Group;
	public team_4:eui.Group;
	public team_5:eui.Group;
	public bottomGroup:eui.Group;
	public doglist_0:eui.Group;
	public doglist_1:eui.Group;
	public doglist_2:eui.Group;
	public doglist_3:eui.Group;
	public doglist_4:eui.Group;
	public doglist_5:eui.Group;
	public doglist_6:eui.Group;
	public doglist_7:eui.Group;
	public doglist_8:eui.Group;
	public doglist_9:eui.Group;
	public doglist_10:eui.Group;
	public doglist_11:eui.Group;



	public get skinKey() { return 'MainScene' }
	public get groupName() { return 'main_scene' }

	private teams=[];
	constructor(data?) {
		super(data);
		if (data) {
		
		}
		this.percentHeight = 100;
	}

	initEvents() {
		GDispatcher.addEvent(ABNetManager.ERROR, this.onError, this);


		//setTimeout(()=>{
			for(let i=0;i<6;i++){
				this.teams[i]=new FriendItem()
				this.teams[i].x=0;
				this.teams[i].y=0;
				this["team_"+i].addChild(this.teams[i])
				this.teams[i].loadVal=40
				this.teams[i].setLoadVal()
				this.teams[i].setState(false)
			}
		//},1000)
		
	}

	private onError(net: any, code: any): void {
		console.log(code);
		var msg: string;
		var msgArr: any = window['errorMessage'];
		if (!isNaN(code)) {
			msg = msgArr[code] ? msgArr[code] : '额哦，一个未知的错误';
		} else {
			msg = code;
		}

		PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, [msg], false);
	}
	removeEvents() {
		this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
		GDispatcher.removeEvent(ABNetManager.ERROR, this.onError, this);
	}

	protected onSkinComplete(): void {
		super.onSkinComplete();

	}

	start(data?) {

	}

	protected onLoad(): void {
		this.initUI();

		this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
	}

	private initUI(): void {
		//初始化数据
		this.initData();

	}
	private initData(): void {
	}


	private onEnterFrame(): void{

	}

}