import Panel from "../views/Panel";
import { MUtils } from "../MUtils";

export default class QuestListPanel extends Panel {
    public get skinKey() { return "QuestListPanel" }
    public get groupName() { return "quest_list" }

    public progressVisit: eui.ProgressBar;
    public btnDo0: eui.Button;
    public btnDo1: eui.Button;
    public btnDo2: eui.Button;
    public btnDo3: eui.Button;
    public btnDo4: eui.Button;

    /* private btnTexTodo: egret.Texture = null;
    private btnTexDoing: egret.Texture = null;
    private btnTexDone: egret.Texture = null; */

    constructor(data?: any) {
        super(data);
    }

    start(data?: any) {
        super.start(data);
    }

    /* protected async preLoadRes() {
        return RES.loadGroup(this.groupName);
    } */

    async initEvents() {
        super.initEvents();

        this.questMap["0"] = new Quest(this.btnDo0, 1, () => {
            console.warn("去完成首次到访");
        });
        this.questMap["1"] = new Quest(this.btnDo1, 0, () => {
            console.warn("去完成个人中心签到");
        });
        this.questMap["2"] = new Quest(this.btnDo2, 3, () => {
            console.warn("去完成每日分享");
        });
        this.questMap["3"] = new Quest(this.btnDo3, 2, () => {
            console.warn("去完成收藏歌曲");
            
        });
        this.questMap["4"] = new Quest(this.btnDo4, 1, () => {
            console.warn("去完成收听歌曲");
        });
    }

    private questMap = {};
    removeEvents(): void {
        super.removeEvents();
    }
}

class Quest {
    constructor(button: eui.Button, statusCode: number, todoCallback: () => void) {
        this.button = button;
        this.statusCode = statusCode;
        this.todoCallback = todoCallback;
        button.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickBtn, this);
    }

    private button: eui.Button = null;

    private _statusCode: number = 0;
    public set statusCode(v: number) {
        switch (v) {
            case 0:
                this.button.enabled = true;
                this.setButtonImage("quest_list_btn_todo_png");
                break;
            case 1:
                this.button.enabled = false;
                this.setButtonImage("quest_list_btn_doing_png");
                break;
            case 2:
                this.button.enabled = false;
                this.setButtonImage("quest_list_btn_done_png")
                break;
            case 3:
                this.button.enabled = true;
                this.setButtonImage("quest_list_btn_receive_png")
                break;
            default:
                break;
        }
        this._statusCode = v;
    }
    public get statusCode() {
        return this._statusCode;
    }

    private setButtonImage(name: string) {
        MUtils.setButtonImage(this.button, RES.getRes(name));
    }

    private todoCallback: () => void = null;

    private onClickBtn() {
        switch (this.statusCode) {
            case 0: //去进行
                console.log("去进行");
                this.todoCallback();
                break;
            case 3://可领取
                console.log("可领取");
                break;
            default:
                break;
        }
    }
}