export default class MTimer {
    public static init() {
        egret.MainContext.instance.stage.addEventListener(egret.Event.ENTER_FRAME, () => {
            for (let i = 0; i < MTimer.onFrameList.length; i++) {
                MTimer.onFrameList[i](egret.Timer.deltaTime, MTimer.onFrameList[i]);
            }
        }, MTimer);
    }
    private static onFrameList: ((dt: number, self: Function) => void)[] = [];
    private static removeOnFrame(callback: Function) {
        MTimer.onFrameList = MTimer.onFrameList.filter(e => e != callback);
    }

    /* private timerObjectList: MTimerObject[] = [];
    private context: egret.EventDispatcher = null; */

    /* constructor(context: egret.EventDispatcher) {
        context.addEventListener(egret.Event.REMOVED_FROM_STAGE, this.onDestroy, this);
        this.context = context;
    } */

    /**
     * 
     * @param time 每次计时间隔 单位毫秒
     * @param onTimeOut 每次时间到时的回调函数
     * @param repeat 重复计时次数 默认为1
     * @param onRepeated 所有计时完成时的回调函数
     */
    /* public static set(time: number, onTimeOut: () => void, repeat?: number, onRepeated?: () => void): MTimerObject {
        let timer = new MTimerObject(time, onTimeOut, repeat, () => {
            onRepeated && onRepeated();
            //执行完毕，在列表中删除自身
            this.timerObjectList.splice(this.timerObjectList.indexOf(timer), 1);
        });
        this.timerObjectList.push(timer);
        return timer;
    } */

    public static onFrame(callback: (deltaTime: number, remove?: () => void) => void, frameCount?: number) {
        if (typeof frameCount != "undefined") {
            let count = 0;
            MTimer.onFrameList.push((deltaTime: number, self: Function) => {
                callback(deltaTime);
                count++;
                if (count >= frameCount) {
                    MTimer.removeOnFrame(self);
                }
            });
        } else {
            MTimer.onFrameList.push((deltaTime: number, self: Function) => {
                callback(deltaTime, () => {
                    MTimer.removeOnFrame(self);
                });
            });
        }
    }

    /* public static delay(time: number): Promise<void> {
        return new Promise<void>(resolve => {
            this.set(time, () => {
                resolve();
            });
        });
    } */

    /* private onDestroy() {
        this.timerObjectList.forEach(e => e.destroy());
        this.timerObjectList = null;
    } */
}


class MTimerObject {
    private timer: egret.Timer = null;

    constructor(time: number, onTimeOut: () => void, repeat?: number, onRepeated?: () => void) {
        //创建一个计时器对象
        let timer: egret.Timer = new egret.Timer(time, repeat || 1);
        //注册事件侦听器
        timer.addEventListener(egret.TimerEvent.TIMER, onTimeOut, this);
        timer.addEventListener(egret.TimerEvent.TIMER_COMPLETE, onRepeated || (() => { }), this);
        //开始计时
        timer.start();
        this.timer = timer;
    }

    destroy() {
        this.timer.stop();
        this.timer = null;
    }
}