import MSVGAClip from "./MSVGAClip";

// let deltaTimeBeforPause: number;
export function customClassPrototype() {
    egret.EventDispatcher.prototype.onTap = function (target: any, callback: () => void) {
        this.addEventListener(egret.TouchEvent.TOUCH_TAP, callback, target);
    }

    egret.DisplayObject.prototype.destroy = function () {
        if (this.parent) {
            this.parent.removeChild(this);
        }
    }

    String.prototype.isLowerCase = function (this: string) {
        if (this.length != 1) return false;
        return this >= 'A' && this <= 'Z';
    }

    String.prototype.isUpperCase = function (this: string) {
        if (this.length != 1) return false;
        return this >= 'A' && this <= 'Z';
    }

    Math.clamp = function (target: number, min: number, max: number) {
        if (target > max) target = max;
        if (target < min) target = min;
        return target;
    }

    egret.Timer["_deltaTime"] = 0;
    egret.Timer["_lastTime"] = 0;
    egret.Timer["_curTime"] = 0;
    egret.Timer["_updateDeltaTime"] = function () {
        egret.Timer["_lastTime"] = egret.Timer["_curTime"];
        egret.Timer["_curTime"] = egret.getTimer();
        egret.Timer["_deltaTime"] = egret.Timer["_curTime"] - egret.Timer["_lastTime"];
    }
    Object.defineProperty(egret.Timer, "deltaTime", {
        get: function () {
            return this["_deltaTime"];
        }
    });
    egret.MainContext.instance.stage.addEventListener(egret.Event.ENTER_FRAME, function () {
        egret.Timer["_updateDeltaTime"]();
    }, null);

    egret.lifecycle.onPause = () => {
        // deltaTimeBeforPause = egret.getTimer() - egret.Timer["_curTime"];
    }
    egret.lifecycle.onResume = () => {
        egret.Timer["_curTime"] = egret.getTimer(); /* - deltaTimeBeforPause || 0; */
    }

    Array.prototype.remove = function (element: any) {
        return this.filter((e: any) => e != element);
    }
}