import Panel from "../views/Panel";
import { Decorator } from "../Decorator/Decorator";
import MButton from "../MUI/MButton";
import SceneCtrl from "../Ctrls/SceneCtrl";
import StartScene from "../Scene/StartScene";

@Decorator.ClassName("WinningPanel")
export default class WinningPanel extends Panel {
    public labelScore: eui.Label;
    public labelHighestScore: eui.Label;
    public imgReward: eui.Image;
    public labelCoinNum: eui.Label;
    public btnClose: MButton;
    data: {
        score: number,
        highestScore: number,
        rewardImgUrl: string,
        rewardName: number
    }

    onSkinComplete() {
        super.onSkinComplete();
        this.btnClose.onTap(this, () => {
            this.hidePanel();
            SceneCtrl.instance.change(StartScene);
        });
        this.labelScore.text = this.data.score.toString() + "分";
        this.labelHighestScore.text = this.data.highestScore.toString() + "分";
        this.imgReward.source = this.data.rewardImgUrl;
        this.labelCoinNum.text = this.data.rewardName + "已入账";
    }
}