import MItem from "../components/MItem";
import { MConfigs } from "../Global/MConfigs";
import MButton from "../MUI/MButton";
import { Decorator } from "../Decorator/Decorator";

export default class PropsItem extends MItem {
    public img: eui.Image;
    public cornerMark: eui.Image;
    public labelNum: eui.Label;
    data: {
        id: string,
        num: number
    }

    constructor() {
        super();
        this.skinName = "resource/skins/PropsItem.exml";
    }

    dataChanged() {
        const config = MConfigs.props[this.data.id];
        this.img.source = RES.getRes(config.img);
        this.cornerMark.source = RES.getRes(`props_corner_mark_${config.index}_png`);
        this.labelNum.textColor = config.color;
        this.labelNum.text = this.data.num.toString();
    }
}