import Net from "./Net";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { Buried } from "../../libs/tw/util/Buried";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { MUtils } from "./MUtils";

export namespace NetUtils {
    export function createSgin(ticketId: number, score: number, gameData: any, submitToken: string): string {
        return window['duiba_md5'](ticketId + '' + score + '' + gameData + '' + submitToken);
    }

    export function getOrderId() {
        return Net.cache[NetUtils.getCFG()["doJoin"]]["orderId"];
    }

    export function gameSubmit(params: {
        orderId: any,
        score: any,
        submitToken: any
    }, onSuccess: (res: any) => void, onFail?: (res: any) => any) {
        let sgin = createSgin(params.orderId, params.score, "[]", params.submitToken);
        Net.sendPost('/hdtool/recon/ngame/ngameSubmit', {
            orderId: params.orderId,
            score: params.score,
            gameData: "[]",
            sgin: sgin,
            dynamicData: JSON.stringify(`{t2:${new Date().getTime()}}`),
            rankId: window["rankId"]
        }, onSuccess, onFail);

    }

    export function ajaxElement(onSuccess: (res: any) => void, onFail?: (res: any) => void) {
        let cfg = NetUtils.getCFG();
        Net.sendPost(cfg["getElement"], {
            hdType: cfg["hdType"],
            hdToolId: cfg["hdToolId"],
            actId: cfg["actId"],
            preview: cfg["preview"]
        }, onSuccess, onFail);
    }


    export function encryptSeq(seq: number) {
        return 5 * seq - MUtils.random(0, 4);
    }

    export function md5(str: string) {
        return window['duiba_md5'](str);
    }
    export function getTimestamp() {
        return Date.now();
    }

    export function getCFG(): object {
        return window['CFG'];
    }
}