// export const MConfigs: any = window;
export namespace MConfigs {
    export const size = [0.3125, 0.5357, 0.7321, 1];
    export const drop = {
        0: {
            type: "bullet",
            value: 1,
            textColor: 0x5dcefa,
            fileIndex: "0"
        },
        1: {
            type: "bullet",
            value: 2,
            textColor: 0x69e7fc,
            fileIndex: "1"
        },
        2: {
            type: "power",
            value: 30,
            textColor: 0xe83cf7,
            fileIndex: "2"
        },
        3: {
            type: "power",
            value: 20,
            textColor: 0xeb3924,
            fileIndex: "1"
        },
        4: {
            type: "power",
            value: 10,
            textColor: 0xfef552,
            fileIndex: "0"
        }
    }

    export const dropPool = {
        0: {
            num: 3,
            factor: {
                0: 40,
                1: 0,
                2: 0,
                3: 15,
                4: 50
            }
        },
        1: {
            num: 2,
            factor: {
                0: 40,
                1: 0,
                2: 5,
                3: 15,
                4: 50
            }
        },
        2: {
            num: 1,
            factor: {
                0: 40,
                1: 0,
                2: 5,
                3: 15,
                4: 50
            }
        }
    }

    export const props: {
        [key: string]: {
            id: string,
            name: string,
            img: string,
            color: number,
            disabledImg: string,
            index: number
        }
    } = {
        "sp_1": {
            index: 0,
            id: "sp_1",
            name: "100分加分卡",
            img: "score_card_100_png",
            disabledImg: null,
            color: 0xf9b74b
        },
        "sp_2": {
            index: 1,
            id: "sp_2",
            name: "500分加分卡",
            img: "score_card_500_png",
            disabledImg: null,
            color: 0xfe93df
        },
        "sp_11": {
            index: 2,
            id: "sp_11",
            name: "复活卡",
            img: "revive_card_png",
            disabledImg: "disabled_revive_card_png",
            color: 0x39c6e1
        }
    }

    export const selectPropsCountDown = 10;

    export const boomEffectColor = [
        0xe41014,
        0xff9600,
        0x0090ff,
        0x8aff00,
        0xffe720
    ]

    /**倒计时秒数 */
    export const countDown = 300;

    export const task: {
        [key: string]: {
            taskCode: string,
            content: string,
            btnText: string
        }
    } = {
        "aaa": {
            taskCode: "aaa",
            content: "去签到领金币\n获得一次游戏机会",
            btnText: "去签到"
        },
        "bbb": {
            taskCode: "bbb",
            content: "去下载x应用\n获得一次游戏机会",
            btnText: "去下载"
        },
        "ccc": {
            taskCode: "ccc",
            content: "去健康运动完成打卡\n获得一次游戏机会",
            btnText: "去下载"
        }
    }
}