export default class PlayerController extends eui.UILayer {
    public onTouchMove: (deltaX: number) => void = null;

    private touchId: number = null;
    private lastX: number = null;
    constructor() {
        super();
        this.addEventListener(egret.TouchEvent.TOUCH_BEGIN, (e: egret.TouchEvent) => {
            this.touchId = e.touchPointID;
            this.lastX = e.stageX;
        }, this);
        this.addEventListener(egret.TouchEvent.TOUCH_MOVE, (e: egret.TouchEvent) => {
            if (e.touchPointID != this.touchId || this.touchId == null || this.lastX == null) return;

            this.onTouchMove && this.onTouchMove(e.stageX - this.lastX)
            this.lastX = e.stageX;
        }, this);
        this.removeEventListener(egret.TouchEvent.TOUCH_END, (e: egret.TouchEvent) => {
            if (e.touchPointID != this.touchId) return;

            this.touchId = null;
            this.lastX = null;
        }, this);
    }
}