import { Data } from './../Data';
export class GooutRewardData extends Data {
    /**
     * 是否有奖励
     */
    public hasReward:boolean;

    /**
     * 出游地图大区，1：中国，2：亚洲，3：欧洲
     */
    public mapType:number;

    /**
     * 发奖插件id
     */
    public pluginId:number;

    
    public update(result: any): void {
        if (!result) {
            return;
        }
        super.update(result);

        if(result.data){
            this.hasReward = result.data.hasReward;
            this.mapType = result.data.mapType;
            this.pluginId = result.data.pluginId;
        }
    }
}