"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("../utils");
/**
 * 单条收支记录
 */
var FriendItem = (function (_super) {
    __extends(FriendItem, _super);
    function FriendItem(data) {
        var _this = _super.call(this) || this;
        _this.loadVal = 0;
        _this.state = false;
        _this.skinName = utils_1.getSkinPath('FrendItem');
        _this.touchChildren = true;
        _this.init();
        return _this;
    }
    FriendItem.prototype.init = function () {
        this.load_1.mask = this.mask_load_1;
        this.load_2.mask = this.mask_load_2;
        this.photoImg.mask = this.photoMask;
    };
    FriendItem.prototype.setState = function (state) {
        this.photoGroup.visible = false;
        this.addGroup.visible = false;
        this.LoadGroup.visible = false;
        this.state = state;
        if (state) {
            this.photoGroup.visible = true;
            this.LoadGroup.visible = true;
        }
        else {
            this.addGroup.visible = true;
        }
    };
    FriendItem.prototype.setLoadVal = function (loadVal) {
        this.loadVal = loadVal;
        if (this.loadVal == 75) {
            this.loadVal = 75.01;
        }
        if (this.loadVal <= 50) {
            this.load_2.rotation = 180;
            this.load_1.rotation = 180 * this.loadVal / 50;
        }
        else {
            this.load_1.rotation = 180;
            this.load_2.rotation = 180 + (180 * (this.loadVal - 50) / 50);
        }
    };
    FriendItem.prototype.setImgUrl = function (url) {
        this.url = url;
        this.photoImg.source = url;
    };
    return FriendItem;
}(eui.Component));
exports.default = FriendItem;
__reflect(FriendItem.prototype, "\"c:/Users/duiba/Documents/kuwo/egret/src/mainScene/FriendItem\".FriendItem");
//# sourceMappingURL=FriendItem.js.map