import Scene from "../views/Scene";
import MyImage from "./MyImage";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { GTime } from "../../libs/tc/util/GTime";
import { TimeFormat } from "../../libs/tc/enum/TimeFormat";
import Panel from "../views/Panel";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
import { FoodItem } from "./FoodItem";
import { Buried } from "../../libs/tw/util/Buried";
import ComponentBase from "../components/ComponentBase";
import GuidePanel from "../guidePanel/GuidePanel";
import { GCache } from "../../libs/tc/util/GCache";
import Loading from "../loading/Loading";
import { GetPrizeInfoData } from "../../libs/tw/data/plug/getPrizeInfo/GetPrizeInfoData";
import { ABNetManager } from "../../libs/tc/manager/ABNetManager";

const ADD_SPEED: number = 0.03;
const DISAPPEAR_SP: number = -703;//856
//喂食按钮动画运动时间间隔
const F_TIME_SPACE: number = 600;
//喂食按钮初始角度
const F_ANGLE: number = 7;
//清晨
const MORNING_SECOND = 6 * 3600;
//白天开始
const DAY_SECOND_START = 9 * 3600;
//白天结束
const DAY_SECOND_END = 18 * 3600;

export default class MainScene extends Scene {

	public expBar: eui.ProgressBar;
	public signInBtn: eui.Button;
	public propBtn: eui.Button;
	public mijiBtn: eui.Button;
	public travelBtn: eui.Button;
	public getCoinBtn: eui.Button;
	public feedBtn: eui.Button;
	public feedBtnNew: eui.Button;
	public fengche: eui.Image;
	public boat: eui.Image;
	public spContainer: eui.Group;
	public scContaner1: eui.Group;
	public scContaner0: eui.Group;
	public petContainer: eui.Group;
	public timeLabel: eui.Label;
	public timeBar: eui.ProgressBar;
	public timeBarContainer: eui.Group;
	public myCoinGroup: eui.Group;
	public nickName: eui.Label;
	public numDownLb: eui.Label;
	public exp: eui.Label;
	public LvLb: eui.Label;
	public myCoin: eui.Label;
	public mainbg: eui.Image;
	public hTipsImg: eui.Image;
	public skipBtn: eui.Button;
	public boatGroup: eui.Group;
	public foodGroup: eui.Group;
	public sunShineImg: eui.Image;
	public petNormalContainer: eui.Group;
	public redPoint_signIn: eui.Image;

	private dolphinMc: egret.MovieClip;
	private normalMc: egret.MovieClip;
	private happyMc: egret.MovieClip;
	private hungerMc: egret.MovieClip;
	private shuicao1: egret.MovieClip;
	private shuicao2: egret.MovieClip;
	private petStateImg: egret.Bitmap;


	// public circleImg0:eui.Image;
	// public circleImg1:eui.Image;
	// public circleImg2:eui.Image;
	// public circleImg3:eui.Image;


	private imgLoaderData: egret.Texture;
	private shuipaoArr: MyImage[];
	private spMoveArr: MyImage[];
	private spDisappear: number;
	//7个位置可以放置粮食，创建粮食时会随机抽一个
	private fPosArr: number[] = [0, 1, 2, 3, 4, 5, 6];
	//食物容器的初始位置
	protected fctnPosArr: number[][];
	//已创建生成的粮食id
	private fidArr: number[];

	//时间校验
	private lastSystemTime: number;

	//引导层
	// private guideLayer: GuidePanel;

	//是否播引导
	protected isGuide: boolean = false;

	//是否在播放粮食进度条动画
	protected isActPlay: boolean;
	//当前背景是哪个时间
	private currBgName: string;

	//当前食物
	private currFood: number;

	public get skinKey() { return 'MainScene' }
	public get groupName() { return 'main_scene' }
	constructor(data?) {
		super(data);
		if (data) {
			this.isGuide = true;
		}
	}

	initEvents() {
		// this.boatGroup.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_boatGroup, this);
		this.signInBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_signInBtn, this);
		this.propBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_propBtn, this);
		this.mijiBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_mijiBtn, this);
		this.travelBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_travelBtn, this);
		this.getCoinBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_getCoinBtn, this);
		this.feedBtnNew.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_feedBtnNew, this);
		// this.myCoinGroup.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_myCoinGroup, this);
		GDispatcher.addEvent('refreshCredits', this.refreshCredits, this);
		// GDispatcher.addEvent('useComplete', this.useComplete, this);
		GDispatcher.addEvent('refreshSignIn', this.refreshSignIn, this);
		GDispatcher.addEvent('onTour', this.onTour, this);
		GDispatcher.addEvent(ABNetManager.ERROR, this.onError, this);

	}

	private onError(net: any, code: any): void {
		console.log(code);
		var msg: string;
		var msgArr: any = window['errorMessage'];
		if (!isNaN(code)) {
			msg = msgArr[code] ? msgArr[code] : '额哦，一个未知的错误';

		} else {
			msg = code;
		}

		PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, [msg], false);
	}
	removeEvents() {
		// this.boatGroup.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_boatGroup, this);
		this.signInBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_signInBtn, this);
		this.propBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_propBtn, this);
		this.mijiBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_mijiBtn, this);
		this.travelBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_travelBtn, this);
		this.getCoinBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_getCoinBtn, this);
		this.feedBtnNew.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_feedBtnNew, this);
		// this.myCoinGroup.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onClick_myCoinGroup, this);
		this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
		GDispatcher.removeEvent('refreshCredits', this.refreshCredits, this);
		// GDispatcher.removeEvent('useComplete', this.useComplete, this);
		GDispatcher.removeEvent('refreshSignIn', this.refreshSignIn, this);
		GDispatcher.removeEvent('onTour', this.onTour, this);
		GDispatcher.removeEvent(ABNetManager.ERROR, this.onError, this);

		// if(this.guideLayer){
		// 	this.removeChild(this.guideLayer);
		// }
	}

	protected onSkinComplete(): void {
		super.onSkinComplete();


		setTimeout(() => {
			let scrollHeight = document.documentElement.scrollTop || document.body.scrollTop || 0;
			window.scrollTo(0, Math.max(scrollHeight - 1, 0));
		}, 100);

		this.percentHeight = 100;

		this.isActPlay = false;

		this.mainbg.texture = this.bgtexture;
		//设置水草，晚上不显示
		this.getBgNameStr();
		this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
		if (this.stage) {
			this.onLoad();
		}
	}

	start(data?) {
	}

	private bgtexture: egret.Texture;
	protected async preLoadRes() {
		//加载背景并设置背景图片
		this.currBgName = this.getBgNameStr();
		this.bgtexture = await RES.getResAsync(this.currBgName);
		console.log('载背景并设置背景图片mainscene');
		return new Promise(function (resolve, reject) {
			resolve();
		});
	}

	protected onLoad(): void {

		// this.fengche.y = this.stage.stageHeight - 1014;
		this.spDisappear = DISAPPEAR_SP;//this.stage.stageHeight - DISAPPEAR_SP;

		// DataManager.ins.petHomeInfoData.statusRemainingTime += 5;//增加5秒确保服务端时间到期
		//食物容器初始位置取值
		if (!this.fctnPosArr) {
			this.fctnPosArr = [];
		}
		for (var i: number = 0; i < 7; i++) {
			this.fctnPosArr[i] = [this['foodCtner' + i].x, this['foodCtner' + i].y];

			this['foodCtner' + i].touchEnabled = false;
			this['foodCtner' + i].touchChildren = false;
		}


		this.initUI();

		this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
	}

	private initUI(): void {
		//初始化数据
		this.initData();
		//初始化需要加载资源的ui
		this.initUIRes();
		//初始化不需要家在资源的ui
		this.initUIInfo();
		//初始化是只设置一次
		// this.initOnceInfo();
		//初始化海豚状态
		this.initPetState();
		//初始化粮食
		this.createFood();

	}
	private initData(): void {
		this.currFood = 0;
	}

	//等待主体资源加载完成在显示
	private showAllUI(isShow: boolean): void {
		// this.timeBarContainer.visible 	= isShow;
		this['headInfoMc'].visible = isShow;
		this.foodGroup.visible = isShow;
		this.signInBtn.visible = isShow;
		this.propBtn.visible = isShow;
		this.propBtn.visible = isShow;
		this['boat'].visible = isShow;
		this.fengche.visible = isShow;
		// this.feedBtn.visible 			= isShow;
		this.travelBtn.visible = isShow;
		this.getCoinBtn.visible = isShow;
		this.scContaner0.visible = isShow;
		this.scContaner1.visible = isShow;

	}

	private async initUIRes() {
		if (!this.shuicao1) {
			// this.preLoadRes();
			Loading.instace.show();
			this.showAllUI(false);
			var sc1Json = await RES.getResAsync("haicao_json");
			var sc1Img = await RES.getResAsync("haicao_png");
			var mcFactory = new egret.MovieClipDataFactory(sc1Json, sc1Img);

			this.shuicao1 = new egret.MovieClip(mcFactory.generateMovieClipData());
			this.scContaner1.addChild(this.shuicao1);
			this.shuicao1.play(-1);

			this.shuicao1.scaleX = 0.8;
			this.shuicao1.scaleY = 0.8;

			this.shuicao1.y = 10;
			this.shuicao1.x = 10;

			sc1Json = await RES.getResAsync("haicao_json");
			sc1Img = await RES.getResAsync("haicao_png");
			mcFactory = new egret.MovieClipDataFactory(sc1Json, sc1Img);

			this.shuicao2 = new egret.MovieClip(mcFactory.generateMovieClipData());
			this.scContaner0.addChild(this.shuicao2);
			this.shuicao2.play(-1);

			//加载水草资源
			this.imgLoaderData = await RES.getResAsync("shuipao_png");

			this.showAllUI(true);

			Loading.instace.hide();
		}

	}

	private initUIInfo(): void {

		this.nickName.text = DataManager.ins.petHomeInfoData.petName;
		var currExp: number = DataManager.ins.petHomeInfoData.petExp - DataManager.ins.petHomeInfoData.currentLevelExp;
		var maxExp: number = DataManager.ins.petHomeInfoData.nextLevelExp - DataManager.ins.petHomeInfoData.currentLevelExp;
		this.exp.text = currExp + '/' + maxExp;
		this.expBar.value = Math.floor(currExp / maxExp * 100);
		this.LvLb.text = 'Lv.' + DataManager.ins.petHomeInfoData.petLevel;
		this.myCoin.text = '' + DataManager.ins.petIndexData.credits;
		this.foodGroup.touchEnabled = false;

		if (!this.fidArr) {
			this.fidArr = [];
		}

		//设置按钮进度条初始角度
		this.feedBtnNew['circleBarGroup'].rotation = 90;

		//隐藏食物减少动画lb
		this.numDownLb.alpha = 0;

		//设置食物按钮初始值
		var fnum: number = DataManager.ins.petHomeInfoData.foodNum;
		// this.feedBtnNew.label = '喂食 x' + Math.floor(fnum / 25);

		this.feedBtnNew['foodNumLb'].text = 'x' + Math.floor(fnum / 25);

		this.currFood = (fnum % 25) / 25;
		//设置粮食进度条
		this.setFoodBar(this.currFood);

		//风车动画
		egret.Tween.get(this.fengche, { loop: true }).to({ rotation: 360 }, 20000).call(() => {
			this.fengche.rotation = 0;
		});

		//船动画
		egret.Tween.get(this.boat, { loop: true }).to({ y: -7 }, 1000).to({ y: 7 }, 2000).to({ y: 0 }, 1000);

		//设置签到红点
		// this.refreshSignIn();

	}

	private initOnceInfo(): void {
		var fnum: number = DataManager.ins.petHomeInfoData.foodNum;
		this.feedBtn['foodCount'].text = fnum + 'G';

		var rate: number = fnum / DataManager.ins.petHomeInfoData.foodStoreLimit;
		var angle: number = Math.floor(rate * 360);
		// this.setFeedBar(- F_ANGLE, angle - F_ANGLE, true);
	}

	/**
	 * 设置喂食按钮进度条
	 * @param persentNum 进度条的百分比，满格为1
	 */
	private setFoodBar(persentNum: number = 0, isShowAct: boolean = false): void {
		let startAngle = 0;
		var square: egret.Shape;

		// var g:eui.Group; g
		if (this.feedBtnNew['circleBarGroup'].numChildren == 0) {
			square = new egret.Shape();
			this.feedBtnNew['circleBarGroup'].addChild(square);
		} else {

			square = this.feedBtnNew['circleBarGroup'].getChildAt(0);
		}


		if (isShowAct) {
			//按钮放大缩小动画
			egret.Tween.get(this.feedBtnNew).to({ scaleX: 1.2, scaleY: 1.2 }, 150).call(() => {
				egret.Tween.get(this.feedBtnNew).to({ scaleX: 1, scaleY: 1 }, 150).call(() => {
					let speedAngle = 0.03;
					let currAngle = 0;

					currAngle += speedAngle;
					egret.Tween.get(square, { loop: true }).to({ alpha: 1 }, 30).call(() => {
						if (currAngle == persentNum) {
							egret.Tween.removeTweens(square);
							if (persentNum == 1) {
								currAngle = 1;
								currAngle -= speedAngle;

								//食物数字放大缩小动画
								egret.Tween.get(this.feedBtnNew['foodNumLb']).to({ scaleX: 0.1, scaleY: 0.1 }, 100).call(() => {
									var fnum: number = DataManager.ins.petHomeInfoData.foodNum;
									this.feedBtnNew['foodNumLb'].text = 'x' + Math.floor(fnum / 25);
									egret.Tween.get(this.feedBtnNew['foodNumLb']).to({ scaleX: 1, scaleY: 1 }, 100).call(() => {

										//满一圈减少动画
										egret.Tween.get(square, { loop: true }).to({ alpha: 1 }, 35).call(() => {
											// console.log('currAngle', currAngle)
											if (currAngle == 0) {
												egret.Tween.removeTweens(square);
												this.isActPlay = false;

											}
											square.graphics.clear();
											square.graphics.beginFill(0x1ca0f6);
											square.graphics.moveTo(65, 65);
											square.graphics.drawArc(65, 65, 65, startAngle * Math.PI, (startAngle + 2 * currAngle) * Math.PI) //drawRect(0, 0, 126, 126);
											square.graphics.lineTo(65, 65);
											square.graphics.endFill();
											this.feedBtnNew['feedBtnBg'].mask = square;

											currAngle -= speedAngle;

											if (currAngle < 0) {
												currAngle = 0;
											}

										});
									});
								});

							} else {
								this.isActPlay = false;
							}
						}

						square.graphics.beginFill(0x1ca0f6);
						square.graphics.moveTo(65, 65);
						square.graphics.drawArc(65, 65, 65, startAngle * Math.PI, (startAngle + 2 * currAngle) * Math.PI) //drawRect(0, 0, 126, 126);
						square.graphics.lineTo(65, 65);
						square.graphics.endFill();
						this.feedBtnNew['feedBtnBg'].mask = square;

						currAngle += speedAngle;

						if (currAngle > persentNum) {
							currAngle = persentNum;
						}
					});
				});
			});

		} else {
			square.graphics.beginFill(0x1ca0f6);
			square.graphics.moveTo(65, 65);
			square.graphics.drawArc(65, 65, 65, startAngle * Math.PI, (startAngle + 2 * persentNum) * Math.PI) //drawRect(0, 0, 126, 126);
			square.graphics.lineTo(65, 65);
			square.graphics.endFill();
			this.feedBtnNew['feedBtnBg'].mask = square;
		}



	}

	private async initPetState(sval: number = -1) {
		this.hTipsImg.visible = false;
		if (this.dolphinMc) {
			this.petContainer.removeChild(this.dolphinMc);
			this.dolphinMc = null;
		}

		if (this.petStateImg) {
			this.petStateImg.visible = false;
		}

		this.timeBarContainer.visible = false;

		var state: number = DataManager.ins.petHomeInfoData.status;

		if (sval == -1) {
			state = DataManager.ins.petHomeInfoData.status;
		} else {
			state = sval;
		}

		if (state == 1 || state == 3) {
			if (!DataManager.ins.petHomeInfoData.isFull) {
				state = 4;
			}

			this.petNormalContainer.removeChildren();
		}

		if (sval == 5) {
			state = 5;
		}
		console.log('state=' + state);

		this.petNormalContainer.visible = false;

		var mcName: string = 'fish0';//this.getDolphinMcName();

		switch (state) {
			case 1://正常吃饱
			case 3:
				this.petNormalContainer.visible = true;
				this.petNormalContainer.alpha = 0;
				this.createDolphinMc(mcName + '1', 0, 0, this.fishMoveAct.bind(this), false, true);
				break;
			case 2://外出

				if (!this.petStateImg) {

					var pImg = await RES.getResAsync('petState_png');
					this.petStateImg = new egret.Bitmap(pImg);
					this.petContainer.addChild(this.petStateImg);
					this.petStateImg.x = 15;
				}

				this.petStateImg.visible = true;

				this.timeBarContainer.visible = true;
				console.log("小宠物出游了");
				break;

			case 5://吃饭
				this.createDolphinMc(mcName + '3', 0, 0, () => {
					this.dolphinMc.x = (this.petContainer.width - this.dolphinMc.width) * 0.5 - 50;
					this.dolphinMc.y = (this.petContainer.height - this.dolphinMc.height) * 0.5 + 10;

					this.petNormalContainer.visible = false;
				});

				break;

			case 4://饥饿
				this.createDolphinMc(mcName + '2', 0, 0, () => {
					this.hTipsImg.visible = true;
					this.hTipsImg.scaleX = 0.1;
					this.hTipsImg.scaleY = 0.1;
					this.hTipsImg.alpha = 1;
					this.hTipsImg.y = 100;

					egret.Tween.get(this.hTipsImg).to({ scaleX: 1, scaleY: 1 }, 300).wait(1000).to({ alpha: 0 }, 200);

					this.dolphinMc.x = (this.petContainer.width - this.dolphinMc.width) * 0.5 - 50;
					this.dolphinMc.y = (this.petContainer.height - this.dolphinMc.height) * 0.5;
				}, true);

				break;
		}
	}

	//播放巡游动画
	private fishMoveAct(): void {
		this.petNormalContainer.x = -150;
		this.petNormalContainer.scaleX = 1;
		egret.Tween.removeTweens(this.petNormalContainer);

		egret.Tween.get(this.petNormalContainer).to({ scaleY: 1 }, 1816).call(() => {
			this.normalMc.gotoAndPlay(1);
		}).to({ scaleY: 1 }, 1816).call(() => {
			this.normalMc.gotoAndPlay(1);
		});

		//吃饱状态渐渐显示
		egret.Tween.get(this.petNormalContainer).to({ alpha: 1 }, 1000).call(() => {

		});

		egret.Tween.get(this.petNormalContainer).to({ x: 100 }, 5450).call(() => {
			this.normalMc.gotoAndPlay(110);
			setTimeout(() => {
				this.normalMc.gotoAndPlay(1);
				const sx = this.petNormalContainer.scaleX;
				this.petNormalContainer.scaleX = -1;
				// if(sx > 0){
				this.petNormalContainer.x = 400;
				// }else{
				// this.petNormalContainer.x = -220;
				// }

				egret.Tween.get(this.petNormalContainer).to({ scaleY: 1 }, 1816).call(() => {
					this.normalMc.gotoAndPlay(1);
				}).to({ scaleY: 1 }, 1816).call(() => {
					this.normalMc.gotoAndPlay(1);
				});

				egret.Tween.get(this.petNormalContainer).to({ x: 150 }, 5450).call(() => {
					this.normalMc.gotoAndPlay(110);
					setTimeout(() => {
						this.normalMc.gotoAndPlay(1);
						this.fishMoveAct();
					}, 500);
				});
			}, 500);
		});


		//清除监听事件
		// if(this.normalMc.hasEventListener(egret.MovieClipEvent.ENTER_FRAME)){

		// 	this.normalMc.removeEventListener(egret.MovieClipEvent.ENTER_FRAME, this.mvEnterFrame, this);
		// }

		if (this.normalMc.hasEventListener(egret.TouchEvent.TOUCH_BEGIN)) {
			this.normalMc.removeEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onBegin_normalMc, this);

		}


		// this.normalMc.addEventListener(egret.MovieClipEvent.ENTER_FRAME, this.mvEnterFrame, this);
		this.normalMc.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onBegin_normalMc, this);
	}

	//检测帧数
	private mvEnterFrame(): void {
		if (!this.normalMc) return;
		if (this.normalMc.currentFrame == 106 ||
			this.normalMc.currentFrame == 107 ||
			this.normalMc.currentFrame == 108 ||
			this.normalMc.currentFrame == 109) {
			this.normalMc.gotoAndPlay(1);
		}
		// console.log(this.normalMc.currentFrame);
		if (this.normalMc.currentFrame == 136 || this.normalMc.currentFrame == 137 || this.normalMc.currentFrame == 138) {
			this.normalMc.gotoAndPlay(1);
			const sx = this.petNormalContainer.scaleX;
			this.petNormalContainer.scaleX = -sx;
			if (sx > 0) {
				this.petNormalContainer.x = 450;
			} else {
				this.petNormalContainer.x = -220;
			}

			egret.Tween.get(this.petNormalContainer).to({ x: 150 }, 5500).call(() => {
				this.normalMc.gotoAndPlay(110);
			});
		}
	}

	//是否可以点击下一次
	private iscanShowHapp: boolean;
	//吃饱状态点击切换开心状态
	private onBegin_normalMc(): void {
		if (this.iscanShowHapp) return;
		this.iscanShowHapp = true;

		this.normalMc.visible = false;
		this.happyMc.visible = true;
		this.happyMc.gotoAndPlay(1);
		setTimeout(() => {
			this.iscanShowHapp = false;
			this.normalMc.visible = true;
			this.happyMc.visible = false;
		}, 1000);
	}

	//创建海豚动画
	private async createDolphinMc(mcName: string, x: number = 0, y: number = 0, callBack: any = null, isLoop: boolean = false, isNormal: boolean = false) {
		var mcJson = await RES.getResAsync(mcName + "_json");
		var mcImg = await RES.getResAsync(mcName + "_png");
		var mcFactory = new egret.MovieClipDataFactory(mcJson, mcImg);
		var currMc: egret.MovieClip;

		//喷水动效
		var mcJson1 = await RES.getResAsync("fish04_json");
		var mcImg1 = await RES.getResAsync("fish04_png");
		var mcFactory1 = new egret.MovieClipDataFactory(mcJson1, mcImg1);

		//饥饿动效
		// var mcJson2 = await RES.getResAsync("fish03_json");
		// var mcImg2 = await RES.getResAsync("fish03_png");
		// var mcFactory2 = new egret.MovieClipDataFactory(mcJson2, mcImg2);

		if (isNormal) {
			this.normalMc = new egret.MovieClip(mcFactory.generateMovieClipData());
			this.petNormalContainer.addChild(this.normalMc);
			this.normalMc.touchEnabled = true;
			currMc = this.normalMc;

			//喷水动效
			this.happyMc = new egret.MovieClip(mcFactory1.generateMovieClipData());
			this.petNormalContainer.addChild(this.happyMc);
			this.happyMc.y = -25;
			this.happyMc.x = 20;
			this.happyMc.visible = false;

			//饥饿状态 预留

			// this.hungerMc = new egret.MovieClip(mcFactory2.generateMovieClipData());
			// this.petNormalContainer.addChild(this.hungerMc);
			// this.hungerMc.gotoAndStop(15)
			// this.hungerMc.y = -8;
			// this.hungerMc.x = -115;
			// this.hungerMc.visible = false;

		} else {
			this.dolphinMc = new egret.MovieClip(mcFactory.generateMovieClipData());
			currMc = this.dolphinMc;
			this.petContainer.addChild(this.dolphinMc);
		}

		// this.dolphinMc.x = (this.petContainer.width - this.dolphinMc.width) * 0.5;
		// this.dolphinMc.y = (this.petContainer.height - this.dolphinMc.height) * 0.5;
		if (isLoop) {
			currMc.play(-1);
		} else {
			currMc.play();
		}

		if (x) {
			currMc.x = x;
		}

		if (y) {
			currMc.x = y;
		}

		if (callBack) {
			callBack();
		}
	}

	//签到
	private onClick_signInBtn(): void {
		console.log('签到');
		// if(this.isGuide){
		// 	this.hideGuide();
		// 	PanelCtrl.instance.show(ModuleTypes.SIGN_IN_PANEL, this.showGuide.bind(this));
		// }else{
		// NetManager.ins.getSignInfo(function(){
		PanelCtrl.instance.show(ModuleTypes.SIGN_IN_PANEL);
		// }, 455555);
		// }

		//点击埋点，签到
		const dpm = Buried.connectDpm(110, 1, 4);
		const dcm = Buried.connectDcm(230, window['skinID'], 0);
		const embedDomain = DataManager.ins.petIndexData.embedDomain;
		const exposure = Buried.createExposure(dpm, dcm, embedDomain);
		NetManager.ins.clickLog(exposure);
	}

	//网鱼网咖logo点击
	private onTap_boatGroup(): void {
		PanelCtrl.instance.btnDelay(this.boatGroup);
		console.log('点击了网咖logo');
	}

	//道具
	private onClick_propBtn(): void {
		console.log('道具');
		NetManager.ins.getActToys((success: boolean) => {
			if (!success) {
				return;
			}
			console.log('道具数据', DataManager.ins.getActToysListData);
			// if(this.isGuide){//道具界面，指向使用道具按钮
			// 	this.hideGuide();
			// 	PanelCtrl.instance.show(ModuleTypes.PROP_PANEL, this.showGuide.bind(this));
			// }else{
			PanelCtrl.instance.show(ModuleTypes.PROP_PANEL);
			// }
		}, DataManager.ins.petIndexData.activityId, 4, 3, DataManager.ins.petHomeInfoData.petId);

		//点击埋点，道具
		const dpm = Buried.connectDpm(110, 1, 5);
		const dcm = Buried.connectDcm(230, window['skinID'], 0);
		const embedDomain = DataManager.ins.petIndexData.embedDomain;
		const exposure = Buried.createExposure(dpm, dcm, embedDomain);
		NetManager.ins.clickLog(exposure);

	}

	//秘籍
	private onClick_mijiBtn(): void {
		console.log('秘籍');
		// this.visible = false;
		PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);

		//点击埋点，秘籍攻略
		const dpm = Buried.connectDpm(110, 1, 6);
		const dcm = Buried.connectDcm(230, window['skinID'], 0);
		const embedDomain = DataManager.ins.petIndexData.embedDomain;
		const exposure = Buried.createExposure(dpm, dcm, embedDomain);
		NetManager.ins.clickLog(exposure);
	}

	//出游
	private onClick_travelBtn(): void {
		console.log('出游');
		//集卡查询（查询去过哪些地方）,默认查中国
		NetManager.ins.getCollectRule(this.getCollectRule_Back.bind(this), window['collectRuleIdList'] ? window['collectRuleIdList'][0] : 1);

		//点击埋点，出游
		const dpm = Buried.connectDpm(110, 1, 2);
		const dcm = Buried.connectDcm(230, window['skinID'], 0);
		const embedDomain = DataManager.ins.petIndexData.embedDomain;
		const exposure = Buried.createExposure(dpm, dcm, embedDomain);
		NetManager.ins.clickLog(exposure);
	}

	private getCollectRule_Back(success: boolean): void {
		if (!success) {
			return;
		}
		// if(this.isGuide){
		// 	this.hideGuide();
		// 	PanelCtrl.instance.show(ModuleTypes.TOUR_PANEL, this.showGuide.bind(this));
		// }else{
		PanelCtrl.instance.show(ModuleTypes.TOUR_PANEL);
		// }
	}

	//赚金币
	protected onClick_getCoinBtn(): void {
		console.log('赚金币');
		PanelCtrl.instance.btnDelay(this.getCoinBtn);
		this.setFoodBar(0.25, true);
		// PanelCtrl.instance.show(ModuleTypes.EARN_GOLD_COIN_PANEL);
	}

	//喂养按钮新
	protected onClick_feedBtnNew(): void {
		console.log('喂食');

		if (this.isActPlay) {
			PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, ["啊哦...你操作太快，休息一下~"], false);
			return;
		}
		console.log(DataManager.ins.petHomeInfoData.foodNum);
		if (DataManager.ins.petHomeInfoData.foodNum < DataManager.ins.petHomeInfoData.feedLimit) {
			PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, ["食物不够了~"], false);
			return;
		}

		// var status = DataManager.ins.petHomeInfoData.status;
		// if(DataManager.ins.petHomeInfoData.isFull && (status == 1 || status == 3)){
		// 	PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, ["小宠物已经吃饱了，请稍后再来~"], false);
		// 	return;
		// }

		//食物进度条减少动画处理
		this.isActPlay = true;
		NetManager.ins.petFeed(function (success: boolean) {
			if (!success) {
				this.isActPlay = false;
				return;
			}
			//喂食动画处理
			this.initPetState(5);

			// DataManager.ins.petHomeInfoData.foodNum -= DataManager.ins.petHomeInfoData.feedLimit;
			console.log('DataManager.ins.petHomeInfoData.feedLimit=' + DataManager.ins.petHomeInfoData.feedLimit);
			console.log('DataManager.ins.petHomeInfoData.foodNum=' + DataManager.ins.petHomeInfoData.foodNum);

			//设置喂食按钮进度
			var fnum: number = Math.floor(DataManager.ins.petHomeInfoData.foodNum / 25);
			if (fnum > 0) {//可以喂食
				DataManager.ins.petHomeInfoData.foodNum -= 25;
				// this.feedBtnNew.label = '喂食 x' + (fnum - 1);
				this.feedBtnNew['foodNumLb'].text = 'x' + (fnum - 1);

				egret.Tween.get(this.numDownLb).to({ y: -20 }, 500, egret.Ease.cubicOut).call(() => {
					this.numDownLb.y = 39;
					this.numDownLb.alpha = 0;
					this.isActPlay = false;
					console.log('this.isActPlay1', this.isActPlay);
				});

				egret.Tween.get(this.numDownLb).to({ alpha: 1 }, 100).wait(300).to({ alpha: 0 }, 100).call(() => {

					this.numDownLb.y = 39;
					this.numDownLb.alpha = 0;
					this.isActPlay = false;
					console.log('this.isActPlay2', this.isActPlay);
				});



				//刷新宠物信息
				NetManager.ins.getPetInfo(function (success: boolean) {
					if (!success) {
						return;
					}
					this.initUIInfo();
					this.createFood();


					setTimeout(function () {
						console.log('喂食动画切回');
						this.initPetState();

						// //升级抽插件
						// if(DataManager.ins.petFeedData.isLevelUp){
						// 	this.getPlugPrize(DataManager.ins.petFeedData.levelPluginId);
						// }
					}.bind(this), 3900);
				}.bind(this), DataManager.ins.petIndexData.activityId);
			} else {
				this.isActPlay = false;
			}

			//测试代码
			// DataManager.ins.petHomeInfoData.isFull = true;
			// setTimeout(function () {
			// 	console.log('喂食动画切回');
			// 	this.initPetState();
			// }.bind(this), 3900);
		}.bind(this), DataManager.ins.petHomeInfoData.petId, DataManager.ins.petHomeInfoData.feedLimit, DataManager.ins.petIndexData.activityId);

	}

	//插件抽奖
	private getPlugPrize(plugId: number): void {
		Loading.instace.show();
		NetManager.ins.doJoinPlugDraw((s) => {
			if (!s) {
				// 失败弹窗
				PanelCtrl.instance.show(ModuleTypes.UPNO_PRIZE_PANEL);
				Loading.instace.hide();
				return
			}
			NetManager.ins.getPlugOrderStatus(
				(ss) => {
					Loading.instace.hide();
					if (ss) {
						PanelCtrl.instance.show(ModuleTypes.UPPRIZE_PANEL, { isplug: true })
					} else {
						PanelCtrl.instance.show(ModuleTypes.UPNO_PRIZE_PANEL);
					}
				},
				DataManager.ins.doJoinPlugDrawData.orderId,
				() => {
					return DataManager.ins.getPlugOrderStatusData.result == 0
				}
			)

		}, plugId)
	}

	/**
	 * 购买成功事件监听
	 */
	private refreshCredits(): void {
		this.myCoin.text = '' + DataManager.ins.petIndexData.credits;
	}

	// /**
	//  * 使用成功事件监听
	//  */
	// private useComplete():void{
	// 	this.refreshState();
	// }

	protected onTour(): void {
		//刷新宠物信息
		NetManager.ins.getPetInfo(function (success: boolean) {
			if (!success) {
				return;
			}
			this.initUIInfo();
			this.initPetState();
			this.refreshCredits();
		}.bind(this), DataManager.ins.petIndexData.activityId);
	}

	//刷新签到提示图标
	private refreshSignIn(): void {
		if (DataManager.ins.signInfoData) {
			this.redPoint_signIn.visible = !DataManager.ins.signInfoData.signInfoVO.todaySigned;
		} else {
			console.log('DataManager.ins.signInfoData为什么不存在');
		}
	}


	protected itmePos: number = -1;
	private createFood(): void {
		// var fArr:any[] = DataManager.ins.petHomeInfoData.foodList;
		// NetManager.ins.getFoodPiles(function(){
		var fArr: any[] = DataManager.ins.petHomeInfoData.foodPileList;

		for (var i: number = 0; i < fArr.length; i++) {
			var fobj: any = fArr[i];

			if (this.fidArr.indexOf(fobj.id) == -1) {
				var posIdx: number = Math.floor(this.fPosArr.length * Math.random());
				var fPos: number = this.fPosArr[posIdx];
				this.itmePos = fPos;
				this.fPosArr.splice(posIdx, 1);

				this.fidArr.push(fobj.id);

				var fitem: FoodItem = new FoodItem(fobj.id, fobj.foodNum, fPos, (Math.random() > 0.5 ? 1 : -1), this.onClick_food.bind(this));
				this['foodCtner' + fPos].addChild(fitem);
				this['foodCtner' + fPos].touchEnabled = true;
				this['foodCtner' + fPos].touchChildren = true;
				fitem.playAct();
			}


		}
		// }.bind(this));

	}

	//食物收取点击
	protected onClick_food(item: FoodItem): void {
		if (DataManager.ins.petHomeInfoData.foodNum >= DataManager.ins.petHomeInfoData.foodStoreLimit) {
			PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, ["啊哦...食物储存达到上限啦", "快去喂食吧~"], false);
			return;
		}
		if (this.isActPlay) {
			// PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, ["啊哦...您操作太频繁了", "请休息一下~"], false);
			return;
		}
		this.isActPlay = true;

		NetManager.ins.collectFood(function (success: boolean) {
			if (!success) {
				this.isActPlay = false;
				return;
			}
			DataManager.ins.petHomeInfoData.foodNum += item.fcount;


			var fnum: number = DataManager.ins.petHomeInfoData.foodNum;

			let endAngle;
			if (fnum % 25 == 0) {
				endAngle = 1;
			} else {
				endAngle = (fnum % 25) / 25;
			}

			var ctn: eui.Group = this['foodCtner' + item.pos];
			this.fPosArr.push(item.pos);
			item.removeEvent();
			item.stopAct();

			var endY: number = this.feedBtn.y - this.foodGroup.y;// this.foodGroup.height - 200;// - this.foodGroup.y;// - item.y;
			var endX: number = this.feedBtn.x;// - ctn.x;
			var a: number = this.foodGroup.height - ctn.y;
			var b: number = ctn.x - this.feedBtn.x;
			var time: number = Math.sqrt((a * a) + (b * b)) /
				Math.sqrt(this.foodGroup.height * this.foodGroup.height + this.foodGroup.width * this.foodGroup.width) * 600;

			egret.Tween.get(ctn).to({ x: endX, y: endY, scaleX: 0.3, scaleY: 0.3 }, Math.floor(time)).call(function (item: FoodItem) {
				var pos: number = item.pos;
				var ctn: eui.Group = this['foodCtner' + pos];
				ctn.x = this.fctnPosArr[pos][0];
				ctn.y = this.fctnPosArr[pos][1];
				ctn.scaleX = 1;
				ctn.scaleY = 1;

				// ctn.touchEnabled 	= false;
				// ctn.touchChildren 	= false;
				//移除食物id记录
				this.fidArr.splice(this.fidArr.indexOf(item.fid), 1);
				ctn.removeChild(item);

				//设置粮食进度条
				this.setFoodBar(endAngle, true);

				ctn.touchEnabled = false;
				ctn.touchChildren = false;

			}, this, [item]);

		}.bind(this), item.fid, DataManager.ins.petIndexData.activityId, DataManager.ins.petHomeInfoData.petId);

		// if(this.isGuide){//食物收取，接下来是第四步引导
		// 	this.showGuide(4);
		// }
	}

	private tick: number = 0;
	private timeTick: number = 0;

	private onEnterFrame(): void {
		if (this.imgLoaderData) {
			if (this.tick > 20) {
				this.tick = 0;
				this.createShuipao();
				this.showShuipao();
			}

			this.tick++;

			this.moveShuipao();
		}


		var useTime: number;
		var date: Date = new Date();

		if (this.lastSystemTime) {
			useTime = date.getTime() - this.lastSystemTime;
		} else {
			useTime = 1000 / 60;
		}

		this.lastSystemTime = date.getTime();
		var times: number = useTime / (1000 / 60);
		var tNum: number = DataManager.ins.petHomeInfoData.statusRemainingTime;

		if (this.timeTick >= 60) {


			if (tNum > 0) {
				this.timeBar.value = Math.floor(tNum / DataManager.ins.petHomeInfoData.statusTotalTime * 100);

				tNum -= Math.floor(this.timeTick / 60);

				if (tNum < 0) {
					tNum = 0;
				}
				DataManager.ins.petHomeInfoData.statusRemainingTime = tNum;
				// console.log('倒计时：' + DataManager.ins.petHomeInfoData.statusRemainingTime);
				// console.log('减少间隔' + this.timeTick);
				var tStr: string = GTime.formatTime(tNum, TimeFormat.HMS, false, [':', ':', '', '']);
				this.timeLabel.text = '出游时间剩余' + tStr;

				this.timeTick = 0;

				if (tNum == 0) {
					//刷新状态
					// this.refreshState();

				}

			}

			//刷新背景状态
			var bname: string = this.getBgNameStr();
			if (this.currBgName != bname) {
				this.currBgName = bname;
				this.loadMainBg();
			}
		}

		if (tNum > 0) {
			this.timeTick += times;
		}

		// console.log('this.timeTick=' + this.timeTick);
		// console.log('times=' + times);

	}

	//切换要加载的图片
	private async loadMainBg() {
		var bgtexture: egret.Texture = await RES.getResAsync(this.currBgName);
		this.mainbg.texture = bgtexture;
	}

	/**
	 * 刷新鱼的当前状态
	 */
	private refreshState(): void {
		var currStatus: number = DataManager.ins.petHomeInfoData.status;
		NetManager.ins.getPetStatus(function (success: boolean) {
			if (!success) {
				return;
			}
			//切换状态
			console.log("DataManager.ins.petHomeInfoData:", DataManager.ins.petHomeInfoData);
			if (currStatus == 2) {
				//获取出游奖励
				this.getPrizeInfo();
				// NetManager.ins.getPetGooutReward(()=>{
				// 	if(DataManager.ins.gooutRewardData.hasReward){//有奖励，就插件抽奖
				// 		//插件抽奖
				// 		NetManager.ins.doJoinPlugDraw(this.doJoinPlugDraw_Back.bind(this), DataManager.ins.gooutRewardData.pluginId);
				// 	}
				// }, DataManager.ins.petIndexData.activityId, DataManager.ins.petHomeInfoData.petId);
			}
			// DataManager.ins.petHomeInfoData.status = 1;///测试用
			this.initPetState();
		}.bind(this), DataManager.ins.petHomeInfoData.petId, DataManager.ins.petIndexData.activityId);
	}


	//初始化喂食遮罩
	private initFeedMask(): void {



		this.setMask(this.feedBtn['circleImg0'], this.feedBtn['fContainer'], 70.5, 0, 100, 200);
		this.setMask(this.feedBtn['circleImg1'], this.feedBtn['fContainer'], 70.5, 0, 100, 200);
		this.setMask(this.feedBtn['circleImg2'], this.feedBtn['fContainer'], 0, 0, 72, 200);
		this.setMask(this.feedBtn['circleImg3'], this.feedBtn['fContainer'], 0, 0, 72, 200);

		this.feedBtn['circleImg0'].rotation = -F_ANGLE;
		this.feedBtn['circleImg1'].rotation = -F_ANGLE;
		this.feedBtn['circleImg2'].rotation = 180 - F_ANGLE;
		this.feedBtn['circleImg3'].rotation = 180 - F_ANGLE;
	}

	//获取海豚模型type
	// return type  1.sDolphin 少年  2.mDolphin 中年  3.bDolphin 壮年
	private getDolphinMcName(): string {
		var lvNum: number = DataManager.ins.petHomeInfoData.petLevel;
		var mcName: string = '';
		if (lvNum < 4) {
			mcName = 'sDolphin';
		} else if (lvNum < 7) {
			mcName = 'mDolphin';
		} else if (lvNum < 11) {
			mcName = 'bDolphin';
		}

		return mcName;
	}



	//创建水泡
	private createShuipao(): void {
		if (!this.shuipaoArr) {
			this.shuipaoArr = [];
		}

		if (this.shuipaoArr.length < 10) {
			for (var i: number = 0; i < 50; i++) {
				// let texture = new egret.Texture();
				// texture._setBitmapData(this.imgLoaderData);
				var bitmap: MyImage = new MyImage(this.imgLoaderData);
				this.shuipaoArr.push(bitmap);
			}
		}

	}
	//显示水泡
	private showShuipao(): void {
		var spaceX: number = 700;
		var spaceY: number = 35;
		var sX: number = 0;//this.travelBtn.x + 40;
		var sY: number = 0;//this.travelBtn.y - 100;

		if (!this.spMoveArr) {
			this.spMoveArr = [];
		}

		for (var i: number = 0; i < Math.floor(1 + 8 * Math.random()); i++) {
			var img: MyImage = this.shuipaoArr.shift();
			this.spMoveArr.push(img);
			var iX: number = sX + spaceX * Math.random();
			var rdm: number = Math.random();
			img.x = iX;
			img.y = sY + spaceY * Math.random();
			img.speed = (Math.random() > 0.5 ? 1.5 : -1);
			img.scaleX = 0.4 + 0.7 * rdm;
			img.scaleY = 0.4 + 0.7 * rdm;
			img.alpha = 0.5 + 0.5 * Math.random();

			//水泡是左移还是右移，还是水平方向没有速度
			var dir: number;
			if (rdm >= 0 && rdm < 0.3) {
				dir = 1;
			} else if (rdm >= 0.3 && rdm < 0.6) {
				dir = -1;
			} else {
				dir = 0;
			}
			img.directX = dir;
			sX = sX + spaceX;
			this.spContainer.addChild(img);

		}



	}

	//让水泡动起来
	private moveShuipao(): void {
		if (!this.spMoveArr) {
			return;
		}
		var len: number = this.spMoveArr.length;
		for (var i: number = 0; i < len; i++) {
			var img: MyImage = this.spMoveArr[i];
			img.y -= img.speed;
			img.x += 0.5 * img.directX;
			img.speed = img.speed + ADD_SPEED;

			if (img.y <= this.spDisappear + 200 * Math.random()) {
				this.spMoveArr.splice(i, 1);
				this.spContainer.removeChild(img);
				this.shuipaoArr.push(img);

				len--;
			}
		}
	}

	//加载水泡图片
	private loadImgShuipao(): void {
		var imgLoader: egret.ImageLoader = new egret.ImageLoader();
		imgLoader.addEventListener(egret.Event.COMPLETE, function (e: egret.Event) {
			var imageLoader = <egret.ImageLoader>e.currentTarget;
			this.imgLoaderData = imageLoader.data;
		}, this);

		imgLoader.load('resource/assets/main_scene/shuipao.png');
	}

	//添加矩形遮罩
	private setMask(target: egret.DisplayObject, tcontainer: egret.DisplayObjectContainer, tx: number, ty: number, tw: number, th: number): void {
		var square: egret.Shape = new egret.Shape();
		square.graphics.beginFill(0xff0000);
		square.graphics.drawRect(0, 0, tw, th);
		square.graphics.endFill();
		square.x = tx;
		square.y = ty;
		tcontainer.addChild(square);

		target.mask = square;
	}

	private curMapPlugID: number;//当前出游的地图插件id

	private doJoinPlugDraw(): void {
		//插件抽奖
		NetManager.ins.doJoinPlugDraw(this.doJoinPlugDraw_Back.bind(this), this.curMapPlugID);
	}

	//根据时间判断，获取当前背景图名字
	private getBgNameStr(): string {
		var bName: string;
		var date: Date = new Date();
		var hour: number = date.getHours();
		var minute: number = date.getMinutes();
		var second: number = date.getSeconds();

		var timeVal: number = hour * 3600 + minute * 60 + second;
		if (timeVal > MORNING_SECOND && timeVal <= DAY_SECOND_START) {
			if (this.scContaner0) {
				this.scContaner0.visible = true;
			}
			if (this.scContaner1) {
				this.scContaner1.visible = true;
			}

			if (this.sunShineImg) {
				this.sunShineImg.visible = false;
			}

			if (this.boat) {
				this.boat.source = 'boat1_png'
			}

			bName = 'bgmorning_jpg';
		} else if (timeVal > DAY_SECOND_START && timeVal <= DAY_SECOND_END) {
			if (this.scContaner0) {
				this.scContaner0.visible = true;
			}
			if (this.scContaner1) {
				this.scContaner1.visible = true;
			}
			if (this.sunShineImg) {
				this.sunShineImg.visible = true;
			}

			bName = 'bgday_jpg';

			if (this.boat) {
				this.boat.source = 'boat_png'
			}
		} else {
			if (this.scContaner0) {
				this.scContaner0.visible = false;
			}
			if (this.scContaner1) {
				this.scContaner1.visible = false;
			}
			if (this.sunShineImg) {
				this.sunShineImg.visible = false;
			}

			if (this.boat) {
				this.boat.source = 'boat2_png'
			}

			bName = 'bgnight_jpg';
		}
		return bName;
	}

	//循环播放动画
	private playAnimation(target: egret.tween.TweenGroup, isLoop: boolean): void {
		if (isLoop) {
			for (var key in target.items) {
				target.items[key].props = { loop: true };
			}
		}
		target.play();
	}

	/**
	 * 插件抽奖接口回调
	 * @param success 
	 */
	private doJoinPlugDraw_Back(success: boolean): void {
		if (!success) {
			return;
		}
		//查询插件抽奖结果
		NetManager.ins.getPlugOrderStatus(this.getPlugOrderStatus_Back.bind(this), DataManager.ins.doJoinPlugDrawData.orderId, this.pollingCheck.bind(this), 10);
	}

	/**
	 * 查询插件抽奖结果回调
	 * @param success 
	 */
	private getPlugOrderStatus_Back(success: boolean): void {
		if (!success) {
			return;
		}
		if (DataManager.ins.getPlugOrderStatusData.result == 2) {
			//中奖了，打开奖励面板
			// if(this.isGuide){
			// 	PanelCtrl.instance.show(ModuleTypes.REWARD_PANEL, [this.curMapPlugID, this.showGuide.bind(this)]);
			// }else{
			PanelCtrl.instance.show(ModuleTypes.REWARD_PANEL, [this.curMapPlugID]);
			// }
		}
	}

	//轮询
	private pollingCheck(data: any): boolean {
		return data.result == 0;
	}

	/**
	 * 播放引导
	 * @param index : 引导步骤 1签到，2确认签到。。。。
	 */
	// private showGuide(index:number):void{
	// 	this.hideGuide();
	// 	if(!this.guideLayer){
	// 		this.guideLayer = new GuidePanel();
	// 		this.addChild(this.guideLayer);
	// 	}

	// 	let x;
	// 	let y;
	// 	let w;
	// 	let h;
	// 	let tips;
	// 	if(index == 1){//指向签到按钮
	// 		console.log(this.signInBtn.right);
	// 		console.log(this.signInBtn.x);
	// 		x = 750 - 39 - 88;
	// 		y = 41;
	// 		w = 90;
	// 		h = 100;
	// 		tips = '每天签到可领取金币~';
	// 	}else if(index == 3){//指向收取食物
	// 		x = this['foodCtner' + this.itmePos].x - 60;
	// 		y = this['foodCtner' + this.itmePos].y + this.foodGroup.y - 60;
	// 		w = 120;
	// 		h = 120;
	// 		tips = '鱼食每天自动产生，点击收取后给小海豚喂食吧~';
	// 	}else if(index == 4){//指向喂食按钮
	// 		x = this.feedBtn.x - this.feedBtn.width/2;
	// 		y = this.feedBtn.y - this.feedBtn.height/2;
	// 		w = this.feedBtn.width;
	// 		h = this.feedBtn.height;
	// 	}else if(index == 5){//指向出游按钮
	// 		x = this.travelBtn.x + 5;
	// 		y = this.travelBtn.y;
	// 		w = this.travelBtn.width;
	// 		h = this.travelBtn.height;
	// 		tips = '小海豚吃饱啦，马上出游吧~';
	// 	}else if(index == 8){//指向道具按钮
	// 		x = this.propBtn.x;
	// 		y = this.propBtn.y;
	// 		w = 90;
	// 		h = 100;
	// 		tips = '使用道具可以让小海豚加速回来！';
	// 	}else if(index == 10){//指向赚金币按钮
	// 		x = this.getCoinBtn.x;
	// 		y = this.getCoinBtn.y;
	// 		w = this.getCoinBtn.width;
	// 		h = this.getCoinBtn.height;
	// 		tips = '想赚得更多金币？去看看吧~';
	// 	}
	// 	this.guideLayer.updateData(index, x, y, w, h, tips);
	// }

	// private hideGuide():void{
	// 	if(this.guideLayer){
	// 		this.guideLayer.dispose();
	// 		this.removeChild(this.guideLayer);
	// 		this.guideLayer = null;
	// 	}
	// }
}