export class FriendItemComponent extends eui.Component{
    public photoMask:eui.Rect;
    public photoImg:eui.Image;
    public userNameText:eui.Label;
    public speedText:eui.Label;
    public timerText:eui.Label;    

    private photo;
    private uname;
    private speed;
    private timer;

    
    /**
     * 
     * @param photo 头像
     * @param uname 用户名
     * @param speed 速度
     * @param timer 事件
     */
    constructor(photo,uname:string,speed,timer){
        super();
        this.skinName       = 'resource/skins/component/FriendItemComponent.exml';

        this.photo = photo;
        this.uname = uname;
        this.speed = speed;
        this.timer = timer;
        this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        if (this.skin) {
            this.onSkinComplete();
        }
    }

    private onSkinComplete():void{
        this.photoImg.mask=this.photoMask;
        this.removeEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
    }

    public removeEvent():void{
    }

    
    public playAct(start:number = 0):void{
        
    }

    public stopAct():void{
        // this.act.stop();
    }
}