import { TwFun } from './../../libs/tw/util/TwFun';
import { ModuleTypes } from './../types/sceneTypes';
import { DataManager } from './../../libs/tw/manager/DataManager';
import Scene from "../views/Scene";
import PanelCtrl from '../ctrls/panelCtrl';
import NetConst from '../NetConst';
import SceneCtrl from '../ctrls/sceneCtrl';
import ToastCtrl from '../ctrls/toastCtrl';
import Waiting from '../waiting/Waiting';
import { Buried } from '../../libs/tw/util/Buried';
import { NetManager } from '../../libs/tw/manager/NetManager';
export default class StartScene extends Scene {
   
    public startGroup1:eui.Group;
    public startGroup2:eui.Group;
    public bg:eui.Image;
    public bg0:eui.Image;
    public titlePNG:eui.Image;
    public ruleBtn:eui.Button;
    public prizeBtn:eui.Button;
    public startBtn:eui.Button;
    public rankBtn:eui.Button;
    public costTxt:eui.Label;

    private startBtnExposure: any;
    private rankBtnExposure: any;
    protected get skinKey() { return 'Start' }


    onSkinComplete() {
        super.onSkinComplete();
        this.initBuired();
        this.initUI();
        this.initAni();
    }

    initBuired() {
        let startBtnDpmOut = Buried.connectDpm(110, 1, 1); // 点击埋点   
        let startBtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.startBtnExposure = Buried.createExposure(startBtnDpmOut, startBtnDcmOut);
        NetManager.ins.showLog(this.startBtnExposure);

        
        let rankBtnDpmOut = Buried.connectDpm(110, 2, 1); // 点击埋点   
        let rankBtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.rankBtnExposure = Buried.createExposure(rankBtnDpmOut, rankBtnDcmOut);
        NetManager.ins.showLog(this.rankBtnExposure);


    }


    initUI() {
        this.updateData();

       
        
    }

    initAni() {
        this.startBtn.visible = true;
        egret.Tween.get(this.startBtn,{loop:true})
            .set({scaleX:1,scaleY:1})
            .to({scaleX:0.8,scaleY:0.8},1000)
            .to({scaleX:1,scaleY:1},1000)
            
            
    }
    

    updateData() {
        if (DataManager.ins.customCfgData["uid"] == 'not_login') {
            // 未登录
            this.costTxt.text = `未登录`
            return
        }
        if (DataManager.ins.getData('gameAjaxElement').data && DataManager.ins.getData('gameAjaxElement').data.element) {
            if (DataManager.ins.getData('gameAjaxElement').data.element.status == 3) {
                this.costTxt.text = `游戏次数已用完`;
            } else if (DataManager.ins.getData('gameAjaxElement').data.element.status == 4) {
                this.costTxt.text = `今日次数已用完`;
            } else if (DataManager.ins.getData('gameAjaxElement').data.element.status == 5 && DataManager.ins.getData('gameAjaxElement').data.element.freeLimit > 0) {
                this.costTxt.text = `当前还有${DataManager.ins.getData('gameAjaxElement').data.element.freeLimit}次免费次数`
            } else if (DataManager.ins.getData('gameAjaxElement').data.element.status == 7 && DataManager.ins.getData('gameAjaxElement').data.element.freeLimit > 0) {
                this.costTxt.text = `剩余免费次数:${DataManager.ins.getData('gameAjaxElement').data.element.freeLimit}次`
            } else if (DataManager.ins.getData('gameAjaxElement').data.element.status == 2 || DataManager.ins.getData('gameAjaxElement').data.element.needCreditsLong > DataManager.ins.getData('gameAjaxElement').data.element.myCreditsLong) {
                this.costTxt.text = `${DataManager.ins.customCfgData.unitName || '积分'}不足`;
                
            } else {
                this.costTxt.text = `消耗${DataManager.ins.getData('gameAjaxElement').data.element.needCredits}${DataManager.ins.customCfgData.unitName || '积分'}/次`
            }
        }
        
    }

    initEvents() {
        super.initEvents();
        this.onTap(this.startBtn, this.onTap_startBtn);
        this.onTap(this.ruleBtn, this.onTap_ruleBtn);
        this.onTap(this.prizeBtn, this.onTap_prizeBtn);
        this.onTap(this.rankBtn,this.onTap_rankBtn);

        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    }

    onEnterFrame() {
        this.startGroup1.y +=10;
        this.startGroup2.y +=10;
        
        if(this.startGroup1.y>=this.startGroup1.height){
            this.startGroup1.y = this.startGroup2.y-this.startGroup1.height;
        }
        if(this.startGroup2.y>=this.startGroup2.height){
            this.startGroup2.y = this.startGroup1.y-this.startGroup2.height;
        }
    }

    
    onTap_startBtn(e): void {
        NetManager.ins.clickLog(this.startBtnExposure)
        if (DataManager.ins.customCfgData["uid"] == 'not_login') {
            // 未登录
            PanelCtrl.instance.show(ModuleTypes.LOGIN_PANEL);
            return
        }
        if (DataManager.ins.getData('gameAjaxElement').data && DataManager.ins.getData('gameAjaxElement').data.element) {
            if (DataManager.ins.getData('gameAjaxElement').data.element.status == 3) {
                //ToastCtrl.instance.show(`游戏次数已用完`);
                //PanelCtrl.instance.show(ModuleTypes.SHARE_PANEL);
            } else if (DataManager.ins.getData('gameAjaxElement').data.element.status == 4) {
                this.clearTap(this.startBtn,this.onTap_startBtn);
            } else if (DataManager.ins.getData('gameAjaxElement').data.element.status == 5 && DataManager.ins.getData('gameAjaxElement').data.element.freeLimit > 0) {
                this.doStart();
            } else if (DataManager.ins.getData('gameAjaxElement').data.element.status == 2 || DataManager.ins.getData('gameAjaxElement').data.element.needCreditsLong > DataManager.ins.getData('gameAjaxElement').data.element.myCreditsLong) {
                PanelCtrl.instance.show(ModuleTypes.GETCREDITS_PANEL);
            } else {
                this.doStart();

            }
        }
    }

    doStart() {
        Waiting.instance.show();
        NetConst.doJoin((s) => {
            if (!s) {
                // this.enableMouseEvt(true);
                Waiting.instance.hide();
                // let data = { msg: `${DataManager.ins.getData("doJoin").desc || "网络异常，请稍后再试~"}`, type: "tips" }
                // PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, data)
                ToastCtrl.instance.show(`活动太火爆了，请稍后再来~`);
                return
            }
            NetConst.getNgameStartStatus((ss) => {
                Waiting.instance.hide();
                if (!ss) {
                    ToastCtrl.instance.show(`活动太火爆了，请稍后再来~`);
                    return
                }
                SceneCtrl.instance.change(ModuleTypes.PLAY_SCENE);
            }, DataManager.ins.getData("doJoin").data, () => {
                return DataManager.ins.getData('getNgameStartStatus').code == 'C000000001'
            })
        })
    }

    onTap_ruleBtn() {
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);
    }

    onTap_prizeBtn() {
        //奖品页面
        if (DataManager.ins.customCfgData["uid"] == 'not_login') {
            // 未登录
            PanelCtrl.instance.show(ModuleTypes.LOGIN_PANEL);
            return
        }else{
            window.location.href = TwFun.getRecordUrl("00");
        }
       
    }
    onTap_rankBtn(){
        NetManager.ins.clickLog(this.rankBtnExposure);
        if (DataManager.ins.customCfgData["uid"] == 'not_login') {
            // 未登录
            PanelCtrl.instance.show(ModuleTypes.LOGIN_PANEL);
            return
        }else{
            NetConst.recentRankList((s)=>{
                if(!s){
                    // 容错
                    ToastCtrl.instance.show("活动太火爆了，请稍后再来");
                    return
                }
                PanelCtrl.instance.show(ModuleTypes.RANK_PANEL);
            },window['rankId'],DataManager.ins.customCfgData.actId)
        }

    }

    

    removeEvents() {
        super.removeEvents();
        this.clearTap(this.startBtn, this.onTap_startBtn);
        this.clearTap(this.ruleBtn, this.onTap_ruleBtn);
        this.clearTap(this.prizeBtn, this.onTap_prizeBtn);
        this.clearTap(this.rankBtn,this.onTap_rankBtn);

        

        this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    }
   
}