import Panel from "../views/Panel";
import Waiting from "../waiting/Waiting";
import NetConst from "../NetConst";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import submitAfterDostart from "../../libs/new_tw/ctrls/submitAfterDostart";

export default class RankPanel extends Panel{
    protected get skinKey() { return 'Rank' }
    public rankList:eui.Scroller;
    public rankGroup:eui.Group;
    public closeBtn:eui.Button;
    public myrank:eui.Label;
    public myscore:eui.Label;
    public mycake:eui.Label;

    constructor(){
        super();
        Waiting.instance.hide();
    }
    initEvents(){
        super.initEvents();
        this.onTap(this.closeBtn,this.onTap_closeBtn);
        
        this.showPanel();
    }
    
    onTap_closeBtn(e) {
        Waiting.instance.show();
        NetConst.ajaxElement((s) => {
            Waiting.instance.hide();
            this.hidePanel();
            SceneCtrl.instance.change(ModuleTypes.START_SCENE);
        })
    }
    showPanel(){
        if(DataManager.ins.getData('recentRankList').data){
            let i :number = 0;
            let ranklength:number = 0;
            if(DataManager.ins.getData('recentRankList').data.currentRankList.userRankList.length<=50){
                ranklength = DataManager.ins.getData('recentRankList').data.currentRankList.userRankList.length;
            }else{
                ranklength = 50;
            }
            for(i = 1; i<=ranklength;i++){
                if(DataManager.ins.getData('recentRankList').data.currentRankList.userRankList[i-1].rank == 1){
                    let img = new eui.Image();
                    img.source = "first_png";
                    img.x = 53
                    img.y = 0
                    img.width = 47
                    img.height = 52
                    this.rankGroup.addChild(img);

                }else  if(DataManager.ins.getData('recentRankList').data.currentRankList.userRankList[i-1].rank == 2){
                    let img = new eui.Image();
                    img.source = "second_png";
                    img.x = 53
                    img.y = 72
                    img.width = 47
                    img.height = 52
                    this.rankGroup.addChild(img);
                    
                }else  if(DataManager.ins.getData('recentRankList').data.currentRankList.userRankList[i-1].rank == 3){
                    let img = new eui.Image();
                    img.source = "third_png";
                    img.x = 53
                    img.y = 144
                    img.width = 47
                    img.height = 52
                    this.rankGroup.addChild(img);
                    
                }else{
                    let img = new eui.Image();
                    img.source = "point_png";
                    img.x = 57
                    img.y = 72*(i-1)
                    img.width = 40
                    img.height = 40
                    this.rankGroup.addChild(img);
                    let ranknum = new eui.Label();
                    ranknum.text = DataManager.ins.getData('recentRankList').data.currentRankList.userRankList[i-1].rank;
                    ranknum.size = 24
                    ranknum.x = img.x+img.width/2-ranknum.width/2;
                    ranknum.y =img.y+img.height/2-ranknum.height/2;
                    
                    ranknum.textColor = parseInt("040b34");
                    this.rankGroup.addChild(ranknum);
                }
                let imgline = new eui.Image();
                imgline.source = "underline_png";
                imgline.x = 53
                imgline.y = 60+(i-1)*72
                imgline.width = 548
                imgline.height = 1
                this.rankGroup.addChild(imgline);
                
                let rankid = new eui.Label();
                rankid.text = DataManager.ins.getData('recentRankList').data.currentRankList.userRankList[i-1].nickName;
                rankid.x = 193;
                rankid.y = (i-1)*72;
                rankid.size = 24;
                rankid.width = 230;
                rankid.height = 51;
                rankid.textColor = parseInt("ffffff",16);
                rankid.textAlign = "center";
                rankid.verticalAlign = "middle";
                this.rankGroup.addChild(rankid);

                let rankscore = new eui.Label();
                rankscore.text = DataManager.ins.getData('recentRankList').data.currentRankList.userRankList[i-1].maxScore;
                rankscore.width = 203
                rankscore.height = 51
                rankscore.x = 423
                rankscore.y = (i-1)*72;
                rankscore.size = 24
                rankscore.textColor = parseInt("ffffff",16);
                rankscore.textAlign = "center";
                rankscore.verticalAlign = "middle";
                this.rankGroup.addChild(rankscore);

            }

            if(DataManager.ins.getData('recentRankList').data.currentRankList.currentUserRankInfo){
                if(DataManager.ins.getData('recentRankList').data.currentRankList.currentUserRankInfo.rank<=5000){
                    this.myrank.size = 36
                    this.myrank.text = DataManager.ins.getData('recentRankList').data.currentRankList.currentUserRankInfo.rank;
                    
                }else{
                    this.myrank.size = 24;
                    this.myrank.text = "暂未上榜";
                }
                this.mycake.text = DataManager.ins.getData('recentRankList').data.currentRankList.currentUserRankInfo.maxScore;
            }
        }
    }
    
    removeEvents(){
        super.removeEvents();
        this.clearTap(this.closeBtn,this.onTap_closeBtn);
    }
}