import { DataManager } from './../../libs/tw/manager/DataManager';
import Panel from "../views/Panel";
import Waiting from '../waiting/Waiting';
import NetConst from '../NetConst';
import SceneCtrl from '../ctrls/sceneCtrl';
import { ModuleTypes } from '../types/sceneTypes';

export default class GetCreditsPanel extends Panel {

    get skinKey() { return "GetCredits" }

    // public bg: eui.Image;
    // public earnBtn: eui.Group;
    public btnTip: eui.Label;
    public closeBtn: eui.Button;
    public tips: eui.Label;
    public littletip:eui.Label;
    public getcreditsBtn:eui.Button;


    constructor() {
        super()
        this.btnTip.text = `去赚${DataManager.ins.customCfgData.unitName || '积分'}`;
        this.tips.text = `${DataManager.ins.customCfgData.unitName || '积分'}不够啦`;
        this.littletip.text = `今天${DataManager.ins.customCfgData.unitName || '积分'}不够啦，快去赚${DataManager.ins.customCfgData.unitName || '积分'}吧`
        this.btnTip.touchEnabled = false;
    }

    initEvents() {
        super.initEvents();
        //this.onTap(this.earnBtn, this.onTap_earnBtn);
        this.onTap(this.getcreditsBtn,this.onTap_earnBtn);
        this.onTap(this.closeBtn,this.onTap_closeBtn);
    }

    onTap_earnBtn() {

        // 赚积分链接
        if (window["CFG"] && window["CFG"].getCreditsLink && window["CFG"].getCreditsLink !== "") {
            window.location.href = window["CFG"].getCreditsLink;
        } else {
            this.hidePanel();
        }
    }
    onTap_closeBtn(e) {
        Waiting.instance.show();
        NetConst.ajaxElement((s) => {
            Waiting.instance.hide();
            this.hidePanel();
            SceneCtrl.instance.change(ModuleTypes.START_SCENE);
        })
    }

    removeEvents() {
        super.removeEvents();
        this.clearTap(this.getcreditsBtn, this.onTap_earnBtn);
        this.clearTap(this.closeBtn,this.onTap_closeBtn);
    }

}