import Panel from "../views/Panel";
import NetConst from "../NetConst";
import Waiting from "../waiting/Waiting";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import ToastCtrl from "../ctrls/toastCtrl";
import SceneCtrl from "../ctrls/sceneCtrl";
import getOptionImgSize from "../prize/data/getOptionImgSize";
import ImgSizeType from "../prize/data/ImgSizeType";
import { LotteryType } from "../../libs/tw/enum/LotteryType";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { ActivityModel } from "../../libs/tw/model/common/ActivityModel";
import { IExposureData } from "../../libs/tw/data/common/IExposureData";
import GameConst from "../GameConst";
import { Buried } from "../../libs/tw/util/Buried";

export default class EndPanel extends Panel{
    protected get skinKey() { return 'End' }
    public endnoprizeGroup:eui.Group;
    public juliLab:eui.Label;
    public cakeLab:eui.Label;
    public blockLab:eui.Label;
    public getRankBtn:eui.Button;

    public endprizeGroup:eui.Group;
    public julilab:eui.Label;
    public cakelab:eui.Label;
    public blocklab:eui.Label;
    public prizeimg:eui.Image;
    public restartBtn:eui.Button;
    public getprizeBtn:eui.Button;

    public closeBtn:eui.Button;
    public cakenum:number = 0;
    public blocknum:number = 0;
    public distancenum:number = 0;

    private prizeBtnExposure:any;

    protected get exposure(): IExposureData {
        return;
    }
    
    constructor(data){
        super();
        this.initUI(data);
    }
    initUI(data){
        let prizeBtnDpmOut = Buried.connectDpm(110, 1, 1); // 点击埋点   
        let prizeBtnDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.prizeBtnExposure = Buried.createExposure(prizeBtnDpmOut, prizeBtnDcmOut);
        NetManager.ins.showLog(this.prizeBtnExposure);

        this.endnoprizeGroup.visible = false;
        this.endprizeGroup.visible = true;
        this.closeBtn.visible = false;
        this.cakenum = data.cakenum;
        this.blocknum = data.blocknum;
        this.distancenum = data.distance;
        this.PrizePop();
        
        // NetConst.getOrderStatus(
        //     (ss) => {
        //         Waiting.instance.hide();
        //         if (!ss) {
        //             this.endnoprizeGroup.visible = true;
        //             this.NoPrizePop();
                    
        //             return
        //         }
                
        //         if (DataManager.ins.getData("getOrderStatus") && DataManager.ins.getData("getOrderStatus").data && DataManager.ins.getData("getOrderStatus").data.lottery && DataManager.ins.getData("getOrderStatus").data.lottery.type !== "thanks") {
        //             this.endprizeGroup.visible = true;
        //             this.PrizePop();
        //         } else {
        //             this.endnoprizeGroup.visible = true;
        //             this.NoPrizePop();
        //         }
        //     },
        //     DataManager.ins.getData("doJoin").data,
        //     () => {
        //         return DataManager.ins.getData("getOrderStatus").code == "C000000001";
        //     }
        // )
    }

    NoPrizePop(){
        this.juliLab.text = this.distancenum+"km";
        this.cakeLab.text = "共收集            ：" + this.cakenum + "个";
        this.blockLab.text = "碰到障碍        ：" + this.blocknum + "个";
        this.closeBtn.visible = true;
        this.closeBtn.y = 169;
        // this.onTap(this.getRankBtn,this.onTap_Rank);
        // this.onTap(this.closeBtn,this.onTap_closeBtn);

    }
    onTap_Rank(){
        Waiting.instance.show();
        NetConst.recentRankList((s)=>{
            if(!s){
                // 容错
                ToastCtrl.instance.show("活动太火爆了，请稍后再来");
                return
            }
            console.log(s)
            PanelCtrl.instance.show(ModuleTypes.RANK_PANEL);
        },window['rankId'],DataManager.ins.customCfgData.actId)
    }

    // get lottery() { return DataManager.ins.getData("getOrderStatus").data.lottery; }
    // get picWidth() { return 250 };
    // get picBigWidth() { return 500 };
    // get bigPicRatio() { return 640 / 300 }

    PrizePop(){
        this.julilab.text = this.distancenum + "km";
        this.cakelab.text = "共收集        ：" + this.cakenum + "个";
        this.blocklab.text = "碰到障碍        ：" + this.blocknum + "个";
        this.closeBtn.visible = true;
        this.closeBtn.y = 39;

        //奖品显示
        // if (this.lottery) {
        //     const sizeType = getOptionImgSize(this.lottery);
        //     if (ImgSizeType.BIG === sizeType) {

        //         this.prizeimg.width = this.picBigWidth;
        //         this.prizeimg.height = this.picBigWidth / this.bigPicRatio;
        //     } else {
        //         this.prizeimg.width = this.prizeimg.height = this.picWidth;
        //     }
        //     this.prizeimg.source = this.lottery.imgUrl;
        //     this.prizeimg.anchorOffsetX = 250 / 2;
        //     this.prizeimg.anchorOffsetY = 250 / 2;
        // }

        // this.onTap(this.closeBtn,this.onTap_closeBtn);
        // this.onTap(this.restartBtn,this.onTap_closeBtn);
        // this.onTap(this.getprizeBtn,this.onTap_getPrizeBtn);
    }

    initEvents(){
        super.initEvents();
        this.onTap(this.getRankBtn,this.onTap_Rank);
        this.onTap(this.closeBtn,this.onTap_closeBtn);
        this.onTap(this.restartBtn,this.onTap_closeBtn);
        this.onTap(this.getprizeBtn,this.onTap_getPrizeBtn);
    }
    onTap_closeBtn(e) {
        Waiting.instance.show();
        NetConst.ajaxElement((s) => {
            Waiting.instance.hide();
            this.hidePanel();
            SceneCtrl.instance.change(ModuleTypes.START_SCENE);
        })
    }
    
    onTap_getPrizeBtn(){
        NetManager.ins.clickLog(this.prizeBtnExposure);
        window.location.href = window['prizeUrl'] ? window['prizeUrl'] : 'https://www.baidu.com';

        // if (this.lottery.type == LotteryType.COUPON || this.lottery.type == LotteryType.LUCKY) {
            
        //     let isIOS:boolean = GameConst.isIOS();
        //     if(isIOS){
        //         window.location.href = this.lottery.iosDownloadUrl;
        //     }else{
        //         window.location.href = this.lottery.androidDownloadUrl
        //     }
        //     if (this.lottery.type == "lucky") {
        //         NetManager.ins.spmclick(this.exposure);
        //     }
        // }
        // else {
        //     window.location.href = this.lottery.link;
        // }
    }
    removeEvents(){
        super.removeEvents();
        this.clearTap(this.getRankBtn,this.onTap_Rank);
        this.clearTap(this.closeBtn,this.onTap_closeBtn);
        this.clearTap(this.restartBtn,this.onTap_closeBtn);
        this.clearTap(this.getprizeBtn,this.onTap_getPrizeBtn);
    }
    
}