export default class MovieClipCtrl {

    static _instance: MovieClipCtrl;
    public static get instance() {
        return MovieClipCtrl._instance || (MovieClipCtrl._instance = new MovieClipCtrl())
    }

    public movieClipPool: any[] = [];
    // 影片剪辑的配置属性
    public movieClipNamePool: any[] = [
        //{ name: 'guideTips', dataName: 'guideTips', num: 1 },
    ];

    // 初始化
    public init() {
        this.initMovieClip();
    }

    // 初始化影片剪辑
    private initMovieClip(): void {
        for (let m = 0; m < this.movieClipNamePool.length; m++) {
            this.ayncLoad2Mc(`${this.movieClipNamePool[m].name}_json`);
        }
    }

    // 异步加载动画资源
    private ayncLoad2Mc(resname: string): void {
        RES.getResAsync(resname, this.onLoad.bind(this), this);
    }

    // 加载完的回调
    private onLoad(data: any, key: string) {
        let scope = this;
        for (let m = 0; m < scope.movieClipNamePool.length; m++) {
            if (key == `${scope.movieClipNamePool[m].name}_json`) {
                scope.ayncLoad2Mc(`${scope.movieClipNamePool[m].name}_png`);
            } else if (key == `${scope.movieClipNamePool[m].name}_png`) {
                for (let i = 0; i < scope.movieClipNamePool[m].num; i++) {
                    let data2mc = RES.getRes(`${scope.movieClipNamePool[m].name}_json`);
                    let texture2mc = RES.getRes(`${scope.movieClipNamePool[m].name}_png`);
                    let mcFactory: egret.MovieClipDataFactory = new egret.MovieClipDataFactory(data2mc, texture2mc);
                    let mc: egret.MovieClip = new egret.MovieClip(mcFactory.generateMovieClipData(`${scope.movieClipNamePool[m].dataName}`));
                    mc.name = `${scope.movieClipNamePool[m].name}_${i}`;
                    scope.movieClipPool.push(mc);
                }
            }
        }
        console.log(scope.movieClipNamePool);

    }

    // 获取单个影片剪辑
    public getMovieClipByName(name: string): any {
        for (let mc = 0; mc < this.movieClipPool.length; mc++) {
            if (this.movieClipPool[mc].name == name) {
                return this.movieClipPool[mc];
            }
        }
    }

}