import { getSkinPath } from "../utils";

export default class ComponentBase extends eui.Component {
    protected data: any;
    constructor(data?) {
        super();
        this.data = data ? data : {};
        this.skinName = getSkinPath(this.skinKey);
        if (this.skin) {
            this.onSkinComplete();
        } else {
            this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        }

    }



    // 添加点击
    protected onTap(target, func) {
        target.addEventListener(egret.TouchEvent.TOUCH_TAP, func, this);
    }
    protected onTapBegin(target, func) {
        target.addEventListener(egret.TouchEvent.TOUCH_BEGIN, func, this);
    }
    protected onTapEnd(target, func) {
        target.addEventListener(egret.TouchEvent.TOUCH_END, func, this);
    }

    // 移除点击事件
    protected clearTap(target, func) {
        target.removeEventListener(egret.TouchEvent.TOUCH_TAP, func, this);
    }
    protected clearTapBegin(target, func) {
        target.removeEventListener(egret.TouchEvent.TOUCH_BEGIN, func, this);
    }
    protected clearTapEnd(target, func) {
        target.removeEventListener(egret.TouchEvent.TOUCH_END, func, this);
    }

    // 打印
    protected log(msg) {
        console.log(msg)
    }

    protected initEvents() { }

    protected removeEvents() { }

    start(data?) {

    }

    protected get skinKey() { return null }

    protected onSkinComplete() {
        this.initEvents();
    }

    destroy() {
        this.removeEvents();
    }

}