import { ModuleTypes } from './../types/sceneTypes';
import { NetManager } from "../../libs/tw/manager/NetManager";
import Panel from "../views/Panel";
import SceneCtrl from '../ctrls/sceneCtrl';
export default class Msg extends Panel {


    set message(val) {

    }
    set btnTxt(val) {

    }


    start(data?) {
        this.data.message = data ? (data.msg ? data.msg : '网络出现问题请稍后再试~') : '网络出现问题请稍后再试~';
        this.data.type = data ? (data.type ? data.type : 'err') : 'err';
        this.data.title = data ? (data.title ? data.title : null) : null;
        this.data.closeFun = data ? (data.closeFun ? data.closeFun : null) : null;
        this['msgTxt'].text = `${this.data.message}`;
        if (this.data.title) {
            if (this['msgTitle']) {
                this['msgTitle'].text = `${this.data.title}`;
            }
        }
    }

    protected get creditsOutBtns(): eui.Button[] {
        return [this['creditsOutBtn']]
    }

    protected get closeBtns(): eui.Button[] {
        return [this['closeBtn']]
    }

    public closeBtn: eui.Button;
    initEvents() {
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
    }

    private onTap_closeBtn(e: egret.TouchEvent) {
        this.hidePanel();
        if (this.data.closeFun) {
            this.data.closeFun();
        } else {
            switch (this.data.type) {
                case 'tips':

                    break;
                case 'err':
                    SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                    break;
                case 'creditsOut':
                    if (window['CFG'].appInfo && window['CFG'].appInfo.earnCreditsUrl) {
                        window.location.href = window['CFG'].appInfo.earnCreditsUrl;
                    } else {
                        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                    }
                    break;
                case 'requirelogin':
                    if (window['requirelogin']) {
                        window['requirelogin']();
                    } else {
                        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                    }
                    break;
                default:
                    SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                    break;
            }
        }
    }

    protected get skinKey() { return 'Msg' }
}