import { NetManager } from './../libs/tw/manager/NetManager';
import { INetData } from './../libs/tc/interface/INetData';
import Scene from "./views/Scene";
/**
 * 场景转换动画库
 */
export default class SceneTransitionAni {

    // 遮罩场景切换
    public static open(callback: Function, scene: Scene, type = 'circle', maskX = 375, maskY = 1206 / 2) {
        switch (type) {
            default:
            case 'circle':
                let mask = new egret.Shape();
                mask.graphics.beginFill(0xffffff, 1);
                mask.graphics.drawCircle(0, 0, 1624);
                mask.graphics.endFill();
                mask.x = maskX;
                mask.y = maskY;
                scene.mask = mask;
                scene.addChild(mask);

                //动态改变半径  随便在一个tween里改变半径，重画。
                //如果不改变shape的位置，就改变drawCircle(x,y,radius)里的x，y,

                let changer = { radius: 0 }
                let changerTW = egret.Tween.get(changer, {
                    onChange: () => {
                        mask.graphics.clear();
                        mask.graphics.beginFill(0xFFFFFF, 1);
                        mask.graphics.drawCircle(0, 0, changer.radius);
                        mask.graphics.endFill();

                    }
                });

                changerTW.wait(100).to({ radius: 1000 }, 500).call(() => {
                    scene.removeChild(mask);
                    scene.mask = null;
                    callback();

                });
                break;
        }
    }

    public static close(callback: Function, scene: Scene, type = 'circle', maskX = 375, maskY = 1206 / 2) {
        switch (type) {
            default:
            case 'circle':
                let mask = new egret.Shape();
                mask.graphics.beginFill(0xffffff, 1);
                mask.graphics.drawCircle(0, 0, 1624);
                mask.graphics.endFill();
                mask.x = maskX;
                mask.y = maskY;
                scene.mask = mask;
                scene.addChild(mask);

                //动态改变半径  随便在一个tween里改变半径，重画。
                //如果不改变shape的位置，就改变drawCircle(x,y,radius)里的x，y,

                let changer = { radius: 1000 }
                let changerTW = egret.Tween.get(changer, {
                    onChange: () => {
                        mask.graphics.clear();
                        mask.graphics.beginFill(0xFFFFFF, 1);
                        mask.graphics.drawCircle(0, 0, changer.radius);
                        mask.graphics.endFill();

                    }
                });

                changerTW.to({ radius: 0 }, 500).wait(100).call(() => {
                    scene.removeChild(mask);
                    scene.mask = null;
                    callback();

                });
                break;
        }
    }

    public static closeAndOpen(callback: Function, scene: Scene, type = 'circle', maskX = 375, maskY = 1206 / 2) {
        switch (type) {
            default:
            case 'circle':
                let mask = new egret.Shape();
                mask.graphics.beginFill(0xffffff, 1);
                mask.graphics.drawCircle(0, 0, 1624);
                mask.graphics.endFill();
                mask.x = maskX;
                mask.y = maskY;
                scene.mask = mask;
                scene.addChild(mask);

                //动态改变半径  随便在一个tween里改变半径，重画。
                //如果不改变shape的位置，就改变drawCircle(x,y,radius)里的x，y,

                let changer = { radius: 1000 }
                let changerTW = egret.Tween.get(changer, {
                    onChange: () => {
                        mask.graphics.clear();
                        mask.graphics.beginFill(0xFFFFFF, 1);
                        mask.graphics.drawCircle(0, 0, changer.radius);
                        mask.graphics.endFill();
                    }
                });

                changerTW.to({ radius: 0 }, 500).wait(100).to({ radius: 1200 }).call(() => {
                    scene.removeChild(mask);
                    scene.mask = null;
                    callback();

                });
                break;
        }
    }
}