import { Buried } from './../libs/tw/util/Buried';
import { NetManager } from './../libs/tw/manager/NetManager';
import { DataManager } from './../libs/tw/manager/DataManager';
import NetConst from "./NetConst";

export default class NetModel {

    protected async  createGameScene() {
        // await Promise.all([this.yyh_baseinfo(), this.ajaxElement()]);
        // SceneCtrl.instance.change(ModuleTypes.START_SCENE);
    }

    // yyh_baseinfo() {
    //     return new Promise((r) => {
    //         NetManager.ins.yyh_baseinfo(() => {
    //             r();
    //         });
    //     });
    // }

    public static async ajaxElement() {
        return new Promise((resolve) => {
            NetManager.ins.ajaxElement(async () => {
                Buried.init();
                resolve();
            });
        })
    }

    public static async doJoin(callback: Function) {
        return new Promise((resolve, reject) => {
            NetConst.doJoin((s) => {
                resolve(DataManager.ins.getData("doJoin"))
            })
        })
    }

    public static ngameSubmit(orderId, score, rankId = null, gameData = [], dynamicData = [], submitToken = DataManager.ins.getData("getNgameStartStatus").data.submitToken) {
        return new Promise(resolve => {
            NetConst.ngameSubmit(() => {
                resolve(DataManager.ins.getData("ngameSubmit"))
            }, orderId, score, gameData, dynamicData, submitToken, rankId)
        })
    }

    public static getOrderStatus(orderId = DataManager.ins.getData("doJoin").data) {
        return new Promise(resolve => {
            NetConst.getOrderStatus(
                () => {
                    resolve(DataManager.ins.getData("getOrderStatus"))
                },
                orderId,
                () => {
                    return DataManager.ins.getData("getOrderStatus").code == "C000000001";
                },
                10)
        })
    }

    public static async submit(orderId, score, rankId = null, gameData = [], dynamicData = [], submitToken = DataManager.ins.getData("getNgameStartStatus").data.submitToken) {
        return new Promise(async (resolve) => {
            let submitData = await this.ngameSubmit(orderId, score, rankId, gameData, dynamicData, submitToken)
            if (!submitData['success']) {
                resolve(submitData)
                return
            }
            let getOrderStatusData = await this.getOrderStatus();
            resolve(getOrderStatusData)
        })


    }

    // 提交分数
    public static submit2(orderId, score, gameData = [], dynamicData = [], submitToken = DataManager.ins.getData("game"), rankId = null) {
        return new Promise((resolve, reject) => {
            NetConst.ngameSubmit((s) => {
                if (!s) {
                    resolve(DataManager.ins.getData("ngameSubmit"));
                    return
                }
                NetConst.getOrderStatus(
                    (ss) => {
                        resolve(DataManager.ins.getData("getOrderStatus"))
                    },
                    DataManager.ins.getData("doJoin").data,
                    () => {
                        return DataManager.ins.getData("getOrderStatus").code == "C000000001";
                    },
                    10
                )
            }, orderId, score, gameData, dynamicData, submitToken, rankId)
        })
    }
}