"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var TwFun_1 = require("./../../libs/tw/util/TwFun");
var sceneTypes_1 = require("./../types/sceneTypes");
var DataManager_1 = require("./../../libs/tw/manager/DataManager");
var Scene_1 = require("../views/Scene");
var panelCtrl_1 = require("../ctrls/panelCtrl");
var NetConst_1 = require("../NetConst");
var sceneCtrl_1 = require("../ctrls/sceneCtrl");
var toastCtrl_1 = require("../ctrls/toastCtrl");
var Waiting_1 = require("../waiting/Waiting");
var Buried_1 = require("../../libs/tw/util/Buried");
var NetManager_1 = require("../../libs/tw/manager/NetManager");
var StartScene = (function (_super) {
    __extends(StartScene, _super);
    function StartScene() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(StartScene.prototype, "skinKey", {
        get: function () { return 'Start'; },
        enumerable: true,
        configurable: true
    });
    StartScene.prototype.onSkinComplete = function () {
        _super.prototype.onSkinComplete.call(this);
        this.initBuired();
        this.initUI();
        this.initAni();
    };
    StartScene.prototype.initBuired = function () {
        var startBtnDpmOut = Buried_1.Buried.connectDpm(110, 1, 1); // 点击埋点   
        var startBtnDcmOut = Buried_1.Buried.connectDcm(202, 0, 0); // 曝光埋点
        this.startBtnExposure = Buried_1.Buried.createExposure(startBtnDpmOut, startBtnDcmOut);
        NetManager_1.NetManager.ins.showLog(this.startBtnExposure);
    };
    StartScene.prototype.initUI = function () {
        this.updateData();
    };
    StartScene.prototype.initAni = function () {
        this.startBtn.visible = true;
        egret.Tween.get(this.startBtn, { loop: true })
            .set({ scaleX: 1, scaleY: 1 })
            .to({ scaleX: 0.8, scaleY: 0.8 }, 1000)
            .to({ scaleX: 1, scaleY: 1 }, 1000);
    };
    StartScene.prototype.updateData = function () {
        if (DataManager_1.DataManager.ins.customCfgData["uid"] == 'not_login') {
            // 未登录
            this.costTxt.text = "\u672A\u767B\u5F55";
            return;
        }
        if (DataManager_1.DataManager.ins.getData('gameAjaxElement').data && DataManager_1.DataManager.ins.getData('gameAjaxElement').data.element) {
            if (DataManager_1.DataManager.ins.getData('gameAjaxElement').data.element.status == 3) {
                this.costTxt.text = "\u6E38\u620F\u6B21\u6570\u5DF2\u7528\u5B8C";
            }
            else if (DataManager_1.DataManager.ins.getData('gameAjaxElement').data.element.status == 4) {
                this.costTxt.text = "\u4ECA\u65E5\u6B21\u6570\u5DF2\u7528\u5B8C";
            }
            else if (DataManager_1.DataManager.ins.getData('gameAjaxElement').data.element.status == 5 && DataManager_1.DataManager.ins.getData('gameAjaxElement').data.element.freeLimit > 0) {
                this.costTxt.text = "\u5F53\u524D\u8FD8\u6709" + DataManager_1.DataManager.ins.getData('gameAjaxElement').data.element.freeLimit + "\u6B21\u514D\u8D39\u6B21\u6570";
            }
            else if (DataManager_1.DataManager.ins.getData('gameAjaxElement').data.element.status == 7 && DataManager_1.DataManager.ins.getData('gameAjaxElement').data.element.freeLimit > 0) {
                this.costTxt.text = "\u5269\u4F59\u514D\u8D39\u6B21\u6570:" + DataManager_1.DataManager.ins.getData('gameAjaxElement').data.element.freeLimit + "\u6B21";
            }
            else if (DataManager_1.DataManager.ins.getData('gameAjaxElement').data.element.status == 2 || DataManager_1.DataManager.ins.getData('gameAjaxElement').data.element.needCreditsLong > DataManager_1.DataManager.ins.getData('gameAjaxElement').data.element.myCreditsLong) {
                this.costTxt.text = (DataManager_1.DataManager.ins.customCfgData.unitName || '积分') + "\u4E0D\u8DB3";
            }
            else {
                this.costTxt.text = "\u6D88\u8017" + DataManager_1.DataManager.ins.getData('gameAjaxElement').data.element.needCredits + (DataManager_1.DataManager.ins.customCfgData.unitName || '积分') + "/\u6B21";
            }
        }
    };
    StartScene.prototype.initEvents = function () {
        _super.prototype.initEvents.call(this);
        this.onTap(this.startBtn, this.onTap_startBtn);
        this.onTap(this.ruleBtn, this.onTap_ruleBtn);
        this.onTap(this.prizeBtn, this.onTap_prizeBtn);
        this.onTap(this.rankBtn, this.onTap_rankBtn);
        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    };
    StartScene.prototype.onEnterFrame = function () {
        this.startGroup1.y += 10;
        this.startGroup2.y += 10;
        if (this.startGroup1.y >= this.startGroup1.height) {
            this.startGroup1.y = this.startGroup2.y - this.startGroup1.height;
        }
        if (this.startGroup2.y >= this.startGroup2.height) {
            this.startGroup2.y = this.startGroup1.y - this.startGroup2.height;
        }
    };
    StartScene.prototype.onTap_startBtn = function (e) {
        NetManager_1.NetManager.ins.clickLog(this.startBtnExposure);
        if (DataManager_1.DataManager.ins.customCfgData["uid"] == 'not_login') {
            // 未登录
            panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.LOGIN_PANEL);
            return;
        }
        if (DataManager_1.DataManager.ins.getData('gameAjaxElement').data && DataManager_1.DataManager.ins.getData('gameAjaxElement').data.element) {
            if (DataManager_1.DataManager.ins.getData('gameAjaxElement').data.element.status == 3) {
                //ToastCtrl.instance.show(`游戏次数已用完`);
                //PanelCtrl.instance.show(ModuleTypes.SHARE_PANEL);
            }
            else if (DataManager_1.DataManager.ins.getData('gameAjaxElement').data.element.status == 4) {
                this.clearTap(this.startBtn, this.onTap_startBtn);
            }
            else if (DataManager_1.DataManager.ins.getData('gameAjaxElement').data.element.status == 5 && DataManager_1.DataManager.ins.getData('gameAjaxElement').data.element.freeLimit > 0) {
                this.doStart();
            }
            else if (DataManager_1.DataManager.ins.getData('gameAjaxElement').data.element.status == 2 || DataManager_1.DataManager.ins.getData('gameAjaxElement').data.element.needCreditsLong > DataManager_1.DataManager.ins.getData('gameAjaxElement').data.element.myCreditsLong) {
                panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.GETCREDITS_PANEL);
            }
            else {
                this.doStart();
            }
        }
    };
    StartScene.prototype.doStart = function () {
        Waiting_1.default.instance.show();
        NetConst_1.default.doJoin(function (s) {
            if (!s) {
                // this.enableMouseEvt(true);
                Waiting_1.default.instance.hide();
                // let data = { msg: `${DataManager.ins.getData("doJoin").desc || "网络异常，请稍后再试~"}`, type: "tips" }
                // PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, data)
                toastCtrl_1.default.instance.show("\u6D3B\u52A8\u592A\u706B\u7206\u4E86\uFF0C\u8BF7\u7A0D\u540E\u518D\u6765~");
                return;
            }
            NetConst_1.default.getNgameStartStatus(function (ss) {
                Waiting_1.default.instance.hide();
                if (!ss) {
                    toastCtrl_1.default.instance.show("\u6D3B\u52A8\u592A\u706B\u7206\u4E86\uFF0C\u8BF7\u7A0D\u540E\u518D\u6765~");
                    return;
                }
                sceneCtrl_1.default.instance.change(sceneTypes_1.ModuleTypes.PLAY_SCENE);
            }, DataManager_1.DataManager.ins.getData("doJoin").data, function () {
                return DataManager_1.DataManager.ins.getData('getNgameStartStatus').code == 'C000000001';
            });
        });
    };
    StartScene.prototype.onTap_ruleBtn = function () {
        panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.RULE_PANEL);
    };
    StartScene.prototype.onTap_prizeBtn = function () {
        //奖品页面
        if (DataManager_1.DataManager.ins.customCfgData["uid"] == 'not_login') {
            // 未登录
            panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.LOGIN_PANEL);
            return;
        }
        else {
            window.location.href = TwFun_1.TwFun.getRecordUrl("00");
        }
    };
    StartScene.prototype.onTap_rankBtn = function () {
        if (DataManager_1.DataManager.ins.customCfgData["uid"] == 'not_login') {
            // 未登录
            panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.LOGIN_PANEL);
            return;
        }
        else {
            NetConst_1.default.recentRankList(function (s) {
                if (!s) {
                    // 容错
                    toastCtrl_1.default.instance.show("活动太火爆了，请稍后再来");
                    return;
                }
                panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.RANK_PANEL);
            }, window['rankId'], DataManager_1.DataManager.ins.customCfgData.actId);
        }
    };
    StartScene.prototype.removeEvents = function () {
        _super.prototype.removeEvents.call(this);
        this.clearTap(this.startBtn, this.onTap_startBtn);
        this.clearTap(this.ruleBtn, this.onTap_ruleBtn);
        this.clearTap(this.prizeBtn, this.onTap_prizeBtn);
        this.clearTap(this.rankBtn, this.onTap_rankBtn);
        this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    };
    return StartScene;
}(Scene_1.default));
exports.default = StartScene;
__reflect(StartScene.prototype, "\"e:/zqty/egret/src/startScene/StartScene\".StartScene");
//# sourceMappingURL=StartScene.js.map