"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var DataManager_1 = require("./../../libs/tw/manager/DataManager");
var HtmlTextParser_1 = require("./HtmlTextParser");
var Panel_1 = require("../views/Panel");
var NetConst_1 = require("../NetConst");
var RulePanel = (function (_super) {
    __extends(RulePanel, _super);
    function RulePanel() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.textstring = "";
        _this.endstr = "";
        return _this;
    }
    RulePanel.prototype.start = function () {
        var _this = this;
        if (window['ruleTxt']) {
            this.labContent.textFlow = (new HtmlTextParser_1.HtmlTextParser).parser(window['ruleTxt']);
            this.labContent.textColor = parseInt("fcffb4", 16);
        }
        else {
            if (!DataManager_1.DataManager.ins.getData("gameAjaxElement").data || !DataManager_1.DataManager.ins.getData("gameAjaxElement").data.rule) {
                NetConst_1.default.ajaxElement(function () {
                    // DataManager
                    _this.addRule();
                });
            }
            else {
                this.addRule();
            }
        }
    };
    RulePanel.prototype.addRule = function () {
        var text = DataManager_1.DataManager.ins.getData("gameAjaxElement").data.rule;
        this.textstring = text;
        this.replaceWord();
        this.labContent.textFlow = (new HtmlTextParser_1.HtmlTextParser).parser(this.textstring);
        this.labContent.textColor = parseInt("fcffb4", 16);
    };
    RulePanel.prototype.replaceWord = function () {
        if (this.textstring.search("</p>") == -1) {
            if (this.endstr) {
                this.textstring = this.endstr;
            }
        }
        else {
            this.textstring = this.textstring.replace("</p>", "</p><br>");
            this.endstr = this.endstr.concat(this.textstring.slice(0, this.textstring.search("</p>") + 8));
            this.textstring = this.textstring.slice(this.textstring.search("</p>") + 8, this.textstring.length);
            this.replaceWord();
        }
    };
    Object.defineProperty(RulePanel.prototype, "skinKey", {
        get: function () { return 'Rule'; },
        enumerable: true,
        configurable: true
    });
    return RulePanel;
}(Panel_1.default));
exports.default = RulePanel;
__reflect(RulePanel.prototype, "\"e:/zqty/egret/src/rulePanel/RulePanel\".RulePanel");
//# sourceMappingURL=RulePanel.js.map