/**
 * Created by rockyl on 2018/8/16.
 *
 * 滚动式背景图
 */
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
var LoopComponent = (function (_super) {
    __extends(LoopComponent, _super);
    function LoopComponent() {
        var _this = _super.call(this) || this;
        _this.onceInfo = { width: 0, height: 0, count: 0 };
        _this.loopInfo = { width: 0, height: 0, count: 0 };
        _this.parts = [];
        return _this;
    }
    LoopComponent.prototype.setup = function (parts, info) {
        var _this = this;
        parts.forEach(function (item, index) {
            var part;
            if (typeof item == 'string') {
                part = new egret.Bitmap(RES.getRes(item));
            }
            else if (item instanceof egret.Texture) {
                part = new egret.Bitmap(item);
            }
            else {
                part = item;
            }
            _this.addChild(part);
            _this.parts.push(part);
            if (index == 0) {
                info.width = part.width;
                info.height = part.height;
            }
        });
        info.count = parts.length;
        this.setViewport(0, 0);
    };
    LoopComponent.prototype.setupOnce = function (resArr) {
        this.setup(resArr, this.onceInfo);
    };
    LoopComponent.prototype.setupLoop = function (resArr) {
        this.setup(resArr, this.loopInfo);
    };
    LoopComponent.prototype.setViewport = function (x, y) {
        if (y === void 0) { y = 0; }
        var sizeField = y == 0 ? 'width' : 'height';
        var posField = y == 0 ? 'x' : 'y';
        var pos = y == 0 ? x : y;
        var index;
        var onceSize = this.onceInfo[sizeField];
        var onceCount = this.onceInfo.count;
        var loopCount = this.loopInfo.count;
        var loopSize = this.loopInfo[sizeField];
        index = onceSize == 0 ? -1 : Math.floor(pos / onceSize);
        if (index < 0 || index >= onceCount) {
            var loopIndex = Math.floor((pos - onceCount * onceSize) / this.loopInfo[sizeField]);
            index = onceCount + loopIndex;
        }
        var formerIndex = index < onceCount ? index : (index) % loopCount + onceCount;
        var latterIndex = index < onceCount ? index + 1 : (index - onceCount + 1) % loopCount + onceCount;
        var former = this.parts[formerIndex];
        var latter = this.parts[latterIndex];
        if (!former || !latter) {
            console.log(formerIndex, latterIndex);
        }
        former[posField] = -(pos - loopSize * (index < onceCount ? index : index - onceCount) - (index < onceCount ? 0 : onceCount * onceSize));
        latter[posField] = former.x + (index < onceCount ? onceSize : loopSize);
    };
    return LoopComponent;
}(egret.DisplayObjectContainer));
__reflect(LoopComponent.prototype, "LoopComponent");
//# sourceMappingURL=LoopComponent.js.map