"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var NetManager_1 = require("./../../libs/tw/manager/NetManager");
var Buried_1 = require("./../../libs/tw/util/Buried");
var Scene_1 = require("../views/Scene");
var sceneTypes_1 = require("../types/sceneTypes");
var sceneCtrl_1 = require("../ctrls/sceneCtrl");
// import BridgeFactory from "../../libs/JSBridge/bridge/BridgeFactory";
var LoadingScene = (function (_super) {
    __extends(LoadingScene, _super);
    function LoadingScene() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.isNormalLoaded = false;
        _this.isVideoCanPlay = false;
        _this.isAniEnd = false;
        _this.video = document.getElementById('my_video');
        _this.normalPrecent = 0;
        _this.booksPrecent = 0;
        _this.peoplePrecent = 0;
        _this.bigImagePrecent = 0;
        _this.targetValue = 0;
        return _this;
    }
    Object.defineProperty(LoadingScene.prototype, "skinKey", {
        get: function () { return 'Loading'; },
        enumerable: true,
        configurable: true
    });
    LoadingScene.prototype.start = function () {
        var _this = this;
        egret.Tween.removeAllTweens();
        if (this.loadingBar) {
            this.loadingBar.value = 0;
            this.loadingBar['progressNum'].text = Math.ceil(this.loadingBar.value) + "%";
        }
        console.log("isInApp:" + window['isInApp']);
        // 初始化埋点信息
        this.initBuired();
        // 初始化标题动画
        this.initTitleAni();
        // 初始化星星动画
        this.initStarAni();
        // 初始化粒子效果
        this.initSprite();
        // 侦听视频能否播放
        this.video.addEventListener('canplay', this.onVideoCanPlay.bind(this));
        this.checkInterval = setInterval(function () {
            _this.checkAllResLoaded();
        }, 500);
    };
    // 初始化埋点信息
    LoadingScene.prototype.initBuired = function () {
        Buried_1.Buried.init();
        if (window['isInApp']) {
            // 端内
            var loadingDpmIn = Buried_1.Buried.connectDpm(110, 1, 1); // 点击埋点   
            var loadingDcmIn = Buried_1.Buried.connectDcm(202, 0, 0); // 曝光埋点
            this.loadingExposure = Buried_1.Buried.createExposure(loadingDpmIn, loadingDcmIn);
        }
        else {
            // 端外
            var loadingDpmOut = Buried_1.Buried.connectDpm(110, 10, 1); // 点击埋点   
            var loadingDcmOut = Buried_1.Buried.connectDcm(202, 0, 0); // 曝光埋点
            this.loadingExposure = Buried_1.Buried.createExposure(loadingDpmOut, loadingDcmOut);
        }
        NetManager_1.NetManager.ins.showLog(this.loadingExposure);
    };
    // 初始化标题动画
    LoadingScene.prototype.initTitleAni = function () {
        var _this = this;
        this.title1.alpha = 0;
        this.title2.alpha = 0;
        this.title3.alpha = 0;
        var title1TW = egret.Tween.get(this.title1);
        title1TW.to({ alpha: 1 }, 1200).call(function () {
            var title2TW = egret.Tween.get(_this.title2);
            title2TW.to({ alpha: 1 }, 1200).call(function () {
                var title3TW = egret.Tween.get(_this.title3);
                title3TW.to({ alpha: 1 }, 1200).call(function () {
                    _this.isAniEnd = true;
                    _this.checkAllResLoaded();
                });
            });
        });
    };
    // 初始化星星动画
    LoadingScene.prototype.initStarAni = function () {
        var _this = this;
        var _loop_1 = function (i) {
            var tempY = this_1["star" + i].y;
            var starTW = egret.Tween.get(this_1["star" + i], { loop: true });
            starTW.wait(2000 * Math.random()).call(function () {
                var starTW2 = egret.Tween.get(_this["star" + i], { loop: true });
                starTW2.to({ y: tempY - 15 }, 1200).to({ y: tempY + 15 }, 2400).to({ y: tempY }, 1200);
            });
        };
        var this_1 = this;
        for (var i = 1; i <= 5; i++) {
            _loop_1(i);
        }
    };
    // 初始化粒子效果
    LoadingScene.prototype.initSprite = function () {
        var _this = this;
        var _loop_2 = function (i) {
            var sprite = new eui.Image();
            sprite.source = "upSprite" + [1, 2][Math.round(Math.random())] + "_png";
            sprite.anchorOffsetX = sprite.width / 2;
            sprite.anchorOffsetY = sprite.height / 2;
            sprite.rotation = 360 * Math.random();
            var scale = Math.max(Math.random() * 0.8, 0.5);
            sprite.scaleX = scale;
            sprite.scaleY = scale;
            sprite.x = Math.max(Math.min(750 * Math.random(), 700), 50 + [1, -1][Math.round(Math.random())] * 20 * Math.random());
            sprite.y = 150 + 800 * Math.random();
            var targetY = Math.max(Math.abs(sprite.y - 500 * Math.random()), 150);
            this_2.addChild(sprite);
            var spriteTW = egret.Tween.get(sprite);
            spriteTW.to({ y: targetY }, Math.max(Math.random() * 10000, 5000)).call(function () {
                _this.removeChild(sprite);
            });
        };
        var this_2 = this;
        for (var i = 0; i < 25; i++) {
            _loop_2(i);
        }
        for (var i = 0; i < 60; i++) {
            var sprite = new eui.Image();
            sprite.source = "upSprite" + [1, 2][Math.round(Math.random())] + "_png";
            sprite.anchorOffsetX = sprite.width / 2;
            sprite.anchorOffsetY = sprite.height / 2;
            sprite.rotation = 360 * Math.random();
            var scale = Math.max(Math.random() * 0.8, 0.5);
            sprite.scaleX = scale;
            sprite.scaleY = scale;
            sprite.x = Math.max(Math.min(750 * Math.random(), 700), 50);
            sprite.y = 150 + 800 * Math.random();
            sprite.alpha = 0;
            var targetY = Math.max(Math.abs(sprite.y - 500 * Math.random()), 150 + 50 * Math.random());
            this.addChild(sprite);
            var spriteTW = egret.Tween.get(sprite, { loop: true });
            spriteTW.wait(7000 * Math.random()).to({ alpha: 1 }, 1).to({ y: targetY }, Math.max(Math.random() * 10000, 5000));
        }
        this.addChild(this.title1);
        this.addChild(this.title2);
        this.addChild(this.title3);
        this.addChild(this.star1);
        this.addChild(this.star2);
        this.addChild(this.star3);
        this.addChild(this.star4);
        this.addChild(this.star5);
        this.addChild(this.star5F);
        this.addChild(this.loadingBar);
    };
    // 侦听事件
    LoadingScene.prototype.initEvents = function () {
        RES.addEventListener(RES.ResourceEvent.GROUP_PROGRESS, this.onResourceProgress, this);
        this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_StartBtn, this);
    };
    LoadingScene.prototype.removeEvents = function () {
        RES.removeEventListener(RES.ResourceEvent.GROUP_PROGRESS, this.onResourceProgress, this);
        this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_StartBtn, this);
    };
    // preload资源组加载进度
    LoadingScene.prototype.onResourceProgress = function (event) {
        if (event.groupName == "Normal") {
            this.normalPrecent = event.itemsLoaded / event.itemsTotal * 100;
        }
        else if (event.groupName == "Books") {
            this.booksPrecent = event.itemsLoaded / event.itemsTotal * 100;
        }
        else if (event.groupName == "People") {
            this.peoplePrecent = event.itemsLoaded / event.itemsTotal * 100;
        }
        else if (event.groupName == "BigImage") {
            this.bigImagePrecent = event.itemsLoaded / event.itemsTotal * 100;
        }
        if (!this.isVideoCanPlay) {
            // 视频未加载完毕时，只让进度条到70%
            if (this.loadingBar) {
                this.loadingTW = egret.Tween.get(this.loadingBar, { onChange: this.onLoadingChange.bind(this) });
                this.targetValue = this.normalPrecent * 0.2 + this.booksPrecent * 0.2 + this.peoplePrecent * 0.2 + this.bigImagePrecent * 0.2;
                this.loadingTW.to({ value: this.targetValue }, 200);
                // this.loadingBar.value = ;
                // this.loadingBar['progressNum'].text = `${Math.ceil(this.normalPrecent * 0.2 + this.booksPrecent * 0.2 + this.peoplePrecent * 0.2 + this.bigImagePrecent * 0.2)}%`;
            }
        }
        else {
            // 视频加载完毕，让进度条到100%
            if (this.loadingBar) {
                this.loadingTW = egret.Tween.get(this.loadingBar, { onChange: this.onLoadingChange.bind(this) });
                this.targetValue = this.normalPrecent * 0.25 + this.booksPrecent * 0.25 + this.peoplePrecent * 0.25 + this.bigImagePrecent * 0.25;
                this.loadingTW.to({ value: this.targetValue }, 200);
                // this.loadingBar.value = this.normalPrecent * 0.25 + this.booksPrecent * 0.25 + this.peoplePrecent * 0.25 + this.bigImagePrecent * 0.25;
                // this.loadingBar['progressNum'].text = `${Math.ceil(this.normalPrecent * 0.25 + this.booksPrecent * 0.25 + this.peoplePrecent * 0.25 + this.bigImagePrecent * 0.25)}%`;
            }
        }
        console.log("\u52A0\u8F7D\u8FDB\u5EA6\uFF1A" + this.targetValue);
        if (window['isBigImageLoaded'] || window['isNormalLoaded'] || window['isBooksLoaded'] || window['isPeopleLoaded'] || this.normalPrecent * 0.25 + this.booksPrecent * 0.25 + this.peoplePrecent * 0.25 + this.bigImagePrecent * 0.25 >= 100) {
            this.checkAllResLoaded();
        }
        this.checkAllResLoaded();
    };
    LoadingScene.prototype.onTap_StartBtn = function () {
        NetManager_1.NetManager.ins.clickLog(this.loadingExposure);
        sceneCtrl_1.default.instance.change(sceneTypes_1.ModuleTypes.START_SCENE);
        this.video.volume = 0.0;
        this.video.play();
        this.video.pause();
    };
    LoadingScene.prototype.onVideoCanPlay = function (e) {
        window['isVideoCanPlay'] = true;
        this.checkAllResLoaded();
    };
    LoadingScene.prototype.checkAllResLoaded = function () {
        var _this = this;
        if (this.isIOS()) {
            if (this.isAniEnd && window['isBigImageLoaded'] && window['isNormalLoaded'] && window['isBooksLoaded'] && window['isPeopleLoaded']) {
                clearInterval(this.checkInterval);
                if (this.loadingBar.value !== 100) {
                    var loadingTW = egret.Tween.get(this.loadingBar, { onChange: this.onLoadingChange.bind(this) });
                    loadingTW.to({ value: 100 }, 500).call(function () {
                        // SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                        _this.loadingBar.visible = false;
                        _this.startBtn.visible = true;
                        _this.startBtn.alpha = 0.5;
                        var tw = egret.Tween.get(_this.startBtn);
                        tw.to({ alpha: 1 }, 500).call(function () {
                            var tw2 = egret.Tween.get(_this.startBtn, { loop: true });
                            tw2.to({ alpha: 0.8 }, 2000).to({ alpha: 1 }, 2000);
                        });
                    });
                }
                else {
                    // SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                    this.startBtn.visible = true;
                    this.loadingBar.visible = false;
                    this.startBtn.visible = true;
                    this.startBtn.alpha = 0.5;
                    var tw = egret.Tween.get(this.startBtn);
                    tw.to({ alpha: 1 }).call(function () {
                        var tw2 = egret.Tween.get(_this.startBtn, { loop: true });
                        tw2.to({ alpha: 0.8 }, 2000).to({ alpha: 1 }, 2000);
                    });
                }
            }
        }
        else {
            if (this.isAniEnd && window['isNormalLoaded'] && window['isVideoCanPlay'] && window['isBigImageLoaded'] && window['isBooksLoaded'] && window['isPeopleLoaded']) {
                clearInterval(this.checkInterval);
                if (this.loadingBar.value !== 100) {
                    var loadingTW = egret.Tween.get(this.loadingBar, { onChange: this.onLoadingChange.bind(this) });
                    loadingTW.to({ value: 100 }, 500).call(function () {
                        sceneCtrl_1.default.instance.change(sceneTypes_1.ModuleTypes.START_SCENE);
                    });
                }
                else {
                    sceneCtrl_1.default.instance.change(sceneTypes_1.ModuleTypes.START_SCENE);
                }
            }
        }
    };
    LoadingScene.prototype.isIOS = function () {
        var u = navigator.userAgent;
        var isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/);
        return isiOS;
    };
    LoadingScene.prototype.onLoadingChange = function () {
        if (this && this.loadingBar) {
            this.loadingBar['progressNum'].text = Math.ceil(this.loadingBar.value) + "%";
        }
    };
    LoadingScene.prototype.onTap_startBtn = function (e) {
        sceneCtrl_1.default.instance.change(sceneTypes_1.ModuleTypes.START_SCENE);
    };
    return LoadingScene;
}(Scene_1.default));
exports.default = LoadingScene;
__reflect(LoadingScene.prototype, "\"e:/zqty/egret/src/loadingScene/LoadingScene\".LoadingScene");
//# sourceMappingURL=LoadingScene.js.map