"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var sceneTypes_1 = require("../types/sceneTypes");
var Waiting_1 = require("../waiting/Waiting");
var Toast_1 = require("../views/Toast");
var ToastCtrl = (function () {
    function ToastCtrl() {
    }
    Object.defineProperty(ToastCtrl, "instance", {
        /**
         * 实例
         */
        get: function () {
            return ToastCtrl._instance || (ToastCtrl._instance = new ToastCtrl());
        },
        enumerable: true,
        configurable: true
    });
    /**
     * 初始化
     * @param parent 赋值父级
     */
    ToastCtrl.prototype.init = function (parent) {
        this._parent = parent;
    };
    /**
     * 显示
     * @param data 信息
     * @param time 持续时间
     */
    ToastCtrl.prototype.show = function (data, time) {
        var _this = this;
        if (time === void 0) { time = 1500; }
        this._parent.visible = true;
        if (this._current) {
            this._parent.removeChild(this._current);
        }
        else {
        }
        var cls = this._toastClassMap[sceneTypes_1.ModuleTypes.TOAST];
        var Toast = new cls(data);
        Waiting_1.default.instance.hide();
        this._current = Toast;
        Toast.start(data);
        this.add(Toast);
        Toast.visible = false;
        egret.Tween.get(Toast).set({ visible: true, alpha: 0, y: -200 }).to({ alpha: 1, y: 0 }, 500, egret.Ease.cubicIn)
            .wait(time)
            .call(function () {
            _this._parent.visible = false;
        });
        return Toast;
    };
    /**
     * 移除蒙层
     */
    ToastCtrl.prototype.removeMask = function () {
        var _this = this;
        if (this._mask) {
            egret.Tween.get(this._mask).to({ alpha: 0 }, 200).call(function () { return _this._parent.removeChild(_this._mask); }, this);
        }
    };
    /**
     * 立刻移除蒙层
     */
    ToastCtrl.prototype.removeMaskImmediately = function () {
        if (this._mask) {
            this._parent.removeChild(this._mask);
        }
    };
    ToastCtrl.prototype.add = function (panel) {
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
    };
    /**
     * 动画后移除Panel
     * @param panel
     */
    ToastCtrl.prototype.remove = function (panel) {
        var _this = this;
        var tw = egret.Tween.get(panel);
        tw.to({ y: 1624 }, 400, egret.Ease.getBackIn(2))
            .call(function () {
            egret.Tween.removeAllTweens();
            _this._parent.removeChild(panel);
            _this._parent.visible = false;
            _this._current = null;
            _this.removeMask();
        }, this);
    };
    /**
     * 立即移除Panel
     * @param panel
     */
    ToastCtrl.prototype.removeImmediately = function (panel) {
        this._parent.removeChild(panel);
        this._parent.visible = false;
        this._current = null;
        this.removeMaskImmediately();
    };
    /**
     * 隐藏Panel
     * @param e
     */
    ToastCtrl.prototype.onPanelHide = function (e) {
        var panel = e.target;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        this.removeImmediately(panel);
    };
    /**
     * 注册Panel
     * @param name Panel名字
     * @param definition 定义
     */
    ToastCtrl.prototype.registerClass = function (name, definition) {
        if (name === void 0) { name = sceneTypes_1.ModuleTypes.TOAST; }
        if (definition === void 0) { definition = Toast_1.default; }
        this._toastClassMap = this._toastClassMap || {};
        this._toastClassMap[name] = definition;
    };
    /**
     * 关闭当前 有动画
     */
    ToastCtrl.prototype.closeCurrent = function () {
        if (this._current)
            this.remove(this._current);
    };
    /**
     * 关闭当前 无动画
     */
    ToastCtrl.prototype.closeCurrentImmediately = function () {
        if (this._current)
            this.removeImmediately(this._current);
    };
    return ToastCtrl;
}());
exports.default = ToastCtrl;
__reflect(ToastCtrl.prototype, "\"e:/zqty/egret/src/ctrls/toastCtrl\".ToastCtrl");
//# sourceMappingURL=toastCtrl.js.map