"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Waiting_1 = require("../waiting/Waiting");
var PanelCtrl = (function () {
    function PanelCtrl() {
    }
    Object.defineProperty(PanelCtrl, "instance", {
        /**
         * 实例
         */
        get: function () {
            return PanelCtrl._instance || (PanelCtrl._instance = new PanelCtrl());
        },
        enumerable: true,
        configurable: true
    });
    /**
     * 初始化
     * @param parent 赋值父级
     */
    PanelCtrl.prototype.init = function (parent) {
        this._parent = parent;
    };
    /**
     * 显示
     * @param type 类型
     * @param data 数据
     */
    PanelCtrl.prototype.show = function (type, data, afterAni) {
        this._parent.visible = true;
        if (this._current) {
            this._parent.removeChild(this._current);
        }
        else {
        }
        this.addMask();
        var cls = this._panelClassMap[type];
        var panel = new cls(data);
        Waiting_1.default.instance.hide();
        this._current = panel;
        panel.start(data);
        this.add(panel);
        panel.visible = false;
        egret.Tween.get(panel).set({ visible: true, alpha: 0, y: -200 }).to({ alpha: 1, y: 0 }, 500, egret.Ease.cubicIn).call(function () {
            afterAni && afterAni(panel);
        });
        return panel;
    };
    /**
     * 加入黑色蒙层
     */
    PanelCtrl.prototype.addMask = function () {
        if (!this._mask) {
            this._mask = new egret.Sprite();
            this._mask.touchEnabled = true;
            this._mask.graphics.beginFill(0, .7);
            this._mask.graphics.drawRect(0, 0, 750, 1624);
            this._mask.graphics.endFill();
        }
        this._mask.alpha = 1;
        this._parent.addChild(this._mask);
    };
    /**
     * 移除蒙层
     */
    PanelCtrl.prototype.removeMask = function () {
        var _this = this;
        if (this._mask) {
            egret.Tween.get(this._mask).to({ alpha: 0 }, 200).call(function () { return _this._parent.removeChild(_this._mask); }, this);
        }
    };
    /**
     * 立刻移除蒙层
     */
    PanelCtrl.prototype.removeMaskImmediately = function () {
        if (this._mask) {
            this._parent.removeChild(this._mask);
        }
    };
    PanelCtrl.prototype.add = function (panel) {
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
    };
    /**
     * 动画后移除Panel
     * @param panel
     */
    PanelCtrl.prototype.remove = function (panel) {
        var _this = this;
        var tw = egret.Tween.get(panel);
        tw.to({ y: 1624 }, 400, egret.Ease.getBackIn(2))
            .call(function () {
            egret.Tween.removeAllTweens();
            _this._parent.removeChild(panel);
            _this._parent.visible = false;
            _this._current = null;
            _this.removeMask();
        }, this);
    };
    /**
     * 立即移除Panel
     * @param panel
     */
    PanelCtrl.prototype.removeImmediately = function (panel) {
        this._parent.removeChild(panel);
        this._parent.visible = false;
        this._current = null;
        this.removeMaskImmediately();
    };
    /**
     * 隐藏Panel
     * @param e
     */
    PanelCtrl.prototype.onPanelHide = function (e) {
        var panel = e.target;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        this.removeImmediately(panel);
    };
    /**
     * 注册Panel
     * @param name Panel名字
     * @param definition 定义
     */
    PanelCtrl.prototype.registerClass = function (name, definition) {
        this._panelClassMap = this._panelClassMap || {};
        this._panelClassMap[name] = definition;
    };
    /**
     * 关闭当前 有动画
     */
    PanelCtrl.prototype.closeCurrent = function () {
        if (this._current)
            this.remove(this._current);
    };
    /**
     * 关闭当前 无动画
     */
    PanelCtrl.prototype.closeCurrentImmediately = function () {
        if (this._current)
            this.removeImmediately(this._current);
    };
    return PanelCtrl;
}());
exports.default = PanelCtrl;
__reflect(PanelCtrl.prototype, "\"e:/zqty/egret/src/ctrls/panelCtrl\".PanelCtrl");
//# sourceMappingURL=panelCtrl.js.map