"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var SheetAnimation = (function (_super) {
    __extends(SheetAnimation, _super);
    function SheetAnimation() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._fps = 24;
        _this._fpscounter = 1;
        return _this;
    }
    SheetAnimation.prototype.onEnterFrame = function () {
        if (this._fpscounter == 1) {
            var key = '0' + this._counter;
            if (this._counter >= 10)
                key = this._counter + '';
            var picData = this._sheet.getTexture(key);
            this.$setBitmapData(picData);
            this.dispatchEvent(new egret.Event('frameUpdate', false, false, this._counter));
            this._counter++;
            if (this._counter > this.totalFrames)
                this._counter = 1;
        }
        this._fpscounter++;
        if (this._fpscounter > Math.ceil(60 / this._fps))
            this._fpscounter = 1;
    };
    Object.defineProperty(SheetAnimation.prototype, "sheet", {
        get: function () { return this._sheet; },
        set: function (val) {
            this._sheet = val;
            this.stopAtFirstFrame();
            this.totalFrames = this.getTotalFrames() - 1;
        },
        enumerable: true,
        configurable: true
    });
    SheetAnimation.prototype.getTotalFrames = function () {
        var counter = 0;
        for (var key in this._sheet._textureMap) {
            counter++;
        }
        return counter;
    };
    SheetAnimation.prototype.stopAtFirstFrame = function () {
        var picData = this._sheet.getTexture('01');
        this.$setBitmapData(picData);
        this.stop();
    };
    SheetAnimation.prototype.stopAtIdleFrame = function () {
        var picData = this._sheet.getTexture('00');
        this.$setBitmapData(picData);
        this.stop();
    };
    Object.defineProperty(SheetAnimation.prototype, "fps", {
        set: function (val) {
            this._fps = val;
        },
        enumerable: true,
        configurable: true
    });
    SheetAnimation.prototype.play = function () {
        this._fpscounter = 1;
        this._counter = 1;
        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    };
    SheetAnimation.prototype.stop = function () {
        this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
    };
    SheetAnimation.prototype.destroy = function () {
        this.stop();
        this._sheet = null;
    };
    return SheetAnimation;
}(egret.Bitmap));
exports.default = SheetAnimation;
__reflect(SheetAnimation.prototype, "\"e:/zqty/egret/src/components/SheetAnimation\".SheetAnimation");
//# sourceMappingURL=SheetAnimation.js.map