"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var NetManager_1 = require("./../libs/tw/manager/NetManager");
var DataManager_1 = require("./../libs/tw/manager/DataManager");
/**
 * 接口常量
 *
 * 普通游戏接口
 * hdtool/recon/ajaxElement
 * hdtool/recon/doJoin
 * hdtool/recon/ngame/getNgameStartStatus 游戏开始状态
 * hdtool/recon/ngame/ngameSubmit
 * hdtool/recon/getOrderStatus
 *
 * 游戏支持复活 调用接口说明
 * hdtool/recon/ajaxElement
 * hdtool/recon/doJoin
 * hdtool/recon/ngame/getNgameStartStatus 游戏开始状态
 * hdtool/recon/ngame/resurrectionStatus 复活状态 参数dojion中orderId
 *
 * 复活流程
 * hdtool/recon/ngame/resurrection 游戏复活接口 参数dojion中orderId 返回 复活id
 * hdtool/recon/ngame/resurrectionStatus 复活状态 参数dojion中orderId，复活id 返回 复活状态 剩余复活次数 下一次复活所需积分（轮询）
 *
 * 多次领奖流程
 * hdtool/recon/ngame/ngameManySubmit 游戏多次发奖接口 参数dojion中orderId 返回多次领奖orderId
 * hdtool/recon/getOrderStatus 参数多次领奖返回的orderId
 */
var NetConst = (function () {
    function NetConst() {
    }
    NetConst.ajaxElement = function (callback) {
        var net = {
            name: 'gameAjaxElement',
            uri: '/hdtool/recon/ajaxElement',
            type: 'get',
            dataType: 'json',
            param: {
                duibaId: DataManager_1.DataManager.ins.customCfgData.hdToolId,
                activityId: DataManager_1.DataManager.ins.customCfgData.actId
            },
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /**
     * 获取排行榜列表
     * @param callback 回调
     * @param rankId 排行榜id
     * @param hdtoolId 活动工具id
     */
    NetConst.getRankList = function (callback, rankId, hdtoolId) {
        var param = {
            rankId: rankId,
            hdtoolId: hdtoolId
        };
        var net = {
            name: 'rankList',
            uri: '/hdtool/rank/rankList',
            type: 'get',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /**
     * 获取排行榜列表
     * @param callback 回调
     * @param rankId 排行榜id
     * @param activityId cfg oaid
     * @param needPreviousPeriod 是否需要上期排行榜数据
     * @param pageNo
     * @param pageSize
     */
    NetConst.recentRankList = function (callback, rankId, activityId, needPreviousPeriod, pageNo, pageSize) {
        if (needPreviousPeriod === void 0) { needPreviousPeriod = false; }
        if (pageNo === void 0) { pageNo = 0; }
        if (pageSize === void 0) { pageSize = 50; }
        var param = {
            rankId: rankId,
            activityId: activityId,
            needPreviousPeriod: needPreviousPeriod,
            pageNo: pageNo,
            pageSize: pageSize
        };
        var net = {
            name: 'recentRankList',
            uri: '/hdtool/rank/recentRankListNew',
            type: 'get',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /**
     * 参与游戏
     * @param callback 回调
     * @param credits 积分
     * @param collectRuleId 集卡规则id？
     */
    NetConst.doJoin = function (callback, activityId, credits, collectRuleId) {
        if (activityId === void 0) { activityId = DataManager_1.DataManager.ins.customCfgData.actId; }
        var param = {
            activityId: activityId,
            activityType: 'hdtool',
            consumerId: DataManager_1.DataManager.ins.customCfgData.consumerId
        };
        if (credits) {
            param.credits = credits;
        }
        if (collectRuleId) {
            param.collectRuleId = collectRuleId;
        }
        var net = {
            name: 'doJoin',
            uri: '/hdtool/recon/doJoin',
            type: 'post',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback
        };
        NetManager_1.NetManager.ins.getToken(net);
    };
    /**
     * 轮询开始状态
     * @param callback 回调
     * @param orderId 订单id
     */
    NetConst.getNgameStartStatus = function (callback, orderId, pollingCheck, pollingCount) {
        if (pollingCount === void 0) { pollingCount = 10; }
        var param = {
            orderId: orderId
        };
        var net = {
            name: 'getNgameStartStatus',
            uri: '/hdtool/recon/ngame/getNgameStartStatus',
            type: 'post',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /**
     * 发送得分
     * @param callback 回调
     * @param orderId 订单id
     * @param score 分数
     * @param gameData 游戏数据
     * @param dynamicData 动态数据
     * @param submitToken 提交数据token  由 getNgameStartStatus 返回
     */
    NetConst.ngameSubmit = function (callback, orderId, score, gameData, dynamicData, submitToken, rankId) {
        var sign = NetManager_1.NetManager.ins['createSgin'](orderId, score, gameData, submitToken);
        var param = {
            orderId: orderId,
            score: score,
            gameData: gameData,
            sgin: sign,
            dynamicData: JSON.stringify(dynamicData)
        };
        if (rankId) {
            param.rankId = rankId;
        }
        var net = {
            name: 'ngameSubmit',
            uri: '/hdtool/recon/ngame/ngameSubmit',
            type: 'post',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /**
     * 游戏多次领奖
     * @param callback 回调
     * @param orderId 订单号
     * @param score 分数
     * @param gameData 游戏数据
     * @param dynamicData 动态数据
     * @param submitToken 提交数据token  由 getNgameStartStatus 返回
     * @param rankId 排行id
     */
    NetConst.ngameManySubmit = function (callback, orderId, score, gameData, dynamicData, submitToken, rankId) {
        var sign = NetManager_1.NetManager.ins['createSgin'](orderId, score, gameData, submitToken);
        var param = {
            orderId: orderId,
            score: score,
            gameData: gameData,
            sgin: sign,
            dynamicData: JSON.stringify(dynamicData)
        };
        if (rankId) {
            param.rankId = rankId;
        }
        var net = {
            name: 'ngameManySubmit',
            uri: '/hdtool/recon/ngame/ngameManySubmit',
            type: 'post',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /**
     * 游戏数据校验防作弊
     * @param callback 回调
     * @param orderId 订单id
     * @param dynamicData 动态数据
     * @param duibaId duiba活动id
     */
    NetConst.datapash = function (callback, orderId, dynamicData) {
        var param = {
            orderId: orderId,
            dynamicData: dynamicData,
            duibaId: window['CFG'].hdToolId
        };
        var net = {
            name: 'datapash',
            uri: '/hdtool/recon/ngame/datapash',
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /**
     * 复活接口
     * @param callback 回调
     * @param orderId 订单id
     */
    NetConst.resurrection = function (callback, orderId) {
        var param = {
            orderId: orderId
        };
        var net = {
            name: 'resurrection',
            uri: '/hdtool/recon/ngame/resurrection',
            type: 'post',
            dataType: 'json',
            hideMsg: true,
            param: param,
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /**
     * 轮询复活状态
     * @param callback 回调
     * @param orderId 订单id
     * @param pollingCheck 轮询条件
     * @param pollingCount 轮询次数
     * @param resurrecOrderId 复活订单id
     */
    NetConst.resurrectionStatus = function (callback, orderId, pollingCheck, pollingCount, resurrecOrderId) {
        if (pollingCount === void 0) { pollingCount = 10; }
        if (resurrecOrderId === void 0) { resurrecOrderId = -1; }
        var param = {
            orderId: orderId
        };
        var net = {
            name: 'resurrectionStatus',
            uri: '/hdtool/recon/ngame/resurrectionStatus',
            type: 'post',
            dataType: 'json',
            hideMsg: true,
            param: param,
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        if (resurrecOrderId != -1) {
            net.param.resurrecOrderId = resurrecOrderId;
        }
        NetManager_1.NetManager.ins.send(net);
    };
    /**
     * 轮询订单状态
     * @param callback 回调
     * @param orderId 订单id
     */
    NetConst.getOrderStatus = function (callback, orderId, pollingCheck, pollingCount) {
        if (pollingCount === void 0) { pollingCount = 10; }
        var param = {
            orderId: orderId
        };
        var net = {
            name: 'getOrderStatus',
            uri: '/hdtool/recon/getOrderStatus',
            type: 'post',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        NetManager_1.NetManager.ins.send(net);
    };
    /**
     * 招商银行钓龙虾定制接口
     * @param callback 回调
     * @param activityId 活动id cfg oaid
     * @param score 分数
     * @param shareCode 分享码
     */
    NetConst.shrimpFishingIndex = function (callback, activityId, score, shareCode) {
        var param = {
            activityId: activityId
        };
        if (score) {
            param.score = score;
        }
        if (shareCode) {
            param.shareCode = shareCode;
        }
        var net = {
            name: 'shrimpFishingIndex',
            uri: '/aaw/changshaCmb/shrimpFishing/index',
            type: 'get',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback
        };
        NetManager_1.NetManager.ins.send(net);
    };
    return NetConst;
}());
exports.default = NetConst;
__reflect(NetConst.prototype, "\"e:/zqty/egret/src/NetConst\".NetConst");
//# sourceMappingURL=NetConst.js.map