"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var Buried_1 = require("./../libs/tw/util/Buried");
var GDispatcher_1 = require("./../libs/tc/util/GDispatcher");
var ABNetManager_1 = require("./../libs/tc/manager/ABNetManager");
var MainBase_1 = require("../libs/tl/MainBase");
var panelCtrl_1 = require("./ctrls/panelCtrl");
var sceneCtrl_1 = require("./ctrls/sceneCtrl");
var sceneTypes_1 = require("./types/sceneTypes");
var RulePanel_1 = require("./rulePanel/RulePanel");
var Msg_1 = require("./alert/Msg");
var GameConst_1 = require("./GameConst");
var Waiting_1 = require("./waiting/Waiting");
var NetConst_1 = require("./NetConst");
var StartScene_1 = require("./startScene/StartScene");
var PlayScene_1 = require("./playScene/PlayScene");
var toastCtrl_1 = require("./ctrls/toastCtrl");
// import SVGACtrl from './ctrls/svgaCtrl';
var LoginPanel_1 = require("./login/LoginPanel");
var GetCreditsPanel_1 = require("./getCredits/GetCreditsPanel");
var RankPanel_1 = require("./rankPanel/RankPanel");
var CountDownPanel_1 = require("./countDownPanel/CountDownPanel");
var EndPanel_1 = require("./endPanel/EndPanel");
var Main = (function (_super) {
    __extends(Main, _super);
    function Main() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        // 获取数据
        _this.updateCount = 0;
        return _this;
    }
    Main.prototype.registerModules = function () {
        // 注册Toast
        toastCtrl_1.default.instance.registerClass();
        // 注册所有Panel
        panelCtrl_1.default.instance.registerClass(sceneTypes_1.ModuleTypes.LOGIN_PANEL, LoginPanel_1.default);
        panelCtrl_1.default.instance.registerClass(sceneTypes_1.ModuleTypes.GETCREDITS_PANEL, GetCreditsPanel_1.default);
        panelCtrl_1.default.instance.registerClass(sceneTypes_1.ModuleTypes.MSG_PANEL, Msg_1.default);
        panelCtrl_1.default.instance.registerClass(sceneTypes_1.ModuleTypes.RULE_PANEL, RulePanel_1.default);
        panelCtrl_1.default.instance.registerClass(sceneTypes_1.ModuleTypes.RANK_PANEL, RankPanel_1.default);
        panelCtrl_1.default.instance.registerClass(sceneTypes_1.ModuleTypes.COUNTDOWN_PANEL, CountDownPanel_1.default);
        panelCtrl_1.default.instance.registerClass(sceneTypes_1.ModuleTypes.END_PANEL, EndPanel_1.default);
        // // 注册所有Scene
        sceneCtrl_1.default.instance.registerClass(sceneTypes_1.ModuleTypes.START_SCENE, StartScene_1.default);
        sceneCtrl_1.default.instance.registerClass(sceneTypes_1.ModuleTypes.PLAY_SCENE, PlayScene_1.default);
        // NetManager.ins.onNotSuccess = (msg) => {
        //     showAlertPanel(msg)
        // }
    };
    Main.prototype.getData = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                _super.prototype.getData.call(this);
                return [2 /*return*/];
            });
        });
    };
    // 设置派发事件
    Main.prototype.GDispatchEvent = function () {
        var _this = this;
        GDispatcher_1.GDispatcher.addEvent(ABNetManager_1.ABNetManager.ERROR, function (net, msg) {
            if (msg === void 0) { msg = ''; }
            var msgData = {
                net: net,
                msg: msg,
            };
            panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.MSG_PANEL, msgData);
        }, this);
        // 监听当预加载资源加载完毕
        GDispatcher_1.GDispatcher.addEvent('PreloadLoaded', function () {
            Waiting_1.default.instance.show();
            _this.createGameScene();
            Waiting_1.default.instance.hide();
        }, this);
        // GDispatcher.addEvent('DelayLoaded', () => {
        //     Waiting.instance.hide()
        //     this.createGameScene()
        // }, this);
    };
    Main.prototype.onResourceLoadComplete = function (event) {
        if (event.groupName == "Preload") {
            this.trace("preload组加载完成");
            //this.trace("开始加载Normal资源");
            // this.loadBg("startBg.png");
            GDispatcher_1.GDispatcher.dispatchEvent('PreloadLoaded');
            window['isPreloadLoaded'] = true;
            //     RES.loadGroup("Normal");
            // } else if (event.groupName == "Normal") {
            //     this.trace("Normal组加载完成");
            //     this.trace("开始加载Garbage资源");
            //     GDispatcher.dispatchEvent('NormalLoaded');
            //     RES.loadGroup("Garbage");
            // } else if (event.groupName == "Garbage") {
            //     this.trace("Garbage组加载完成");
            //     this.trace("开始加载Delay资源");
            //     GDispatcher.dispatchEvent('GarbageLoaded');
            //     RES.loadGroup("Delay");
            // } else if (event.groupName == "Delay") {
            //     this.trace("Delay组加载完成");
            //     GDispatcher.dispatchEvent('DelayLoaded');
            RES.removeEventListener(RES.ResourceEvent.GROUP_COMPLETE, this.onResourceLoadComplete, this);
            RES.removeEventListener(RES.ResourceEvent.GROUP_LOAD_ERROR, this.onResourceLoadError, this);
            RES.removeEventListener(RES.ResourceEvent.GROUP_PROGRESS, this.onResourceProgress, this);
        }
    };
    // 创建游戏场景
    Main.prototype.createGameScene = function () {
        _super.prototype.createGameScene.call(this);
        //获取UA信息
        var userAgent = navigator.userAgent.toLowerCase();
        console.log(userAgent);
        GameConst_1.default.stage = this.stage;
        setTimeout(function () {
            console.log(GameConst_1.default.stage.width, GameConst_1.default.stage.height);
        }, 100);
        Buried_1.Buried.init();
        // 端内发接口
        NetConst_1.default.ajaxElement(function (s) {
            if (s) {
                sceneCtrl_1.default.instance.change(sceneTypes_1.ModuleTypes.START_SCENE);
            }
            else {
                var msgData = { msg: '网络开了会儿小差，请稍后再试~', type: 'tips' };
                panelCtrl_1.default.instance.show(sceneTypes_1.ModuleTypes.MSG_PANEL, msgData);
            }
        });
    };
    /**
     * 资源组加载出错
     */
    Main.prototype.onResourceLoadError = function (event) {
        this.trace("preload组加载失败");
        //忽略加载失败的项目
        this.onResourceLoadComplete(event);
    };
    Main.prototype.isIOS = function () {
        var u = navigator.userAgent;
        var isiOS = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/);
        return isiOS;
    };
    return Main;
}(MainBase_1.default));
__reflect(Main.prototype, "Main");
window['Main'] = Main;
egret.ImageLoader.crossOrigin = "anonymous";
egret.runEgret({
    renderMode: "webgl", audioType: 0, calculateCanvasScaleFactor: function (context) {
        var backingStore = context.backingStorePixelRatio ||
            context.webkitBackingStorePixelRatio ||
            context.mozBackingStorePixelRatio ||
            context.msBackingStorePixelRatio ||
            context.oBackingStorePixelRatio ||
            context.backingStorePixelRatio || 1;
        return (window.devicePixelRatio || 1) / backingStore;
    }
});
//# sourceMappingURL=Main.js.map