"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
// import { IShareData } from "..";
var Share = (function () {
    function Share() {
    }
    /**
     * 分享
     */
    Share.doShare = function (sd) {
        switch (sd.appName) {
            case '360手机卫士':
                //360手机卫士
                this.sjws360(sd);
                break;
            case '360清理大师':
                //360清理大师
                this.clean360(sd);
                break;
            case '腾讯视频':
                //腾讯视频
                break;
            case '百度宝宝':
                //百度宝宝
                this.baiduBB(sd);
                break;
            case 'QQ阅读':
                //QQ阅读
                this.qqRead(sd);
                break;
            case 'QQ浏览器':
                //QQ浏览器
                this.qqBrowser(sd);
                break;
            case '饿了么':
                //饿了么
                this.elm(sd);
                break;
            case '书旗小说':
                //书旗小说
                this.bookChess(sd);
                break;
            case '优酷视频':
                //优酷视频
                this.youku(sd);
                break;
        }
    };
    /**
     * 360手机卫士分享
     * @param {IShareData} sd
     */
    Share.sjws360 = function (sd) {
        if (navigator.userAgent.match(/iphone|ipod|ipad/gi)) {
            window['SESDK']['share']({
                contexts: [{
                        type: 'weibo',
                        text: sd.desc,
                        url: sd.link,
                        img: sd.imgUrl
                    },
                    {
                        type: 'wechat.friend.link',
                        title: sd.title,
                        desc: sd.desc,
                        thumb: sd.imgUrl,
                        url: sd.link
                    },
                    {
                        type: 'wechat.timeline.link',
                        title: sd.title,
                        thumb: sd.imgUrl,
                        url: sd.link
                    }]
            });
        }
        else {
            window['MobileSafeJsInterface']['share'](JSON.stringify({
                weixin: {
                    title: sd.title,
                    desc: sd.desc,
                    link: sd.link,
                    type: "0",
                    img_url: sd.imgUrl
                },
                weibo: {
                    desc: sd.desc,
                    type: "0",
                    img_url: sd.imgUrl //微博分享的长图
                }
            }));
        }
    };
    /**
     * 360清理大师分享
     * @param {IShareData} sd
     */
    Share.clean360 = function (sd) {
        //分享前需要先初始化分享图片
        window['android']['prepareShare'](JSON.stringify({ "iconUrl": sd.imgUrl }));
        //调起分享面板
        window['android']['share'](JSON.stringify({
            content: sd.desc,
            weiboContent: sd.desc,
            weixinContent: sd.desc,
            weixinTitle: sd.title,
            shareUrl: sd.link
        }));
    };
    /**
     * 腾讯视频分享
     * @param {ShareData} sd
     */
    Share.txTv = function (sd) {
    };
    /**
     * 百度宝宝分享
     * @param {ShareData} sd
     */
    Share.baiduBB = function (sd) {
        //自定义右上角分享
        window['hybridApi']['exec']('setShare', { title: sd.title, text: sd.desc, url: sd.link, image: sd.imgUrl });
        //调起分享面板
        window['hybridApi']['exec']('share', { title: sd.title, text: sd.desc, url: sd.link, image: sd.imgUrl });
    };
    /**
     * QQ阅读分享
     * @param {ShareData} sd
     */
    Share.qqRead = function (sd) {
        // 1.调起分享页面
        window["Local"].shareTopic(sd.link, sd.imgUrl, sd.title, sd.desc);
        // 2.右上角“...”分享添加
        window['Local'].setIconForShareing(sd.link, sd.imgUrl, sd.title, sd.desc);
    };
    /**
     * QQ浏览器分享
     * @param {ShareData} sd
     */
    Share.qqBrowser = function (sd) {
        var options = {
            url: sd.link,
            title: sd.title,
            description: sd.desc,
            img_url: sd.imgUrl
        };
        window["share"](options, null);
    };
    /**
     * 汽车报价大全
     * @param {ShareData} sd
     */
    Share.carPrice = function (sd) {
    };
    /**
     * 饿了么分享
     * @param {ShareData} sd
     */
    Share.elm = function (sd) {
        window['hybridAPI']['sharePanel']({
            source: 'stage',
            targets: ['weixin', 'weixin_timeline', 'weibo', 'qq', 'qzone'],
            title: sd.title,
            text: sd.desc,
            url: sd.link,
            image_url: sd.imgUrl,
            image_only: true,
        });
    };
    /**
     * 书旗小说分享
     * @param {ShareData} sd
     */
    Share.bookChess = function (sd) {
        var data = {
            shareUrl: sd.link,
            shareTitle: sd.title,
            shareContent: sd.desc
        };
        window['anShuqiForSqWebJS']['openAppSendShareData'](JSON.stringify(data));
    };
    /**
     * 书旗小说分享
     * @param {ShareData} sd
     */
    Share.youku = function (sd) {
        window['']['setShare']({
            title: sd.title,
            link: sd.link,
            img: sd.imgUrl,
            img_only: false
        });
    };
    return Share;
}());
exports.Share = Share;
__reflect(Share.prototype, "\"e:/zqty/egret/libs/tw/util/Share\".Share");
//# sourceMappingURL=Share.js.map