"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
var GameModel_1 = require("../common/GameModel");
var DataManager_1 = require("./../../manager/DataManager");
var TwLang_1 = require("../../util/TwLang");
var GFun_1 = require("../../../tc/util/GFun");
// import { GFun } from '../../../tc/util/GFun';
// import { IExposureData } from '../../data/common/IExposureData';
var GameWinModel = (function (_super) {
    __extends(GameWinModel, _super);
    function GameWinModel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(GameWinModel.prototype, "costTxt", {
        /**
         * 剩余次数文案
         */
        get: function () {
            return DataManager_1.DataManager.ins.getInfoData.status.text;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * 排名文案
     * @param str
     */
    GameWinModel.prototype.getRankTxt = function (str) {
        if (str === void 0) { str = TwLang_1.TwLang.lang_018; }
        return GFun_1.GFun.replace(str, [DataManager_1.DataManager.ins.getInfoData.rank]);
    };
    /**
     * 排名百分比
     * @param str
     */
    GameWinModel.prototype.getPercentageTxt = function (str) {
        if (str === void 0) { str = TwLang_1.TwLang.lang_017; }
        return GFun_1.GFun.replace(str, [DataManager_1.DataManager.ins.getInfoData.percentage]);
    };
    /**
     * 当前得分文案
     * @param str
     */
    GameWinModel.prototype.getCurrScoreTxt = function (str) {
        if (str === void 0) { str = TwLang_1.TwLang.lang_009; }
        return GFun_1.GFun.replace(str, [DataManager_1.DataManager.ins.gameGetSubmitResultData.score]);
    };
    /**
     * 获取最高积分
     * @param maxStr
     * @param totalStr
     */
    GameWinModel.prototype.getMaxScoreTxt = function (maxStr, totalStr) {
        if (maxStr === void 0) { maxStr = TwLang_1.TwLang.lang_010; }
        if (totalStr === void 0) { totalStr = TwLang_1.TwLang.lang_011; }
        var str;
        if (DataManager_1.DataManager.ins.gameCfgData.gameInfo.openTotalScoreSwitch) {
            str = GFun_1.GFun.replace(totalStr, [DataManager_1.DataManager.ins.getInfoData.totalScore]);
        }
        else {
            str = GFun_1.GFun.replace(maxStr, [DataManager_1.DataManager.ins.getInfoData.maxScore]);
        }
        return str;
    };
    Object.defineProperty(GameWinModel.prototype, "lottery", {
        /**
         * 奖品数据
         */
        get: function () {
            return DataManager_1.DataManager.ins.gameGetSubmitResultData.lottery;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GameWinModel.prototype, "exposure", {
        /**
         * 埋点数据
         */
        get: function () {
            return DataManager_1.DataManager.ins.gameGetSubmitResultData.exposure;
        },
        enumerable: true,
        configurable: true
    });
    return GameWinModel;
}(GameModel_1.GameModel));
exports.GameWinModel = GameWinModel;
__reflect(GameWinModel.prototype, "\"e:/zqty/egret/libs/tw/model/game/GameWinModel\".GameWinModel");
//# sourceMappingURL=GameWinModel.js.map