"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
var __extends = this && this.__extends || function __extends(t, e) { 
 function r() { 
 this.constructor = t;
}
for (var i in e) e.hasOwnProperty(i) && (t[i] = e[i]);
r.prototype = e.prototype, t.prototype = new r();
};
Object.defineProperty(exports, "__esModule", { value: true });
// import { ABNetManager, GTime, INetData, GDispatcher } from "duiba-tc";
var TwLang_1 = require("../util/TwLang");
var DataManager_1 = require("./DataManager");
var NetName_1 = require("../enum/NetName");
var ABNetManager_1 = require("../../tc/manager/ABNetManager");
var GTime_1 = require("../../tc/util/GTime");
var GDispatcher_1 = require("../../tc/util/GDispatcher");
// import { IExposureData } from '..';
var NetManager = (function (_super) {
    __extends(NetManager, _super);
    function NetManager() {
        var _this = _super.call(this) || this;
        if (_this.isInit) {
            throw Error(TwLang_1.TwLang.lang_001);
        }
        _this.isInit = true;
        return _this;
    }
    Object.defineProperty(NetManager, "ins", {
        get: function () {
            if (!this.instance) {
                this.instance = new NetManager();
            }
            return this.instance;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * 获取用户角色信息
     * @param {number} roleActivityId 角色id
     * @param {number} type 类型
     */
    NetManager.prototype.getRole = function (callback, roleActivityId, type) {
        if (type === void 0) { type = 1; }
        var net = {
            name: NetName_1.NetName.GET_ROLE,
            uri: '/activityCommon/getRole',
            type: 'get',
            dataType: 'json',
            param: {
                id: roleActivityId,
                type: type
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 活动设置用户角色信息
     * @param {number} actId  活动id
     * @param {number} type 活动类型 0:插件活动; 1:入库活动
     * @param {string} role 角色信息，不能超过32个字符
     */
    NetManager.prototype.setRole = function (callback, actId, type, role) {
        var net = {
            name: NetName_1.NetName.SET_ROLE,
            uri: '/activityCommon/setRole',
            type: 'post',
            dataType: 'json',
            param: {
                id: actId,
                type: type,
                role: role
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 查询用户现在的剩余积分
     */
    NetManager.prototype.getCredits = function (callback) {
        var net = {
            name: NetName_1.NetName.GET_CREDITS,
            uri: '/ctool/getCredits',
            type: 'get',
            dataType: 'json',
            param: null,
            callback: callback
        };
        this.send(net);
    };
    /**
     * 增加活动免费次数
     * @param {number} type 1游戏、2活动工具
     * @param {number} count 次数
     * @param {number} validType 如果不传该参数，代表增加的次数是该用户可以永久使用的次数；如果传该参数，代表增加的次数是仅当天可用的，该参数值只能是1
     */
    NetManager.prototype.addTimesForActivity = function (callback, type, count, validType) {
        var activityId;
        if (type == 1) {
            activityId = DataManager_1.DataManager.ins.gameCfgData.gameInfo.oaId;
        }
        else {
            activityId = DataManager_1.DataManager.ins.customCfgData.oaId;
        }
        var param = {
            timestamp: GTime_1.GTime.getTimestamp(),
            addCount: count,
            activityId: activityId
        };
        if (validType) {
            param.validType = validType;
        }
        var net = {
            name: NetName_1.NetName.ADD_TIMES,
            uri: '/activityVist/addTimesForActivity',
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback
        };
        this.send(net);
    };
    /**
     * 获取集卡数据
     * @param {number} collectRuleId 集卡规则ID
     */
    NetManager.prototype.getCollectRule = function (callback, collectRuleId) {
        var net = {
            name: NetName_1.NetName.COLLECT_RULE,
            uri: '/collectRule/getCollectRule',
            type: 'get',
            dataType: 'json',
            param: {
                collectRuleId: collectRuleId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 集卡开奖
     * @param {number} collectRuleId 集卡规则ID
     * @param {number} type 1游戏、2活动工具、其他类型可以不传，发接口actid也不用传
     */
    NetManager.prototype.openCollectGoodsPrize = function (callback, collectRuleId, type) {
        var actId;
        var param;
        if (type == 1) {
            actId = DataManager_1.DataManager.ins.gameCfgData.gameInfo.oaId;
        }
        else if (type == 2) {
            actId = DataManager_1.DataManager.ins.customCfgData.oaId;
        }
        if (type) {
            param = { collectRuleId: collectRuleId, actId: actId };
        }
        else {
            param = { collectRuleId: collectRuleId };
        }
        var net = {
            name: NetName_1.NetName.OPEN_COLLECT,
            uri: '/collectRule/openCollectGoodsPrize',
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback
        };
        this.send(net);
    };
    //--------------------------------------------游戏-----------------------------------------
    /**
     * 游戏基础信息
     */
    NetManager.prototype.getInfo = function (callback) {
        var net = {
            name: NetName_1.NetName.GAME_INFO,
            uri: '/ngame/new/getInfo',
            type: 'get',
            dataType: 'json',
            param: {
                id: DataManager_1.DataManager.ins.gameCfgData.gameInfo.gameId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 夏日活动游戏基础信息
     */
    NetManager.prototype.getSummerInfo = function (callback, rankBaseConfigId) {
        var net = {
            name: NetName_1.NetName.GAME_SUMMERINFO,
            uri: '/summer/getUserActivityInfo',
            type: 'get',
            dataType: 'json',
            param: {
                rankBaseConfigId: rankBaseConfigId,
                isMainActivity: false
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     *  购买鱼钩鱼线道具
     * @param callback
     * @param operatingActivityId 活动oaid
     * @param type 道具类型 0：鱼线 1：鱼钩
     */
    NetManager.prototype.summerBuyProp = function (callback, operatingActivityId, type) {
        var net = {
            name: NetName_1.NetName.GAME_SUMMER_BUYPROP,
            uri: '/summer/buyProp',
            type: 'post',
            dataType: 'json',
            param: {
                operatingActivityId: operatingActivityId,
                type: type
            },
            callback: callback, hideMsg: true
        };
        this.send(net);
    };
    /**
     * 获取鱼钩鱼线数量
     * @param callback
     */
    NetManager.prototype.summerGetToyInfo = function (operatingActivityId, callback) {
        var net = {
            name: NetName_1.NetName.GAME_SUMMER_GET_TOY_INFO,
            uri: '/summer/getToyInfo',
            type: 'get',
            dataType: 'json',
            param: { operatingActivityId: operatingActivityId },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 开始游戏
     * @param {string} isAgain 是否是再来一次
     * @param {number} credits 主动要求花费多少积分玩游戏
     * @param {number} customizedType xx类型
     */
    NetManager.prototype.doStart = function (callback, isAgain, credits, customizedType) {
        var addUrl = '';
        if (isAgain) {
            if (DataManager_1.DataManager.ins.gameGetSubmitResultData && DataManager_1.DataManager.ins.gameGetSubmitResultData.againExposure && DataManager_1.DataManager.ins.gameGetSubmitResultData.againExposure.dpm) {
                addUrl += '?dpm=' + DataManager_1.DataManager.ins.gameGetSubmitResultData.againExposure.dpm;
            }
        }
        var param = {
            id: DataManager_1.DataManager.ins.gameCfgData.gameInfo.gameId,
            oaId: DataManager_1.DataManager.ins.gameCfgData.gameInfo.oaId
        };
        if (credits) {
            param.credits = credits;
        }
        if (customizedType) {
            param.customizedType = customizedType;
        }
        var net = {
            name: NetName_1.NetName.GAME_START,
            uri: '/ngapi/dostart',
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback,
            addUrl: addUrl
        };
        this.getToken(net);
    };
    /**
     * 查询开始游戏状态
     * @param {number} ticketId 订单ID
     * @param {Function} pollingCheck 轮询条件 返回true继续轮询
     * @param {number} pollingCount 最大轮询次数
     * @param {number} customizedType
     */
    NetManager.prototype.getStartStatus = function (callback, ticketId, pollingCheck, pollingCount, customizedType) {
        if (pollingCount === void 0) { pollingCount = 5; }
        var param = {
            ticketId: ticketId
        };
        if (customizedType) {
            param.customizedType = customizedType;
        }
        var net = {
            name: NetName_1.NetName.GAME_START_STATUS,
            uri: '/ngapi/getStartStatus',
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback,
            hideMsg: true,
            pollingCount: pollingCount,
            pollingCheck: pollingCheck
        };
        this.send(net);
    };
    NetManager.prototype.getSummerOrderStatus = function (callback, orderNum, pollingCheck, pollingCount, customizedType) {
        if (pollingCount === void 0) { pollingCount = 5; }
        var param = {
            orderNum: orderNum
        };
        var net = {
            name: NetName_1.NetName.GAME_SUMMER_GET_ORDER_STATUS,
            uri: '/summer/getOrderStatus',
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback,
            pollingCount: pollingCount,
            pollingCheck: pollingCheck
        };
        this.send(net);
    };
    /**
     * 复活
     */
    NetManager.prototype.doRevive = function (callback, collectRuleId, itemId) {
        var net = {
            name: NetName_1.NetName.GAME_REVIVE,
            uri: '/summer/doRevive',
            type: 'post',
            dataType: 'json',
            param: {
                collectRuleId: collectRuleId,
                itemId: itemId
            },
            callback: callback,
        };
        this.getToken(net);
    };
    /**
     * 获得复活卡数量
     */
    NetManager.prototype.getReviveCardNum = function (callback, collectRuleId, itemId) {
        var net = {
            name: NetName_1.NetName.GAME_REVIVE_STATUS,
            uri: '/summer/getReviveCardNum',
            type: 'post',
            dataType: 'json',
            param: {
                collectRuleId: collectRuleId,
                itemId: itemId
            },
            callback: callback,
        };
        this.getToken(net);
    };
    /**
     * 猜扑克
     * @param {number} pluginId 插件ID
     * @param {number} ticketId 订单ID
     * @param {number} prizeId 集卡规则ID
     * @param {number} betting 下注方式 0:大 1:小 2:红 3:黑
     */
    NetManager.prototype.guessPoker = function (callback, plugId, ticketId, prizeId, betting) {
        var net = {
            name: NetName_1.NetName.GAME_GUESS_POKER,
            uri: '/ngapi/guessPoker',
            type: 'post',
            dataType: 'json',
            param: {
                pluginId: plugId,
                ticketId: ticketId,
                prizeId: prizeId,
                betting: betting
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 游戏阶段性数据提交
     * @param ticketId
     * @param dynamicData 阶段性交互数据
     */
    NetManager.prototype.datapash = function (callback, ticketId, dynamicData) {
        var net = {
            name: NetName_1.NetName.GAME_DATA_PASH,
            uri: '/ngame/new/datapash',
            type: 'post',
            dataType: 'json',
            param: {
                ticketId: ticketId,
                gameId: DataManager_1.DataManager.ins.gameCfgData.gameInfo.id,
                dynamicData: dynamicData
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 提交游戏数据
     *
     * @param {number} ticketId 订单ID
     * @param {number} score 分数
     * @param {any} gameData 防作弊信息
     * @param {string} submitToken
     * @param {string} dynamicData 行为数据
     * @param {boolean} checkScore 是否校验分数
     * @param {number} customizedType
     */
    NetManager.prototype.gameSubmit = function (callback, ticketId, score, gameData, submitToken, dynamicData, checkScore, customizedType) {
        var sign = this.createSgin(ticketId, score, gameData, submitToken);
        var param = {
            ticketId: ticketId,
            score: score,
            gameData: gameData,
            sgin: sign,
            dynamicData: dynamicData
        };
        if (checkScore) {
            param.checkScore = checkScore;
        }
        if (customizedType) {
            param.customizedType = customizedType;
        }
        var net = {
            name: NetName_1.NetName.GAME_SUBMIT,
            uri: '/ngame/new/submit',
            type: 'post',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback
        };
        this.send(net);
    };
    /**
     * 生成签名
     * @param {number} ticketId
     * @param {number} score
     * @param {any} gameData
     * @param {string} submitToken
     * @returns {string} 签名
     */
    NetManager.prototype.createSgin = function (ticketId, score, gameData, submitToken) {
        return window['duiba_md5'](ticketId + '' + score + '' + gameData + '' + submitToken);
    };
    /**
     * 游戏结束获取奖品数据
     * @param {number} orderId 订单ID
     * @param {Function} pollingCheck 轮询条件 返回true继续轮询
     * @param {number} 最大轮询次数
     */
    NetManager.prototype.getSubmitResult = function (callback, orderId, pollingCheck, pollingCount) {
        if (pollingCount === void 0) { pollingCount = 5; }
        var net = {
            name: NetName_1.NetName.GAME_SUBMIT_STATUS,
            uri: '/ngame/new/getSubmitResult',
            type: 'get',
            dataType: 'json',
            param: {
                orderId: orderId
            },
            hideMsg: true,
            callback: callback,
            pollingCount: pollingCount,
            pollingCheck: pollingCheck
        };
        this.send(net);
    };
    /**
     * 查看中奖名单
     * @param {boolean} showName 是否返回昵称
     */
    NetManager.prototype.winRanks = function (callback, showName) {
        if (showName === void 0) { showName = false; }
        var net = {
            name: NetName_1.NetName.GAME_RANKS,
            uri: '/ngapi/winranks',
            type: 'post',
            dataType: 'json',
            param: {
                id: DataManager_1.DataManager.ins.gameCfgData.gameInfo.gameId,
                showName: showName
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     *  获取奖项
     */
    NetManager.prototype.getOptions = function (callback) {
        var net = {
            name: NetName_1.NetName.GAME_OPTIONS,
            uri: '/ngapi/getOptions',
            type: 'post',
            dataType: 'json',
            param: {
                id: DataManager_1.DataManager.ins.gameCfgData.gameInfo.gameId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     *  获取规则
     */
    NetManager.prototype.getRule = function (callback) {
        var net = {
            name: NetName_1.NetName.GAME_RULE,
            uri: '/ngapi/getRule',
            type: 'post',
            dataType: 'html',
            param: {
                id: DataManager_1.DataManager.ins.gameCfgData.gameInfo.gameId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 实时排行榜
     * @param {number} type 0总排行榜 1今日排行榜 2 多游戏总排行榜 3 昨日排行榜
     * @param {number} count 返回榜单长度 最大50
     */
    NetManager.prototype.realtimerank = function (callback, type, count) {
        if (count === void 0) { count = 50; }
        var net = {
            name: NetName_1.NetName.GAME_REAL_TIME_RANK,
            uri: '/ngapi/realtimerank',
            type: 'get',
            dataType: 'json',
            param: {
                id: DataManager_1.DataManager.ins.gameCfgData.gameInfo.gameId,
                count: count,
            },
            callback: callback,
            addUrl: '/' + type
        };
        this.send(net);
    };
    /**
     * 获取成长值
     * @param {number} gametotalid 游戏中心榜单ID
     */
    NetManager.prototype.getUserTotalScore = function (callback, gametotalid) {
        var net = {
            name: NetName_1.NetName.GAME_TOTAL_SCORE,
            uri: '/ngapi/getUserTotalScore',
            type: 'get',
            dataType: 'json',
            param: {
                id: gametotalid
            },
            callback: callback
        };
        this.send(net);
    };
    //--------------------------------------------插件-----------------------------------------
    /**
     * 插件抽奖
     * @param {number} activityId 插件ID
     */
    NetManager.prototype.doJoinPlugDraw = function (callback, activityId, deductCredits) {
        var net = {
            name: NetName_1.NetName.PLUG_DO_JOIN,
            uri: '/activityPlugDrawInfo/doJoinPlugdraw',
            type: 'post',
            dataType: 'json',
            param: {
                activityId: activityId,
                deductCredits: deductCredits ? deductCredits : false
            },
            hideMsg: true,
            callback: callback
        };
        this.send(net);
    };
    /**
     * 查询插件抽奖订单
     * @param {number} orderId 订单ID
     * @param {number} prizeLevel 开奖等级，暂未开放
     */
    NetManager.prototype.getPlugOrderStatus = function (callback, orderId, pollingCheck, pollingCount, prizeLevel) {
        if (pollingCount === void 0) { pollingCount = 5; }
        var net = {
            name: NetName_1.NetName.PLUG_ORDER_STATUS,
            uri: '/plugin/getOrderStatus',
            type: 'get',
            dataType: 'json',
            param: {
                orderId: orderId
            },
            hideMsg: true,
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        this.send(net);
    };
    /**
     * 查询插件信息
     * @param {string} plugId 插件ID
     */
    NetManager.prototype.getPrizeInfo = function (callback, plugId) {
        var net = {
            name: NetName_1.NetName.PLUG_PRIZE_INFO,
            uri: '/activityPlugDrawInfo/getPrizeInfo',
            type: 'post',
            dataType: 'json',
            param: {
                activityId: plugId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 插件-批量查询奖项信息
     * @param {string} ids 插件ID 用，间隔
     */
    NetManager.prototype.optionInfo = function (callback, ids) {
        var net = {
            name: NetName_1.NetName.PLUG_OPTION_INFO,
            uri: '/activityPlugin/optionInfo',
            type: 'get',
            dataType: 'json',
            param: {
                ids: ids
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 插件校验解锁纪录
     * @param {number} id 插件ID
     */
    NetManager.prototype.unblocking = function (callback, id) {
        var net = {
            name: NetName_1.NetName.PLUG_UNBLOCKING,
            uri: 'activityPlugin/unblocking',
            type: 'post',
            dataType: 'json',
            param: {
                id: id
            },
            callback: callback
        };
        this.send(net);
    };
    //--------------------------------------------自定义活动工具-----------------------------------------
    /**
     * 获取基础信息
     */
    NetManager.prototype.ajaxElement = function (callback) {
        var net = {
            name: NetName_1.NetName.CUSTOM_ELEMENT,
            uri: window['CFG'].getElement,
            type: 'post',
            dataType: 'json',
            param: {
                hdType: DataManager_1.DataManager.ins.customCfgData.hdType,
                hdToolId: DataManager_1.DataManager.ins.customCfgData.hdToolId,
                actId: DataManager_1.DataManager.ins.customCfgData.actId,
                preview: DataManager_1.DataManager.ins.customCfgData.preview
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 查询闯关游戏 配置信息
     * @param {number} throughId
     */
    NetManager.prototype.ajaxThroughInfo = function (callback, throughId) {
        if (throughId === void 0) { throughId = 1; }
        var net = {
            name: NetName_1.NetName.CUSTOM_THROUGH_INFO,
            uri: window['CFG'].ajaxThroughInfo,
            type: 'post',
            dataType: 'json',
            param: {
                hdtoolId: DataManager_1.DataManager.ins.customCfgData.hdToolId,
                throughId: 1
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 活动工具抽奖
     * @param {number} collectRuleId 集卡规则ID，活动与集卡规则关联才能获得发卡资格
     */
    NetManager.prototype.doJoin = function (callback, collectRuleId) {
        var param = {
            actId: DataManager_1.DataManager.ins.customCfgData.actId,
            oaId: DataManager_1.DataManager.ins.customCfgData.oaId
        };
        if (collectRuleId) {
            param.collectRuleId = collectRuleId;
        }
        var net = {
            name: NetName_1.NetName.CUSTOM_THROUGH_INFO,
            uri: window['CFG'].doJoin,
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback
        };
        this.getToken(net);
    };
    /**
     * 活动工具查询订单结果
     * @param orderId
     */
    NetManager.prototype.getCustomOrderStatus = function (callback, orderId, pollingCheck, pollingCount) {
        if (pollingCount === void 0) { pollingCount = 5; }
        var net = {
            name: NetName_1.NetName.CUSTOM_ORDER_STATUS,
            uri: window['CFG'].quireOrder,
            type: 'post',
            dataType: 'json',
            param: {
                orderId: orderId
            },
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        this.send(net);
    };
    /**
     * 获取抽奖前置信息
     * @param {string} orderId 订单ID
     */
    NetManager.prototype.getOrderInfo = function (callback, orderId, showMsg) {
        if (showMsg === void 0) { showMsg = true; }
        var net = {
            name: NetName_1.NetName.CUSTOM_ORDER_INFO,
            uri: window['CFG'].gameGetOrder,
            type: 'post',
            dataType: 'json',
            param: {
                orderId: orderId
            },
            callback: callback,
            hideMsg: true
        };
        this.send(net);
    };
    /**
     * 前置开奖提交
     * @param {string} orderId 订单ID
     * @param {string} facePrice 前置开奖所需分值
     */
    NetManager.prototype.beforSubmit = function (callback, orderId, facePrice) {
        var net = {
            name: NetName_1.NetName.CUSTOM_BEFOR_SUBMIT,
            uri: window['CFG'].gameSubmit,
            type: 'post',
            dataType: 'json',
            param: {
                orderId: orderId,
                facePrice: facePrice
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 答题提交
     */
    NetManager.prototype.questionSubmit = function () {
    };
    /**
     * 闯关游戏提交
     */
    NetManager.prototype.throughSubmit = function (callback, orderId) {
        var net = {
            name: NetName_1.NetName.CUSTOM_THROUGH_SUBMIT,
            uri: window['CFG'].throughSubmit,
            type: 'post',
            dataType: 'json',
            param: {
                orderId: orderId
            },
            callback: callback
        };
        this.send(net);
    };
    //--------------------------------------------养成-----------------------------------------
    /**
     * 宠物领养
     * @param {number} activityId 宠物养成活动ID
     */
    NetManager.prototype.petAdopte = function (callback, activityId) {
        var net = {
            name: NetName_1.NetName.PET_ADOPTE,
            uri: '/signpet/adopte',
            type: 'post',
            dataType: 'json',
            param: {
                activityId: activityId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 宠物状态刷新
     * @param {number} petId 宠物ID
     */
    NetManager.prototype.getPetStatus = function (callback, petId) {
        var net = {
            name: NetName_1.NetName.PET_STATUS,
            uri: '/signpet/status',
            type: 'get',
            dataType: 'json',
            param: {
                petId: petId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 宠物喂食
     * @param {number} petId 宠物ID
     * @param {number} feedNum 喂食数量
     */
    NetManager.prototype.petFeed = function (callback, petId, feedNum) {
        var net = {
            name: NetName_1.NetName.PET_FEED,
            uri: '/signpet/feed',
            type: 'post',
            dataType: 'json',
            param: {
                petId: petId,
                feedNum: feedNum
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 获取宠物信息
     * @param callback
     * @param activityId
     */
    NetManager.prototype.getPetInfo = function (callback, activityId) {
        var net = {
            name: NetName_1.NetName.PET_INFO,
            uri: '/signpet/getPetInfo',
            type: 'get',
            dataType: 'json',
            param: {
                activityId: activityId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 签到信息查询
     * @param {Function} callback
     * @param {number} signActivityId 签到活动ID
     */
    NetManager.prototype.getSignInfo = function (callback, signActivityId) {
        var net = {
            name: NetName_1.NetName.SIGN_INFO,
            uri: '/signactivity/getSignInfo',
            type: 'post',
            dataType: 'json',
            param: {
                signActivityId: signActivityId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 签到接口
     * @param {Function} callback
     * @param {number} signActivityId 签到活动ID
     * @param {number} activityId 插件活动ID，用于加抽奖次数，不传则使用签到身上配置的插件活动ID，否则不加抽奖次数
     */
    NetManager.prototype.doSign = function (callback, signActivityId, activityId) {
        var net = {
            name: NetName_1.NetName.SIGN_DO_SIGN,
            uri: '/signactivity/doSign',
            type: 'post',
            dataType: 'json',
            param: {
                id: signActivityId,
                activityId: activityId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 道具展示接口
     * @param callback
     * @param {number} actId 宠物活动ID
     */
    NetManager.prototype.getToys = function (callback, actId) {
        var net = {
            name: NetName_1.NetName.PET_TOYS,
            uri: '/signpet/addition/getToys',
            type: 'get',
            dataType: 'json',
            param: {
                actId: actId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 道具兑换接口
     * @param callback
     * @param {number} toyId 道具id
     * @param {number} credits 兑换所需积分
     */
    NetManager.prototype.toyExchange = function (callback, toyId, credits) {
        var net = {
            name: NetName_1.NetName.PET_TOY_EXCHANGE,
            uri: '/signpet/addition/toyExchange',
            type: 'post',
            dataType: 'json',
            param: {
                toyId: toyId,
                credits: credits
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 道具使用接口
     * @param callback
     * @param {string} identifier 道具唯一标识
     * @param {number} petId 宠物id
     */
    NetManager.prototype.toyUse = function (callback, identifier, petId) {
        var net = {
            name: NetName_1.NetName.PET_TOY_USE,
            uri: '/signpet/addition/toyUse',
            type: 'post',
            dataType: 'json',
            param: {
                identifier: identifier,
                petId: petId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 收取礼物接口
     * @param callback
     * @param {number} giftId 礼物id
     * @param {string} giftName 礼物名称
     * @param {string} giftDesc 礼物描述
     * @param {number} giftType 礼物类型 1：用户自定义， 2：食物
     * @param {string} giftLink 礼物链接
     * @param {number} petId 宠物id
     */
    NetManager.prototype.collect = function (callback, giftId, giftNum, giftName, giftDesc, giftType, giftLink, petId) {
        var net = {
            name: NetName_1.NetName.PET_COLLECT,
            uri: '/signpet/addition/collect',
            type: 'post',
            dataType: 'json',
            param: {
                giftId: giftId,
                giftNum: giftNum,
                giftName: giftName,
                giftDesc: giftDesc,
                giftType: giftType,
                giftLink: giftLink,
                petId: petId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 群内喂食排行榜
     * @param callback
     * @param {number} petId 宠物id
     * @param {number} topNum 排行榜显示top个数
     */
    NetManager.prototype.getRankList = function (callback, petId, topNum, pollingCheck, pollingCount) {
        var net = {
            name: NetName_1.NetName.PET_GET_RANK_LIST,
            uri: '/signpet/getRankList',
            type: 'get',
            dataType: 'json',
            param: {
                petId: petId,
                topNum: topNum,
                pollingCheck: pollingCheck,
                pollingCount: pollingCount
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 查询待领取粮食
     * @param callback
     */
    NetManager.prototype.getFoodPiles = function (callback) {
        var net = {
            name: NetName_1.NetName.PET_GET_FOOD_PILES,
            uri: '/signpet/getFoodPiles',
            type: 'get',
            dataType: 'json',
            param: {},
            callback: callback
        };
        this.send(net);
    };
    /**
     * 待领取粮食收取
     * @param callback
     * @param {number} id 待领取粮食主键ID
     * @param {number} activityId 活动id
     */
    NetManager.prototype.collectFood = function (callback, id, activityId) {
        var net = {
            name: NetName_1.NetName.PET_COLLECT_FOOD,
            uri: '/signpet/collectFood',
            type: 'post',
            dataType: 'json',
            param: {
                id: id,
                activityId: activityId
            },
            callback: callback
        };
        this.send(net);
    };
    //--------------------------------------------------------------------外来宠物养成--------------------------------------------------------------------------
    /**
     * 活动主信息接口
     * @param callback
     * @param activityId
     */
    NetManager.prototype.getHomeInfo = function (callback, activityId) {
        var net = {
            name: NetName_1.NetName.PETS_GET_HOME_INFO,
            uri: '/sign/wander/getHomeInfo',
            type: 'get',
            dataType: 'json',
            param: {
                activityId: activityId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 商店道具接口
     * @param callback
     * @param actId
     * @param actType 	2-日历 4-养成 5-契约 6-外来宠物
     * @param toyType   1-状态 2-装饰 3-功能 4-食物 5-玩具
     */
    NetManager.prototype.getActToys = function (callback, actId, actType, toyType) {
        var net = {
            name: NetName_1.NetName.PETS_GET_ACT_TOYS,
            uri: '/sign/addition/getActToys',
            type: 'get',
            dataType: 'json',
            param: {
                actId: actId,
                actType: actType,
                toyType: toyType
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 外来宠物养成-道具兑换接口
     * @param callback
     * @param {number} toyId 道具id
     */
    NetManager.prototype.toyExchanges = function (callback, toyId) {
        var net = {
            name: NetName_1.NetName.PETS_TOY_EXCHANGE,
            uri: '/sign/addition/toyExchange',
            type: 'post',
            dataType: 'json',
            param: {
                toyId: toyId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 道具使用接口
     * @param callback
     * @param {number} actId 活动id
     * @param {any[]} toyList 使用的道具列表 [{identifier:'道具标识', position:'投放位置'}, {identifier:'道具标识', position:'投放位置'}]
     */
    NetManager.prototype.useToy = function (callback, actId, toyList) {
        var net = {
            name: NetName_1.NetName.PETS_USE_TOYS,
            uri: '/sign/addition/useToy',
            type: 'post',
            dataType: 'json',
            param: {
                actId: actId,
                toyList: JSON.stringify(toyList)
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 已购买的道具接口
     * @param callback
     * @param petId     宠物id 没有传0
     * @param toyType   1-状态 2-装饰 3-功能 4-食物 5-玩具
     */
    NetManager.prototype.getUserToys = function (callback, petId, toyType) {
        var net = {
            name: NetName_1.NetName.PETS_GET_USER_TOYS,
            uri: '/sign/addition/getUserToys',
            type: 'get',
            dataType: 'json',
            param: {
                petId: petId,
                toyType: toyType
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 粮食收取
     * @param callback
     * @param actId     活动id
     * @param ids       收取粮食堆的主键id列表[1,2,3,4]
     */
    NetManager.prototype.batchollectFood = function (callback, actId, ids) {
        var net = {
            name: NetName_1.NetName.PETS_BATCHOLLECT_FOOD,
            uri: '/sign/addition/batchollectFood',
            type: 'post',
            dataType: 'json',
            param: {
                ids: JSON.stringify(ids),
                actId: actId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 来访统计
     * @param callback
     * @param actId
     */
    NetManager.prototype.visitStatistics = function (callback, actId) {
        var net = {
            name: NetName_1.NetName.PETS_VISI_STATISTICS,
            uri: '/sign/wander/visitStatistics',
            type: 'get',
            dataType: 'json',
            param: {
                actId: actId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 动态信息列表
     * @param callback
     * @param actId         活动id
     * @param showNum       显示条数
     */
    NetManager.prototype.getVisitInfo = function (callback, actId, showNum) {
        var net = {
            name: NetName_1.NetName.PETS_GET_VISIT_INFO,
            uri: '/sign/wander/getVisitInfo',
            type: 'get',
            dataType: 'json',
            param: {
                showNum: showNum,
                actId: actId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 到访记录详情
     * @param callback
     * @param actId ：活动id
     * @param identifier ：宠物唯一标识
     */
    NetManager.prototype.visitDetail = function (callback, actId, identifier) {
        var net = {
            name: NetName_1.NetName.PETS_VISIT_DETAIL,
            uri: '/sign/wander/visitDetail',
            type: 'get',
            dataType: 'json',
            param: {
                actId: actId,
                identifier: identifier
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 礼物收取
     * @param callback
     * @param recordId 礼物记录ID
     */
    NetManager.prototype.collectGiftRecord = function (recordId, callback) {
        var net = {
            name: NetName_1.NetName.PETS_COLLECT_GIFT_RECORD,
            uri: '/sign/wander/collectGiftRecord',
            type: 'post',
            dataType: 'json',
            param: {
                recordId: recordId
            },
            callback: callback
        };
        this.send(net);
    };
    /**
     * 获取token
     * @param net
     */
    NetManager.prototype.getToken = function (net) {
        var _this = this;
        if (window['getDuibaToken']) {
            window['getDuibaToken'](function (tokenObj) {
                net.param.token = tokenObj.token;
                _this.send(net);
            }, function (key, messageObj) {
                _this.onError(net);
            });
        }
        else {
            this.send(net);
        }
    };
    /**
     * 查询我的奖品记录
     * @param callback
     * @param {number} page 当前页数
     */
    NetManager.prototype.getRecord = function (callback, page) {
        var _this = this;
        var net = {
            name: NetName_1.NetName.GET_RECORD,
            uri: (window['recordUrl'] ? window['recordUrl'] : '') + '/Crecord/getRecord',
            type: 'get',
            dataType: 'json',
            param: {
                page: page
            },
            callback: callback
        };
        var gTime = '?_=' + GTime_1.GTime.getTimestamp();
        var realUrl = net.uri;
        if (realUrl.indexOf('?') != -1) {
            gTime = '&_=' + GTime_1.GTime.getTimestamp();
        }
        //url加参数等特殊需求（例如再玩一次需要在dostart接口的url上加埋点）
        if (net.addUrl) {
            realUrl += net.addUrl;
        }
        window['$'].ajax({
            type: net.type,
            // url: realUrl + gTime,
            url: realUrl,
            dataType: net.dataType,
            data: net.param,
            async: true,
            xhrFields: {
                withCredentials: true
            },
            crossDomain: true,
            cache: false,
            success: function (result) {
                _this.onResponse(net, result);
            },
            error: function (message) {
                _this.onError(net);
            }
        });
    };
    /**
     * 推啊曝光埋点(福袋)
     * @param {IExposureData} exposure
     */
    NetManager.prototype.spmshow = function (exposure) {
        var domain = (exposure.domain ? exposure.domain : '') + '/engine/';
        var net = {
            name: 'spmshow',
            uri: domain + 'spmshow',
            type: 'get',
            dataType: 'jsonp',
            param: exposure,
            callback: null,
            hideMsg: true
        };
        this.send(net);
    };
    /**
     * 推啊点击埋点(福袋)
     * @param {IExposureData} exposure
     */
    NetManager.prototype.spmclick = function (exposure) {
        var domain = (exposure.domain ? exposure.domain : '') + '/engine/';
        var net = {
            name: 'spmclick',
            uri: domain + 'spmclick',
            type: 'get',
            dataType: 'jsonp',
            param: exposure,
            callback: null,
            hideMsg: true
        };
        this.send(net);
    };
    /**
     * 兑吧点击埋点
     * @param {IExposureData} exposure
     */
    NetManager.prototype.clickLog = function (exposure) {
        var net = {
            name: 'clickLog',
            uri: '/log/click',
            type: 'get',
            dataType: 'jsonp',
            param: exposure,
            callback: null,
            hideMsg: true
        };
        this.send(net);
    };
    /**
     * 兑吧曝光埋点
     * @param {IExposureData} exposure
     */
    NetManager.prototype.showLog = function (exposure) {
        var net = {
            name: 'showLog',
            uri: exposure.domain + '/exposure/standard',
            type: 'get',
            dataType: 'jsonp',
            param: exposure,
            callback: null,
            hideMsg: true
        };
        this.send(net);
    };
    /**
      * 消息响应
      * @param net
      * @param result 结果
      */
    // protected onResponse(net: INetData, result: any): void {
    //     //数据处理
    //     const data: Data = DataManager.ins.updateData(net.name, result, net.param);
    //     //接口成功
    //     if (net.pollingCount && net.pollingCheck(data)) {
    //         net.pollingCount -= 1;
    //         //轮询接口特殊处理
    //         setTimeout(() => {
    //             this.send(net);
    //         }, 500);
    //     } else if (net.callback) {
    //         net.callback(data.success, data || result);
    //     }
    //     if (!data.success && !net.hideMsg) {
    //         GDispatcher.dispatchEvent(ABNetManager.ERROR, net, result.message || result.desc || result.msg);
    //     }
    //     if (!data.success) {
    //         this.onNotSuccess && this.onNotSuccess(result.message || result.desc || result.msg);
    //     }
    // }
    // onNotSuccess: Function;
    NetManager.prototype.onResponse = function (net, result) {
        var _this = this;
        //数据处理
        var data = DataManager_1.DataManager.ins.updateData(net.name, result, net.param);
        //接口成功
        if (net.pollingCount && net.pollingCheck(data)) {
            net.pollingCount -= 1;
            //轮询接口特殊处理
            setTimeout(function () {
                _this.send(net);
            }, 500);
        }
        else if (net.callback) {
            if (net.pollingCount === 0 && net.pollingCheck(data)) {
                net.callback(false, data || result);
                if (!net.hideMsg) {
                    GDispatcher_1.GDispatcher.dispatchEvent(ABNetManager_1.ABNetManager.ERROR, net, '网络开了个小差，请稍后再试!'); //result.message || result.desc || result.msg);
                }
            }
            else {
                net.callback(data.success, data || result);
            }
        }
        if (!data.success && !net.hideMsg) {
            GDispatcher_1.GDispatcher.dispatchEvent(ABNetManager_1.ABNetManager.ERROR, net, result.message || result.desc || result.msg);
        }
    };
    ;
    /**
     * 通讯底层错误
     * @param net
     * @param message
     */
    NetManager.prototype.onError = function (net) {
        if (net.callback) {
            net.callback(false);
        }
        if (!net.hideMsg) {
            GDispatcher_1.GDispatcher.dispatchEvent(ABNetManager_1.ABNetManager.ERROR, net);
        }
    };
    return NetManager;
}(ABNetManager_1.ABNetManager));
exports.NetManager = NetManager;
__reflect(NetManager.prototype, "\"e:/zqty/egret/libs/tw/manager/NetManager\".NetManager");
//# sourceMappingURL=NetManager.js.map