"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var GFun = (function () {
    function GFun() {
    }
    /**
     * 加载 html Image
     * @param url
     * @param callback
     */
    GFun.loadImage = function (url, callback) {
        //取出跟url匹配的Image
        var bitmapData = new Image();
        bitmapData.onload = function (e) {
            if (callback) {
                callback(bitmapData);
            }
        };
        bitmapData.src = url;
    };
    /**
     * 替换字符串中元素
     * @param str
     * @param replaceList
     */
    GFun.replace = function (str, replaceList) {
        var len = replaceList.length;
        for (var i = 0; i < len; i++) {
            str = str.replace("{" + i + "}", replaceList[i].toString());
        }
        return str;
    };
    /**
     * 是否在app内运行
     * @param strs 匹配字符串
     */
    GFun.checkInApp = function (strs) {
        var ua = navigator.userAgent.toLocaleLowerCase();
        var i;
        var len = strs.length;
        for (i = 0; i < len; i++) {
            if (ua.indexOf(strs[i]) != -1) {
                return true;
            }
        }
        return false;
    };
    Object.defineProperty(GFun, "isIOS", {
        /**
         * 判断操作系统
         * @returns {Array|{index: number, input: string}}
         */
        get: function () {
            return navigator.userAgent.match(/iphone|ipod|ipad/gi) != null;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * 获取url参数
     */
    GFun.getQueryString = function (name) {
        var reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)', 'i');
        var r = window.location.search.substr(1).match(reg);
        if (r != null) {
            return unescape(r[2]);
        }
        return null;
    };
    return GFun;
}());
exports.GFun = GFun;
__reflect(GFun.prototype, "\"e:/zqty/egret/libs/tc/util/GFun\".GFun");
exports.check_webp_feature = function () {
    var _support_webp_ = localStorage.getItem('_support_webp_');
    if (_support_webp_ !== null) {
        return _support_webp_ === '1';
    }
    var img = new Image();
    img.onload = function () {
        var result = (img.width > 0) && (img.height > 0);
        localStorage.setItem('_support_webp_', result ? '1' : '0');
    };
    img.onerror = function () {
        localStorage.setItem('_support_webp_', '0');
    };
    img.src = "data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA";
    return false;
};
// export const getImgURL = (url: string): any => {
//     const isSupport = check_webp_feature();
//     if (isSupport)
//         return url + '?x-oss-process=image/format,webp';
//     return url;
// } 
//# sourceMappingURL=GFun.js.map