"use strict";
var __reflect = (this && this.__reflect) || function (p, c, t) {
    p.__class__ = c, t ? t.push(c) : t = [c], p.__types__ = p.__types__ ? t.concat(p.__types__) : t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var GDispatcher = (function () {
    function GDispatcher() {
    }
    /**
     *
     * @param name 事件名
     * @param callback 回调
     * @param thisObj 作用域
     */
    GDispatcher.addEvent = function (name, callback, thisObj) {
        if (!this.callbackPool[name]) {
            this.callbackPool[name] = [];
            this.thisObjPool[name] = [];
        }
        var index = this.callbackPool[name].indexOf(callback);
        if (index != -1) {
            this.callbackPool[name][index] = callback;
            this.thisObjPool[name][index] = thisObj;
        }
        else {
            this.callbackPool[name].push(callback);
            this.thisObjPool[name].push(thisObj);
        }
    };
    /**
     *
     * @param name 事件名
     * @param callback 回调
     * @param thisObj 作用域
     */
    GDispatcher.removeEvent = function (name, callback, thisObj) {
        if (this.callbackPool[name]) {
            var index = this.callbackPool[name].indexOf(callback);
            if (index != -1) {
                this.callbackPool[name].splice(index, 1);
                this.thisObjPool[name].splice(index, 1);
            }
        }
    };
    /**
     * 派发事件
     * @param name 事件名
     * @param args 任意参数
     */
    GDispatcher.dispatchEvent = function (name) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        var callbacks = this.callbackPool[name];
        var thisObjs = this.thisObjPool[name];
        if (callbacks) {
            var i = 0;
            var len = callbacks.length;
            for (i; i < len; i++) {
                callbacks[i].apply(thisObjs[i], args);
            }
        }
    };
    /**
     * 事件回调池
     */
    GDispatcher.callbackPool = {};
    /**
     * 事件作用域池
     */
    GDispatcher.thisObjPool = {};
    return GDispatcher;
}());
exports.GDispatcher = GDispatcher;
__reflect(GDispatcher.prototype, "\"e:/zqty/egret/libs/tc/util/GDispatcher\".GDispatcher");
//# sourceMappingURL=GDispatcher.js.map