export default class River extends egret.Sprite {
    constructor() {
        super();
        this.start();
    }

    async start() {
        const t1 = await RES.getResAsync('river1_png');
        const pic1 = this.addpic(t1, 434, 493);
        egret.Tween.get(pic1, { loop: true }).to({ alpha: 1 }, 1000).to({ alpha: 0 }, 1000).wait(100);

        const t2 = await RES.getResAsync('river2_png');
        const pic2 = this.addpic(t2, 475, 450);
        egret.Tween.get(pic2, { loop: true }).to({ alpha: 1 }, 200)
            .to({ y: 450 + 200 }, 1500).to({ alpha: 0 }, 200).wait(100);

        const t3 = await RES.getResAsync('river3_png');
        const pic3 = this.addpic(t3, 353, 410);
        egret.Tween.get(pic3, { loop: true }).to({ alpha: 1 }, 200)
            .to({ y: 410 + 100, x: 353 - 20 }, 1500).to({ alpha: 0 }, 200).wait(100);

        const t4 = await RES.getResAsync('river4_png');
        const pic4 = this.addpic(t4, 496, 625);
        egret.Tween.get(pic4, { loop: true }).to({ alpha: 1 }, 200)
            .to({ y: 625 + 400 }, 2000).to({ alpha: 0 }, 400);

        const t5 = await RES.getResAsync('river5_png');
        const pic5 = this.addpic(t5, 260, 564);
        egret.Tween.get(pic5, { loop: true }).to({ alpha: 1 }, 100)
            .to({ y: 564 + 200, x: 260 - 40 }, 700).to({ alpha: 0 }, 100).wait(100);

        const t6 = await RES.getResAsync('river6_png');
        const pic6 = this.addpic(t6, 235, 845);
        egret.Tween.get(pic6, { loop: true }).to({ alpha: 1 }, 1000).to({ alpha: 0 }, 1000);

        const t7 = await RES.getResAsync('river7_png');
        const pic7 = this.addpic(t7, 419, 845);
        setTimeout(() => {
            egret.Tween.get(pic7, { loop: true }).to({ alpha: 1 }, 1000).to({ alpha: 0 }, 1000);
        }, 1000);
    }

    private addpic(texture: egret.Texture, x = 0, y = 0) {
        const pic = new egret.Bitmap(texture)
        this.addChild(pic);
        pic.x = x;
        pic.y = y;
        pic.alpha = 0;
        return pic;
    }
}