const path = require('path');
const config = {
    '/hdtool/ajaxElement': {
        data: 'ajaxElement'
    },
    // projectX
    '/projectx/getDomain.query': {
        data: 'getDomain'
    },
    '/projectx/{projectId}/{strategyId}.query': {
        data: 'queryPrizeList'
    },
    '/projectx/{projectId}/credits/creditsCost.do': {
        data: 'creditsCost'
    },
    '/projectx/{projectId}/credits/queryStatus.do': {
        data: 'queryStatus'
    },
    '/projectx/{projectId}/w7d23fd8b/doJoin.do': {
        data: 'getPrize'
    },
    '/projectx/{projectId}/prize.query': {
        data: 'queryPrizeInfo'
    },
    '/aaw/projectx/getCouponInfo': {
        data: 'getCouponInfo'
    },
    '/projectx/{projectId}/records.query': {
        data: 'queryRecords'
    },
    '/ctool/getProjectUserInfo': {
        data: 'getProjectUserInfo'
    },
    // qq输入法Emoji集集乐
    '/projectx/{projectId}/join_1/data.do':{
        data:'getCollectCards'
    },
    '/projectx/{projectId}/join_1/join.do':{
        data:'getCard'
    },
    '/projectx/{projectId}/assist_1/data.do':{
        data:'getHelpData'
    },
    '/projectx/{projectId}/assist_1/join.do':{
        data:'helpFriend'
    },
    '/projectx/{projectId}/join_2/join.do':{
        data:'mixCard'
    },

    // 屈臣氏
    '/projectx/{projectId}/w7d23fd8b/a03828e7a.do': {
        data: 'getCount'
    },
};

let projectId = 'pa2340903';
let strategyId = 'o0cd8610b';

for (let item in config) {
    if (config.hasOwnProperty(item)) {
        if (item.indexOf("{projectId}") !== -1 || item.indexOf("{strategyId}") !== -1) {
            let newKey = item.replace("{projectId}", projectId);
            newKey = newKey.replace("{strategyId}", strategyId);
            config[newKey] = config[item];
            delete config[item];
            item = newKey;
        }
        config[item].path = path.resolve(__dirname, "./json/" + config[item].data + ".json");
    }
}
module.exports = config;