import Scene from "../../MVC/views/Scene";
import { ModuleTypes } from "../../types/sceneTypes";
import TopLayerCtrl from "../../MVC/ctrls/topLayerCtrl";
import PanelCtrl from "../../MVC/ctrls/panelCtrl";
import EffectMgr from "../../MVC/ctrls/EffectMgr";
import { GTime } from "../../../libs/tc/util/GTime";
import { NetManager } from "../../../libs/tw/manager/NetManager";
import { getlogItem } from "../../getlogItem";
import Utils from "../../MVC/utils/Utils";
import tr = egret.sys.tr;
import userMock from "./UserMock";

export default class IndexScene extends Scene {
    public scroller: eui.Scroller;
    public titleGroup: eui.Group;
    public titleMask: eui.Rect;
    public sweepLight: eui.Image;
    public ruleBtn: eui.Button;
    public prizeBtn: eui.Button;
    public help_btn: eui.Button;
    public join_btn: eui.Button;
    public btnGroup: eui.Group;
    public maskGroup: eui.Group;
    public sweepLightBtn: eui.Image;
    public timesLabel: eui.Label;
    public scrollerGroup: eui.Group;
    public scrollerMask: eui.Rect;
    public scrollerLable1: eui.Label;
    public scrollerLable2: eui.Label;
    public emoji0: eui.Image;
    public emoji1: eui.Image;
    public emoji2: eui.Image;
    public emoji3: eui.Image;
    public emoji4: eui.Image;
    public emoji5: eui.Image;
    public emojiBg0: eui.Image;
    public emojiBg1: eui.Image;
    public emojiBg2: eui.Image;
    public emojiBg3: eui.Image;
    public emojiBg4: eui.Image;
    public emojiBg5: eui.Image;
    public emojiLabel0: eui.Label;
    public emojiLabel1: eui.Label;
    public emojiLabel2: eui.Label;
    public emojiLabel3: eui.Label;
    public emojiLabel4: eui.Label;
    public emojiLabel5: eui.Label;
    public box: eui.Image;
    public progressBar_fill: eui.Rect;
    public progressbar_bg: eui.Image;
    public progressbarLabel: eui.Label;
    public list: eui.List;
    public image: eui.Image;
    public downloadBtn: eui.Button;
    public osGroup: eui.Group;
    public osLabel: eui.Label;
    public browserGroup: eui.Group;


    // emoji表情
    private emojisId = ["sp_1", "sp_2", "sp_3", "sp_4", "sp_5", "sp_6"];
    private emojisData = {};

    private emoji0_enable = egret.Texture;
    private emoji1_enable = egret.Texture;
    private emoji2_enable = egret.Texture;
    private emoji3_enable = egret.Texture;
    private emoji4_enable = egret.Texture;
    private emoji5_enable = egret.Texture;

    private emoji0_disable = egret.Texture;
    private emoji1_disable = egret.Texture;
    private emoji2_disable = egret.Texture;
    private emoji3_disable = egret.Texture;
    private emoji4_disable = egret.Texture;
    private emoji5_disable = egret.Texture;

    // box
    private box_enable: egret.Texture;
    private box_disable: egret.Texture;

    // 表情包
    private img1: egret.Texture;
    private img2: egret.Texture;
    private imgIndex: number = 1;

    public get skinKey() {
        return 'IndexScene'
    }

    public get groupName() {
        return 'index_scene'
    }

    constructor(data?) {
        super(data);
    }


    initEvents() {
        this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTapRule, this);
        this.help_btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchHelp, this);
        this.join_btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchJoin, this);
        this.downloadBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchDownloadBtn, this);
        this.browserGroup.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchBrowserGroup, this);
    }

    onTouchBrowserGroup() {
        this.btnGroup.visible = false;
    }

    onTouchHelp() {
        PanelCtrl.instance.btnDelay(this.help_btn);
        NetManager.ins.clickLog(getlogItem(5));
        // 帮助，需要assistItemId
        let wx = navigator.userAgent.toLowerCase().indexOf('micromessenger') !== -1;
        if(wx) {
            this.browserGroup.visible = true;
        } else {
            let assistItemId = Utils.getRequestByKey("assistItemId") || "";
            window["goClient"](assistItemId);
            setTimeout(() => {
                window.location.href = window['helpDownLink'];
            }, 3000);
        }
    }

    onTouchJoin() {
        PanelCtrl.instance.btnDelay(this.join_btn);
        NetManager.ins.clickLog(getlogItem(6));
        let wx = navigator.userAgent.toLowerCase().indexOf('micromessenger') !== -1;
        if(wx) {
            this.browserGroup.visible = true;
        } else {
            window["goClient"]("");
            setTimeout(() => {
                window.location.href = window['joinDownLink'];
            }, 3000);
        }
    }

    onTouchDownloadBtn() {
        PanelCtrl.instance.btnDelay(this.downloadBtn);
        NetManager.ins.clickLog(getlogItem(7));
        ////////////////////////////////////////////////////////////////////////////////////////////////////////
        // 点击拉我按钮
        window.location.href = window['lawoDownLink'];
        ////////////////////////////////////////////////////////////////////////////////////////////////////////
    }


    private onTouchTapRule() {
        PanelCtrl.instance.btnDelay(this.ruleBtn);
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);
    }


    removeEvents() {
        this.ruleBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTapRule, this);
        this.help_btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchHelp, this);
        this.join_btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchJoin, this);
        this.downloadBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchDownloadBtn, this);
    }

    /**
     * 设置进度条
     * @param nowTypes - 当前已集种类数
     * @param totalTypes - 总共种类数
     */
    private setProgressBar(nowTypes: number, totalTypes: number = 6) {
        egret.Tween.get(this.progressBar_fill).to({
            width: this.progressbar_bg.width * nowTypes / 6
        }, nowTypes * 200).call(() => {
            if(nowTypes < 6) {
                this.progressbarLabel.text = `${nowTypes}/6`;
                this.box.source = this.box_disable;
            } else {
                this.progressbarLabel.text = "您已集齐全部卡片 点击礼物召唤大奖";
                egret.Tween.get(this.box).to({scaleX: 0, scaleY: 0}, 250, egret.Ease.sineInOut).call(() => {
                    this.box.source = this.box_enable;
                    egret.Tween.get(this.box).to({scaleX: 1, scaleY: 1}, 250, egret.Ease.sineInOut).call(() => {
                        EffectMgr.instance.heartbeatEffect(this.box, 1.1, 0.85, 300, 1000);
                    });
                });
            }
        });
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();
        this.checkOS();
        this.onLoad();
    }

    /**
     * 检查系统版本
     */
    private checkOS() {
        let os = navigator.userAgent.match(/ OS /)                          // 是否是 iOS
            || navigator.userAgent.match(/Android [4].[4-9](.[0-9])?/)      // 是否是 Android 4.4 - 4.9.9
            || navigator.userAgent.match(/Android [5-9](.[0-9])?(.[0-9])?/);   // 是否是 Android 5 - 5.9.9

        if(os && os[0] && os[0].indexOf(' OS ') > -1) {
            this.osLabel.text = "该活动仅支持安卓用户参与";
            this.osGroup.visible = true;
        } else if(os && os[0] && os[0].indexOf(' OS ') == -1) {
            console.log("Android 4.4 以上");
        } else {
            this.osGroup.visible = true;
            this.osLabel.text = "请尽快升级安卓系统版本参与活动";
        }
    }

    private check() {
        let os = navigator.userAgent.match(/ OS /)                          // 是否是 iOS
            || navigator.userAgent.match(/Android [4].[4-9](.[0-9])?/)      // 是否是 Android 4.4 - 4.9.9
            || navigator.userAgent.match(/Android [5-9](.[0-9])?(.[0-9])?/);   // 是否是 Android 5 - 5.9.9

        if(os && os[0] && os[0].indexOf(' OS ') > -1) {
            return false;
        } else if(os && os[0] && os[0].indexOf(' OS ') == -1) {
            return true;
        } else {
            return false;
        }
    }

    private easyScroller(obj1: any, obj2: any, duration: number) {
        let height = obj1.height;
        obj1.y = height + 7;
        obj2.y = height + 7;
        let name = userMock.nameList[~~(Math.random() * userMock.nameList.length)];
        let prize = userMock.prizeList[~~(Math.random() * userMock.prizeList.length)];
        obj1.text = `${Math.floor(GTime.getTimestamp() % 1000000000000 / 123456)}人正在集卡`;
        obj2.text = `${name}已集齐卡牌，抽中${prize}！`;
        egret.Tween.get(obj1).to({y: 2}, duration).wait(1500).call(() => {
            egret.Tween.get(obj1).to({y: -height-3}, duration).call(() => {
                egret.Tween.get(obj2).to({y: 2}, duration).wait(1500).call(() => {
                    egret.Tween.get(obj2).to({y: -height-3}, duration).call(() => {
                        this.easyScroller(obj1, obj2, duration);
                    });
                });
            });
        });
    }

    private initUI(): void {
        this.setProgressBar(0, 6);
        this.initEmojis({
            "sp_1": 0,
            "sp_2": 0,
            "sp_3": 0,
            "sp_4": 0,
            "sp_5": 0,
            "sp_6": 0
        });
        this.timesLabel.text = `今日    次数：3次`;
        this.scroller.height = 750 / window.outerWidth * window.outerHeight;
        this.initEffect();

        this.setImage();

        NetManager.ins.showLog(getlogItem(5));
        NetManager.ins.showLog(getlogItem(6));
        NetManager.ins.showLog(getlogItem(7));
    }

    private setImage() {
        setTimeout(() => {
            this.image.source = this[`img${this.imgIndex}`];
            this.imgIndex = (this.imgIndex == 1) ? 2 : 1;
            this.setImage();
        }, 500)
    }

    /**
     * 根据spMap初始化 Emojis
     * @param spMap - 卡牌的Map
     */
    private initEmojis(spMap) {
        for(let id in spMap) {
            if(spMap[id] > 0) {
                this.emojisData[id].emoji.source = this.emojisData[id].enable;
                this.emojisData[id].emojiBg.visible = true;
                this.emojisData[id].emojiLabel.visible = true;
                this.emojisData[id].emojiLabel.text = spMap[id];
            } else {
                this.emojisData[id].emoji.source = this.emojisData[id].disable;
                this.emojisData[id].emojiBg.visible = false;
                this.emojisData[id].emojiLabel.visible = false;
            }
        }
    }

    private initEffect() {
        EffectMgr.instance.breathingEffect(this.downloadBtn);

        // 滚动弹幕
        this.scrollerGroup.mask = this.scrollerMask;
        this.easyScroller(this.scrollerLable1, this.scrollerLable2, 1000);

        // 标题扫光
        this.btnGroup.mask = this.maskGroup;

        this.titleGroup.mask = this.titleMask;
        egret.Tween.get(this.sweepLight).to({x: 705}, 1500).wait(200).call(() => {
            this.btnSweepLight();
        });
    }

    private btnSweepLight() {
        egret.Tween.get(this.sweepLightBtn).to({x: 705}, 2500).wait(1000).call(() => {
            this.sweepLightBtn.x = -85;
            this.btnSweepLight();
        });
    }

    protected onLoad(): void {
        for(let i = 0; i < this.emojisId.length; i++) {
            this.emojisData[this.emojisId[i]] = {};
            this.emojisData[this.emojisId[i]]['emoji'] = this[`emoji${i}`];
            this.emojisData[this.emojisId[i]]['emojiBg'] = this[`emojiBg${i}`];
            this.emojisData[this.emojisId[i]]['emojiLabel'] = this[`emojiLabel${i}`];
            this.emojisData[this.emojisId[i]]['enable'] = this[`emoji${i}_enable`];
            this.emojisData[this.emojisId[i]]['disable'] = this[`emoji${i}_disable`];
        }
        this.initUI();
    }

    /**
     * 展示Toast
     * @param msg - 展示的消息
     */
    private showToast(msg) {
        TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg: msg});
    }

    protected async preLoadRes() {

        await this.loadEmoji(); // 加载emoji表情
        this.img1 = await RES.getResAsync('img1_png');
        this.img2 = await RES.getResAsync('img2_png');

        return new Promise(function(resolve, reject) {
            resolve();
        });
    }

    /**
     * 异步加载emoji表情
     */
    private async loadEmoji() {
        this.emoji0_enable = await RES.getResAsync('emoji_0_enable_png');
        this.emoji1_enable = await RES.getResAsync('emoji_1_enable_png');
        this.emoji2_enable = await RES.getResAsync('emoji_2_enable_png');
        this.emoji3_enable = await RES.getResAsync('emoji_3_enable_png');
        this.emoji4_enable = await RES.getResAsync('emoji_4_enable_png');
        this.emoji5_enable = await RES.getResAsync('emoji_5_enable_png');

        this.emoji0_disable = await RES.getResAsync('emoji_0_disable_png');
        this.emoji1_disable = await RES.getResAsync('emoji_1_disable_png');
        this.emoji2_disable = await RES.getResAsync('emoji_2_disable_png');
        this.emoji3_disable = await RES.getResAsync('emoji_3_disable_png');
        this.emoji4_disable = await RES.getResAsync('emoji_4_disable_png');
        this.emoji5_disable = await RES.getResAsync('emoji_5_disable_png');

        // box
        this.box_enable = await RES.getResAsync('box_enable_png');
        this.box_disable = await RES.getResAsync('box_disable_png');
    }
}