import { DataManager } from "../libs/tw/manager/DataManager";
import AssetAdapter from "./AssetAdapter";
import PanelCtrl from "./MVC/ctrls/panelCtrl";
import SceneCtrl from "./MVC/ctrls/sceneCtrl";
import Loading from "./Common/loading/Loading";
import ThemeAdapter from "./ThemeAdapter";
import { ModuleTypes } from "./types/sceneTypes";
import { getResPath } from "./utils";
import layers from "./MVC/views/layers";
import { PetIndexData } from "../libs/tw/data/pet/PetIndexData";
import { Buried } from '../libs/tw/util/Buried';
import LoadingScene from './Common/loadingScene/loadingScene';
import { GDispatcher } from '../libs/tc/util/GDispatcher';
import TopLayerCtrl from './MVC/ctrls/topLayerCtrl';
import ToastPanel from './Common/toastPanel/ToastPanel';

//////

import IndexScene from "./Scene/IndexScene/IndexScene";
import RulePanel from "./Panels/RulePanel/RulePanel";
import GameTipsPanel from "./Panels/GameTipsPanel/GameTipsPanel";
import { NetManager } from "../libs/tw/manager/NetManager";
import AudioCtrl from "./MVC/ctrls/AudioCtrl";
import GoClientPanel from "./Panels/GoClientPanel/GoClientPanel";
import { NetName } from "../libs/tw/enum/NetName";

//////

class Main extends eui.UILayer {
    private bgMusic: egret.Sound;
    protected createChildren(): void {
        super.createChildren();
        // alert(1)

        egret.lifecycle.addLifecycleListener((context) => {
            // custom lifecycle plugin
        });

        let assetAdapter = new AssetAdapter();
        egret.registerImplementation("eui.IAssetAdapter", assetAdapter);
        egret.registerImplementation("eui.IThemeAdapter", new ThemeAdapter());

        egret.ImageLoader.crossOrigin = "anonymous";

        DataManager.ins.petIndexData = new PetIndexData();
        DataManager.ins.petIndexData.update(window['CFG']);
        // NetManager.ins.getCredits(()=>{});

        layers.init(this);
        Loading.init(layers.topLayer);
        PanelCtrl.instance.init(layers.popupLayer);
        SceneCtrl.instance.init(layers.sceneLayer);
        TopLayerCtrl.instance.init(layers.topLayer);

        this.stage.scaleMode = egret.StageScaleMode.FIXED_WIDTH;

        SceneCtrl.instance.registerSceneClass(ModuleTypes.LOADING_SCENE, LoadingScene);

        ///////
        SceneCtrl.instance.registerSceneClass(ModuleTypes.INDEX_SCENE, IndexScene);

        PanelCtrl.instance.registerPanelClass(ModuleTypes.GAMETIPS_PANEL, GameTipsPanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.RULE_PANEL, RulePanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.GO_CLIENT_PANEL, GoClientPanel);

        //////

        TopLayerCtrl.instance.registerPanelClass(ModuleTypes.TOAST_PANEL, ToastPanel);

        this.runGame().catch(e => {
            console.log(e);
        })
    }

    private async runGame() {
        await this.loadResource()
        this.createGameScene();
        // RES.loadGroup("msg", 10);
    }

    private async loadResource() {
        try {
            // const loadingView = new LoadingUI();
            // this.stage.addChild(loadingView);
            await RES.loadConfig("default.res.json", getResPath() + "resource/");
            await this.loadTheme();

            // await RES.loadGroup("msg", 10);
            // this.stage.removeChild(loadingView);
        } catch(e) {
            console.error(e);
        }
    }

    private loadTheme() {
        return new Promise((resolve, reject) => {
            // load skin theme configuration file, you can manually modify the file. And replace the default skin.
            //加载皮肤主题配置文件,可以手动修改这个文件。替换默认皮肤。
            let theme = new eui.Theme("resource/default.thm.json", this.stage);
            theme.addEventListener(eui.UIEvent.COMPLETE, () => {
                resolve();
            }, this);

        })
    }

    private onError(net: any, desc: any, result): void {
        console.log(desc);
        console.log(result);
        var msg: string;
        var msgArr: any = window['errorMessage'];
        if(!isNaN(desc)) {
            msg = msgArr[desc] ? msgArr[desc] : '活动太火爆了，请稍后再来～';
        } else {
            msg = desc;
        }

        var code;
        if(result) {
            code = result.code;
        }
        if(code == "600001" || code == "100002") {
            this.showToast("昵称不符合，请重新输入");
        } else if(code == "0800101") {
            this.showToast("网络异常");
        } else {
            if(msg) {
                this.showToast(msg);
            } else {
                this.showToast("网络异常，请检查网络稍后重试");
            }
        }
    }

    showToast(val) {
        TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg: val});
    }

    /**
     * 创建场景界面
     * Create scene interface
     */
    protected createGameScene(): void {
        DataManager.ins.customCfgData = window["CFG"];
        this.getGameRes();
        NetManager.ins.getDomain((success) => {
            if(!success) {
                return;
            }
        });

        this.stage.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchStage, this);
        document.addEventListener("visibilitychange", () => {
            if(document.visibilityState == "visible") {
                AudioCtrl.resumeBgMusic();
            }

            if(document.visibilityState == "hidden") {
                AudioCtrl.stopBgMusic();
            }
        })
    }

    onTouchStage() {
        AudioCtrl.changeBgMusic(this.bgMusic);
        this.stage.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchStage, this);
    }

    //加载游戏中的资源
    private async getGameRes() {
        // await NetManager.ins.getProjectUserInfo((success)=>{
        //     if(!success){
        //         Buried.init(0);
        //         return;
        //     }
        //     Buried.init(DataManager.ins.getData(NetName.GET_PROJECTUSERINFO).data.consumerId);
        // });
        Buried.init(0);
        this.bgMusic = await RES.getResAsync('bg_sound_mp3');
        SceneCtrl.instance.change(ModuleTypes.LOADING_SCENE);

        await RES.loadGroup('common');
        GDispatcher.dispatchEvent('progress', [10]);

        await RES.loadGroup('loading');
        GDispatcher.dispatchEvent('progress', [20]);

        await RES.loadGroup('index_scene');
        await RES.loadGroup('rule_panel');
        GDispatcher.dispatchEvent('progress', [35]);

        await RES.loadGroup('gameTips_panel');
        GDispatcher.dispatchEvent('progress', [50]);

        await RES.loadGroup('loading_scene');
        GDispatcher.dispatchEvent('progress', [65]);

        GDispatcher.dispatchEvent('progress', [80]);

        GDispatcher.dispatchEvent('progress', [90]);

        GDispatcher.dispatchEvent('progress', [100]);
    }
}

window['Main'] = Main;