var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import ComponentBase from "./components/ComponentBase";
import Loading from "../../Common/loading/Loading";
var Panel = /** @class */ (function (_super) {
    __extends(Panel, _super);
    function Panel(data, hasMask) {
        if (hasMask === void 0) { hasMask = true; }
        var _this = _super.call(this, data) || this;
        _this.hasMask = hasMask;
        return _this;
    }
    /**
     *
     * @param hasColor true 有颜色  false为没有颜色
     */
    Panel.prototype.setMask = function () {
        if (!this.pMask) {
            var rate = document.body.clientHeight / document.body.clientWidth;
            this.pMask = new egret.Shape();
            this.pMask.graphics.beginFill(0, 0.8);
            this.pMask.graphics.drawRect(0, 0, 750, 750 * rate);
            this.pMask.graphics.endFill();
            this.addChildAt(this.pMask, 0);
            this.pMask.touchEnabled = false;
        }
    };
    Panel.prototype.setShowAct = function () {
        this.alpha = 0;
        // this.y = document.body.clientHeight;
        // this.scaleY = 0;
        egret.Tween.get(this).to({ alpha: 1 }, 300);
    };
    Panel.prototype.initEvents = function () {
        var _this = this;
        if (this.closeBtns && this.closeBtns.length > 0) {
            this.closeBtns.forEach(function (btn) { if (btn)
                btn.addEventListener(egret.TouchEvent.TOUCH_TAP, _this.onTouchTap, _this); });
        }
        if (this.confirmBtns && this.confirmBtns.length > 0) {
            this.confirmBtns.forEach(function (btn) { if (btn)
                btn.addEventListener(egret.TouchEvent.TOUCH_TAP, _this.onTouchTap, _this); });
        }
        if (this.creditsOutBtns && this.creditsOutBtns.length > 0) {
            this.creditsOutBtns.forEach(function (btn) { if (btn)
                btn.addEventListener(egret.TouchEvent.TOUCH_TAP, _this.creditsOut, _this); });
        }
    };
    Panel.prototype.removeEvents = function () {
        var _this = this;
        if (this.closeBtns && this.closeBtns.length > 0) {
            this.closeBtns.forEach(function (btn) { if (btn)
                btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, _this.onTouchTap, _this); });
        }
        if (this.confirmBtns && this.confirmBtns.length > 0) {
            this.confirmBtns.forEach(function (btn) { if (btn)
                btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, _this.onTouchTap, _this); });
        }
        if (this.creditsOutBtns && this.creditsOutBtns.length > 0) {
            this.creditsOutBtns.forEach(function (btn) { if (btn)
                btn.removeEventListener(egret.TouchEvent.TOUCH_TAP, _this.creditsOut, _this); });
        }
    };
    Panel.prototype.onSkinComplete = function () {
        _super.prototype.onSkinComplete.call(this);
        Loading.instace.hide();
        this.setMask();
        if (!this.hasMask) {
            this.pMask.alpha = 0;
        }
        // console.log('this.pMask' + this.hasMask);
        this.setShowAct();
    };
    Object.defineProperty(Panel.prototype, "closeBtns", {
        get: function () { return [this['closeBtn']]; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Panel.prototype, "confirmBtns", {
        get: function () { return [this['confirmBtn']]; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Panel.prototype, "creditsOutBtns", {
        get: function () { return [this['creditsOutBtn']]; },
        enumerable: true,
        configurable: true
    });
    Panel.prototype.onTouchTap = function () {
        this.hidePanel();
    };
    Panel.prototype.hidePanel = function () {
        this.destroy();
        this.dispatchEvent(new egret.Event('onDestroy'));
    };
    Panel.prototype.creditsOut = function () {
        this.destroy();
        this.dispatchEvent(new egret.Event('onCreditsOut'));
    };
    return Panel;
}(ComponentBase));
export default Panel;
