export default class Utils {

    private static _instance: Utils;
    public static get instance() {
        return Utils._instance || (Utils._instance = new Utils());
    }

    constructor() {

    }

    /**
     * 加载Svga动画
     * @param url 资源地址
     * @param loop 是否循环播放
     * @param call 回调函数
     * @param parent 父节点
     */
    public static loadSvga(url: string, loop: boolean, parent?: egret.DisplayObjectContainer, call?: Function) {
        return new Promise((resolve, reject) => {
            const parser = new window["SVGA"].Parser();
            parser.load(url, (videoItem) => {
                const mv = new window["SVGA"].EgretMovieClip(videoItem);

                mv.gotoAndPlay(1, loop ? -1 : 1);
                if(parent) {
                    parent.addChild(mv);
                }

                mv.addEventListener(egret.Event.COMPLETE, () => {
                    if(call) {   // 有回调就调用
                        call();
                    }
                    if(!loop) {    // 不重复就删除
                        mv.stop();
                        parent.removeChild(mv);
                    }
                }, this);

                resolve(mv);

            }, (error) => {
                reject(error.message);
            })
        });
    };

    /**
     * 对象/数组 深拷贝
     * @param {Object} src - 来源对象
     * @param {Object} dst - 目标对象
     * @returns {Object} obj - 拷贝完成的对象
     */
    public static deepClone(src, dst = undefined) {
        var _obj = dst || (src instanceof Array ? [] : {});
        for(let key in src) {
            let prop = src[key];
            if(prop === _obj) { // 避免相互引用对象导致死循环，如src.a = dst的情况
                continue;
            }
            _obj[key] = ((typeof prop === 'object') ? this.deepClone(prop) : _obj[key] = prop);
            // if (typeof prop === 'object') { // 如果这是个对象则递归调用
            //     _obj[key] = _deepClone(prop);
            // } else {
            //     _obj[key] = prop;
            // }
        }
        return _obj;
    };


    /**
     * 获取连接上的参数，以对象的形式返回
     * @constructor
     */
    public static getRequest() {
        const url = location.search;   //获取url中"?"符后的字串
        let theRequest = {};
        if(url.indexOf("?") != -1) {
            let str = url.substr(1);
            let strs = str.split("&");
            for(let i = 0; i < strs.length; i++) {
                theRequest[strs[i].split("=")[0]] = unescape(strs[i].split("=")[1]);
            }
        }
        return theRequest;
    }


    /**
     * 根据参数名获取连接上的参数值
     * @param key 参数名
     * @constructor
     */
    public static getRequestByKey(key) {
        const request = this.getRequest();
        return request[key] || null;
        // const url = location.search;
        // let theRequest = {};
        // if (url.indexOf("?") != -1)
        // {
        //     let str = url.substr(1);
        //     let strs = str.split("&");
        //     for (let i = 0; i < strs.length; i++)
        //     {
        //         theRequest[strs[i].split("=")[0]] = unescape(strs[i].split("=")[1]);
        //     }
        // }
        // return theRequest[key];
    }

    /**
     * 产生一个固定范围的随机数(左闭右开)
     * @param start
     * @param end
     */
    public static Random(start: number, end: number) {
        return Math.random() * (end - start) + start;
    }

    /**
     * 产生一个固定范围的随机整数(左闭右开)
     * @param start
     * @param end
     */
    public static RandomInt(start: number, end: number) {
        return Math.floor(Math.random() * (end - start) + start);
    }

    /**
     * obj是否在array中
     * @param obj
     * @param array
     */
    public static isInArray(obj: any, array: any[]) {
        for(let i in array) {
            if(obj == array[i]) {
                return true;
            }
        }
        return false;
    }
}