import Scene from "../../MVC/views/Scene";
import { ModuleTypes } from "../../types/sceneTypes";
import { GDispatcher } from "../../../libs/tc/util/GDispatcher";
import SceneCtrl from "../../MVC/ctrls/sceneCtrl";
import Loading from "../loading/Loading";
import EffectMgr from "../../MVC/ctrls/EffectMgr";
import AudioCtrl from "../../MVC/ctrls/AudioCtrl";

export default class LoadingScene extends Scene {

    public percentLb: eui.Label;
    public progressBar_fill: eui.Rect;
    public progressBar_bg: eui.Image;
    public emoji: eui.Image;
    public hongbao1: eui.Image;
    public hongbao2: eui.Image;

    private lastVal: number;

    public get skinKey() {
        return 'LoadingScene'
    }

    public get groupName() {
        return 'loading_scene'
    }

    constructor(data?) {
        super(data);
        if(data) {

        }
        this.percentHeight = 100;

        this.lastVal = 0;
    }

    initEvents() {
        GDispatcher.addEvent('progress', this.setProgress, this);//626 117
    }

    removeEvents() {
        GDispatcher.removeEvent('progress', this.setProgress, this);
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();
        // Loading.instace.show()
        this.onLoad();
    }

    start(data?) {

    }

    protected onLoad(): void {
        this.initUI();
    }

    private initUI(): void {
        //初始化数据
        this.initData();
        this.initEffect();
    }

    private initEffect() {
        this.hongbaoEffect(this.hongbao1, 15, -5, 150);
        this.hongbaoEffect(this.hongbao2, 15, 5, 150);
        EffectMgr.instance.rotationForever(this.emoji, 1000);
    }

    private hongbaoEffect(obj: any, height: number, rotation: number, duration: number) {
        EffectMgr.instance.jumpOnce(obj, height, rotation, duration, 0, () => {
            EffectMgr.instance.jumpOnce(obj, height, rotation, duration, 1000, () => {
                this.hongbaoEffect(obj, height, rotation, duration);
            });
        });
    }

    private initData(): void {

    }

    private setProgress(data): void {
        let v = data[0];
        let time = 450;
        let t = v / 50 * 1000;
        // 移除缓动
        egret.Tween.removeTweens(this.progressBar_fill);
        egret.Tween.removeTweens(this.emoji);
        EffectMgr.instance.rotationForever(this.emoji, 1000);
        egret.Tween.get(this.progressBar_fill).to({width: this.progressBar_bg.width * v / 100}, t).call(() => {
            setTimeout(() => {
                if(v >= 100) {
                    Loading.instace.hide();
                    //this.goLastScene()
                    SceneCtrl.instance.change(ModuleTypes.INDEX_SCENE);
                }
            }, 500);
        });
        let _x = this.progressBar_bg.width * v / 100 + 174;
        egret.Tween.get(this.emoji).to({x: _x}, t);
        this.lastVal = v;
        this.percentLb.text = v + '%';
    }

    protected async preLoadRes() {
        AudioCtrl.changeBgMusic(await RES.getResAsync('bg_sound_mp3'));
        return new Promise(function(resolve, reject) {
            resolve();
        });
    }
}