import { DataManager } from './../manager/DataManager';
// import { IExposureData } from '..';
var Buried = /** @class */ (function () {
    function Buried() {
    }
    /**
     * 初始化
     */
    Buried.init = function () {
        if (DataManager.ins.customCfgData) {
            this.appId = DataManager.ins.customCfgData.appId;
            this.consumerId = DataManager.ins.customCfgData.consumerId;
            this.oaId = DataManager.ins.customCfgData.oaId;
        }
        else if (DataManager.ins.petIndexData && DataManager.ins.petIndexData.appId && DataManager.ins.petIndexData.activityId) {
            this.appId = DataManager.ins.petIndexData.appId;
            this.consumerId = DataManager.ins.petIndexData.consumerId;
            this.oaId = DataManager.ins.petIndexData.activityId;
        }
        else if (DataManager.ins.petsIndexData && DataManager.ins.petsIndexData.appId && DataManager.ins.petsIndexData.activityId) {
            this.appId = DataManager.ins.petsIndexData.appId;
            this.consumerId = DataManager.ins.petsIndexData.consumerId;
            this.oaId = DataManager.ins.petsIndexData.activityId;
        }
    };
    /**
     * 创建dpm埋点数据
     * @param {string} dpm 点击埋点
     * @param {string} dcm 曝光埋点
     * @param {string} embedDomain 埋点域名
     * @returns {{dpm: string; consumerId: number; domain: string; appId: number}}
     */
    Buried.createExposure = function (dpm, dcm, embedDomain) {
        if (embedDomain === void 0) { embedDomain = '//embedlog.duiba.com.cn'; }
        var exposure = {
            dpm: dpm,
            dcm: dcm,
            consumerId: Buried.consumerId,
            appId: Buried.appId,
            domain: embedDomain
        };
        return exposure;
    };
    /**
     * dpm拼接
     * @param pageId 页面ID
     * @param area 区域
     * @param dpm 埋点号
     * @returns {string}
     */
    Buried.connectDpm = function (pageId, area, dpm) {
        return DataManager.ins.customCfgData.appId + '.' + pageId + '.' + area + '.' + dpm;
    };
    /**
     * dcm拼接
     * @param typeId 类型ID
     * @param contentInfo 内容信息
     * @param dcm 埋点号
     * @returns {string}
     */
    Buried.connectDcm = function (typeId, contentInfo, dcm) {
        return typeId + '.' + DataManager.ins.customCfgData.oaId + '.' + contentInfo + '.' + dcm;
    };
    /**
     * 插件dcm拼接
     * @param plugId 插件ID
     * @param type 1 活动工具 2 主会场 4 楼层 5 游戏 7 子页面
     * @returns {string}
     */
    Buried.connectPlugDcm = function (plugId, type) {
        return 212 + '.' + plugId + '.' + type + '.' + Buried.oaId;
    };
    /**
     * 活动dcm拼接
     * @param type 1 活动工具 2 主会场 4 楼层 5 游戏 7 子页面
     * @returns {string}
     */
    Buried.connectActivityDcm = function (type) {
        return 202 + '.' + Buried.oaId + '.' + type + '.' + Buried.oaId;
    };
    return Buried;
}());
export { Buried };
