var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { GameModel } from '../common/GameModel';
import { DataManager } from './../../manager/DataManager';
import { TwLang } from '../../util/TwLang';
import { GFun } from '../../../tc/util/GFun';
var GameWinnerModel = /** @class */ (function (_super) {
    __extends(GameWinnerModel, _super);
    function GameWinnerModel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * 排名文案
     * @param rankStr
     */
    GameWinnerModel.prototype.getRankTxt = function (rankStr) {
        if (rankStr === void 0) { rankStr = TwLang.lang_020; }
        if (DataManager.ins.winRanksData.consumer.rank == "?") {
            return GFun.replace(TwLang.lang_019, [DataManager.ins.winRanksData.consumer.rank || '0']);
        }
        return GFun.replace(rankStr, [DataManager.ins.winRanksData.consumer.rank]);
    };
    /**
     * 奖品文案
     * @param winningStr
     * @param notWinningStr
     * @param notJoinStr
     */
    GameWinnerModel.prototype.getOptionTxt = function (winningStr, notWinningStr, notJoinStr) {
        if (winningStr === void 0) { winningStr = TwLang.lang_021; }
        if (notWinningStr === void 0) { notWinningStr = TwLang.lang_022; }
        if (notJoinStr === void 0) { notJoinStr = TwLang.lang_024; }
        var str;
        //是否参与过游戏
        if (DataManager.ins.winRanksData.consumer.join) {
            //是否中奖
            if (DataManager.ins.winRanksData.consumer.option) {
                str = GFun.replace(winningStr, [DataManager.ins.winRanksData.consumer.option]);
            }
            else {
                str = notWinningStr;
            }
        }
        else {
            str = notJoinStr;
        }
        return str;
    };
    /**
     * 用户ID文案
     * @param str
     */
    GameWinnerModel.prototype.getConsumerTxt = function (str) {
        if (str === void 0) { str = TwLang.lang_023; }
        return GFun.replace(str, [DataManager.ins.winRanksData.consumer.cid]);
    };
    Object.defineProperty(GameWinnerModel.prototype, "rankList", {
        /**
         * 排行列表
         */
        get: function () {
            return DataManager.ins.winRanksData.rankList;
        },
        enumerable: true,
        configurable: true
    });
    return GameWinnerModel;
}(GameModel));
export { GameWinnerModel };
