var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { GameModel } from '../common/GameModel';
import { DataManager } from './../../manager/DataManager';
import { TwLang } from '../../util/TwLang';
import { GFun } from '../../../tc/util/GFun';
// import { IUserData } from '../../data/game/common/IUserData';
var GameRealTimeRankModel = /** @class */ (function (_super) {
    __extends(GameRealTimeRankModel, _super);
    function GameRealTimeRankModel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * 我得排行文案
     * @param inRankStr
     * @param unitName 单位
     * @param outRankStr
     */
    GameRealTimeRankModel.prototype.getRankTxt = function (inRankStr, unitName, outRankStr) {
        if (inRankStr === void 0) { inRankStr = TwLang.lang_015; }
        if (unitName === void 0) { unitName = TwLang.lang_016; }
        if (outRankStr === void 0) { outRankStr = TwLang.lang_014; }
        var str;
        if (DataManager.ins.realTimeRankData.myUserData && DataManager.ins.realTimeRankData.myUserData.rank) {
            str = GFun.replace(inRankStr, [DataManager.ins.realTimeRankData.myUserData.maxScore, unitName, DataManager.ins.realTimeRankData.myUserData.rank]);
        }
        else {
            str = outRankStr;
        }
        return str;
    };
    Object.defineProperty(GameRealTimeRankModel.prototype, "userList", {
        /**
         * 用户列表
         */
        get: function () {
            return DataManager.ins.realTimeRankData.userList;
        },
        enumerable: true,
        configurable: true
    });
    return GameRealTimeRankModel;
}(GameModel));
export { GameRealTimeRankModel };
