var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { NetManager } from './../../manager/NetManager';
import { DataManager } from './../../manager/DataManager';
import { GameModel } from '../common/GameModel';
import { GMath } from '../../../tc/util/GMath';
import { GCache } from '../../../tc/util/GCache';
// import { IDynamicData } from '../../data/game/datapash/IDynamicData';
var GamePlayModel = /** @class */ (function (_super) {
    __extends(GamePlayModel, _super);
    function GamePlayModel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    GamePlayModel.prototype.update = function () {
        this.dynamics = [];
        this.allDynamics = [];
        this.datapashCount = 0;
    };
    /**
     * 是否达到阶段提交的条件
     */
    GamePlayModel.prototype.checkDatapash = function (score) {
        var interfaceLimit = DataManager.ins.gameCfgData.defenseStrategy.interfaceLimit || 50;
        var scoreUnit = DataManager.ins.gameCfgData.defenseStrategy.scoreUnit;
        var nextDatapashScore = score - this.datapashCount * scoreUnit;
        if (nextDatapashScore >= scoreUnit && this.datapashCount < interfaceLimit) {
            return true;
        }
        return false;
    };
    /**
     * 阶段提交
     * @param net
     */
    GamePlayModel.prototype.datapash = function () {
        var dynamicStr = JSON.stringify(this.dynamics);
        this.allDynamics.push(this.dynamics);
        this.datapashData(null, dynamicStr);
        this.dynamics = [];
        this.datapashCount++;
    };
    /**
     * 添加防作弊数据
     * @param dynamic
     */
    GamePlayModel.prototype.addDynamic = function (dynamic) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        this.dynamics.push(dynamic);
    };
    /**
     * 缓存最高分
     */
    GamePlayModel.prototype.cacheMaxScore = function (score) {
        //将最高纪录缓存
        var maxScore = GMath.int(GCache.readCache("maxScore"));
        if (!maxScore) {
            maxScore = 0;
        }
        maxScore = Math.max(maxScore, score);
        GCache.writeCache('maxScore', maxScore);
    };
    /**
     * 复活操作
     * @param callback
     * @param collectRuleId  集卡规则id
     * @param itemId  复活卡id
     */
    GamePlayModel.prototype.doRevive = function (callback, collectRuleId, itemId) {
        if (window['requirelogin']) {
            window['requirelogin']();
            return;
        }
        NetManager.ins.doRevive(function (success) {
            callback(success);
        }, collectRuleId, itemId);
    };
    /**
     * 获得复活次数
     * @param callback
     * @param collectRuleId  集卡规则id
     * @param itemId  复活卡id
     */
    GamePlayModel.prototype.getReviveCardNum = function (callback, collectRuleId, itemId) {
        if (window['requirelogin']) {
            window['requirelogin']();
            return;
        }
        NetManager.ins.getReviveCardNum(function (success) {
            callback(success);
        }, collectRuleId, itemId);
    };
    /**
     * 提交游戏成绩
     * @param callback
     * @param score 得分
     * @param checkScore  是否校验得分
     * @param customizedType 定制类型 1推币机
     */
    GamePlayModel.prototype.submit = function (callback, score, checkScore, customizedType) {
        this.allDynamics.push(this.dynamics);
        this.gameSubmitData(callback, score, this.allDynamics, checkScore, customizedType);
        this.dynamics = [];
    };
    Object.defineProperty(GamePlayModel.prototype, "gameIsWinning", {
        /**
         * 游戏结束弹窗
         */
        get: function () {
            return DataManager.ins.gameGetSubmitResultData.lottery ? true : false;
        },
        enumerable: true,
        configurable: true
    });
    return GamePlayModel;
}(GameModel));
export { GamePlayModel };
