var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { GameModel } from '../common/GameModel';
import { DataManager } from '../../manager/DataManager';
import { TwLang } from '../../util/TwLang';
import { GFun } from '../../../tc/util/GFun';
// import { IGameOptionData } from '../../data/game/getOptions/IGameOptionData';
var GameOptionModel = /** @class */ (function (_super) {
    __extends(GameOptionModel, _super);
    function GameOptionModel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * 活动结束时间
     */
    GameOptionModel.prototype.getEndTimeTxt = function (endTimeTxt, openPrizeTimeTxt) {
        if (endTimeTxt === void 0) { endTimeTxt = TwLang.lang_012; }
        if (openPrizeTimeTxt === void 0) { openPrizeTimeTxt = TwLang.lang_013; }
        var str;
        str = GFun.replace(endTimeTxt, [DataManager.ins.gameCfgData.gameInfo.offDate]);
        if (DataManager.ins.gameCfgData.gameInfo.rankPrize) {
            str += "\n" + openPrizeTimeTxt;
        }
        return str;
    };
    Object.defineProperty(GameOptionModel.prototype, "optionList", {
        /**
         * 奖品列表
         */
        get: function () {
            return DataManager.ins.getOptionsData.optionList;
        },
        enumerable: true,
        configurable: true
    });
    return GameOptionModel;
}(GameModel));
export { GameOptionModel };
