var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { GameModel } from '../common/GameModel';
import { DataManager } from './../../manager/DataManager';
import { TwLang } from '../../util/TwLang';
import { GFun } from '../../../tc/util/GFun';
var GameLoseModel = /** @class */ (function (_super) {
    __extends(GameLoseModel, _super);
    function GameLoseModel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(GameLoseModel.prototype, "costTxt", {
        /**
         * 剩余次数文案
         */
        get: function () {
            return DataManager.ins.getInfoData.status.text;
        },
        enumerable: true,
        configurable: true
    });
    /**
    * 排名文案
    * @param str
    */
    GameLoseModel.prototype.getRankTxt = function (str) {
        if (str === void 0) { str = TwLang.lang_018; }
        return GFun.replace(str, [DataManager.ins.getInfoData.rank]);
    };
    /**
     * 排名百分比
     * @param str
     */
    GameLoseModel.prototype.getPercentageTxt = function (str) {
        if (str === void 0) { str = TwLang.lang_017; }
        return GFun.replace(str, [DataManager.ins.getInfoData.percentage]);
    };
    /**
     * 当前得分文案
     * @param str
     */
    GameLoseModel.prototype.getCurrScoreTxt = function (str) {
        if (str === void 0) { str = TwLang.lang_009; }
        return GFun.replace(str, [DataManager.ins.gameGetSubmitResultData.score]);
    };
    /**
     * 获取最高积分
     * @param maxStr
     * @param totalStr
     */
    GameLoseModel.prototype.getMaxScoreTxt = function (maxStr, totalStr) {
        if (maxStr === void 0) { maxStr = TwLang.lang_010; }
        if (totalStr === void 0) { totalStr = TwLang.lang_011; }
        var str;
        if (DataManager.ins.gameCfgData.gameInfo.openTotalScoreSwitch) {
            str = GFun.replace(totalStr, [DataManager.ins.getInfoData.totalScore]);
        }
        else {
            str = GFun.replace(maxStr, [DataManager.ins.getInfoData.maxScore]);
        }
        return str;
    };
    return GameLoseModel;
}(GameModel));
export { GameLoseModel };
