var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { DataManager } from '../../manager/DataManager';
import { TwLang } from '../../util/TwLang';
import { CustomModel } from './../common/CustomModel';
import { GFun } from '../../../tc/util/GFun';
/**
 * 自定义活动工具玩法模型
 */
var CustomPlayModel = /** @class */ (function (_super) {
    __extends(CustomPlayModel, _super);
    function CustomPlayModel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(CustomPlayModel.prototype, "countTxt", {
        /**
         * 次数文案
         */
        get: function () {
            var str;
            switch (DataManager.ins.ajaxElementData.element.status) {
                case 0:
                    break;
                case 1:
                    str = TwLang.lang_002;
                    break;
                case 3:
                    str = TwLang.lang_004 + TwLang.lang_003;
                    break;
                case 4:
                    str = TwLang.lang_003;
                    break;
                case 5:
                    str = TwLang.lang_004 + GFun.replace(TwLang.lang_005, [DataManager.ins.ajaxElementData.element.freeLimit]);
                    break;
                case 6:
                    str = GFun.replace(TwLang.lang_006, [DataManager.ins.ajaxElementData.element.needCredits, DataManager.ins.customCfgData.unitName]);
                    break;
                case 7:
                    str = GFun.replace(TwLang.lang_005, [DataManager.ins.ajaxElementData.element.freeLimit]);
                    break;
                case 18:
                    str = TwLang.lang_007;
                    break;
            }
            return str;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(CustomPlayModel.prototype, "optionList", {
        /**
         * 奖品列表
         */
        get: function () {
            return DataManager.ins.ajaxElementData.options;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(CustomPlayModel.prototype, "rule", {
        /**
         * 活动规则
         */
        get: function () {
            return DataManager.ins.ajaxElementData.rule;
        },
        enumerable: true,
        configurable: true
    });
    return CustomPlayModel;
}(CustomModel));
export { CustomPlayModel };
